package s11abilityrandomizer;

import java.io.*;
import java.util.*;

/**
 *
 * @author Peter
 */
public class Database {

    private List<String> surname = new ArrayList<String>();
    private List<String> maleGivenName = new ArrayList<String>();
    private List<String> femaleGivenName = new ArrayList<String>();
    private List<String> maleName = new ArrayList<String>();
    private List<String> femaleName = new ArrayList<String>();
    private List<Integer> maleFace = new ArrayList<Integer>();
    private List<Integer> femaleFace = new ArrayList<Integer>();
    private List<Integer> maleFaceA = new ArrayList<Integer>();
    private List<Integer> maleFaceM = new ArrayList<Integer>();
    private List<Integer> maleFaceU = new ArrayList<Integer>();
    private List<Integer> femaleFaceA = new ArrayList<Integer>();
    private List<Integer> femaleFaceM = new ArrayList<Integer>();
    private List<Integer> male3D = new ArrayList<Integer>();
    private List<Integer> female3D = new ArrayList<Integer>();
    private List<Integer> male3DA = new ArrayList<Integer>();
    private List<Integer> male3DM = new ArrayList<Integer>();
    private List<Integer> female3DA = new ArrayList<Integer>();
    private List<Integer> female3DM = new ArrayList<Integer>();

    private static List<String> readLines(BufferedReader r) throws IOException {
        List<String> s = new ArrayList<String>();
        while (true) {
            String line = r.readLine();
            if (line == null) {
                break;
            }
            s.add(line);
        }
        return s;
    }

    public Database(boolean shuffleLists, boolean useNamelist, String encoding) throws IOException {
        //Read in data file
        String s;

        if (!useNamelist) {
            BufferedReader surnameFile = new BufferedReader(new InputStreamReader(new FileInputStream((encoding.equals("GBK") ? "GBK/" : "") + "surname.txt"), encoding));

            surname = readLines(surnameFile);

            BufferedReader malegivennameFile = new BufferedReader(new InputStreamReader(new FileInputStream((encoding.equals("GBK") ? "GBK/" : "") + "malegivenname.txt"), encoding));

            maleGivenName = readLines(malegivennameFile);

            BufferedReader femalegivennameFile = new BufferedReader(new InputStreamReader(new FileInputStream((encoding.equals("GBK") ? "GBK/" : "") + "femalegivenname.txt"), encoding));

            femaleGivenName = readLines(femalegivennameFile);

            //set to null for, well, make exception thrown!
            maleName = null;
            femaleName = null;
        } else {
            surname = null;
            maleGivenName = null;
            femaleGivenName = null;

            BufferedReader malenameFile = new BufferedReader(new InputStreamReader(new FileInputStream((encoding.equals("GBK") ? "GBK/" : "") + "malename.txt"), encoding));
            
            maleName = readLines(malenameFile);
     
            BufferedReader femalenameFile = new BufferedReader(new InputStreamReader(new FileInputStream((encoding.equals("GBK") ? "GBK/" : "") + "femalename.txt"), encoding));

            femaleName = readLines(femalenameFile);
        }

        BufferedReader maleFaceAFile = new BufferedReader(new FileReader("maleFaceA.txt"));

        while (true) {
            s = maleFaceAFile.readLine();
            if (s == null) {
                break;
            }
            maleFace.add(Integer.parseInt(s));
            maleFaceA.add(Integer.parseInt(s));
        }

        BufferedReader maleFaceMFile = new BufferedReader(new FileReader("maleFaceM.txt"));

        while (true) {
            s = maleFaceMFile.readLine();
            if (s == null) {
                break;
            }
            maleFace.add(Integer.parseInt(s));
            maleFaceM.add(Integer.parseInt(s));
        }

        BufferedReader male3DAFile = new BufferedReader(new FileReader("male3DA.txt"));

        while (true) {
            s = male3DAFile.readLine();
            if (s == null) {
                break;
            }
            male3D.add(Integer.parseInt(s));
            male3DA.add(Integer.parseInt(s));
        }

        BufferedReader male3DMFile = new BufferedReader(new FileReader("male3DM.txt"));

        while (true) {
            s = male3DMFile.readLine();
            if (s == null) {
                break;
            }
            male3D.add(Integer.parseInt(s));
            male3DM.add(Integer.parseInt(s));
        }

        BufferedReader maleFaceUFile = new BufferedReader(new FileReader("maleFaceU.txt"));

        while (true) {
            s = maleFaceUFile.readLine();
            if (s == null) {
                break;
            }
            maleFace.add(Integer.parseInt(s));
            maleFaceU.add(Integer.parseInt(s));
        }

        BufferedReader femaleFaceAFile = new BufferedReader(new FileReader("femaleFaceA.txt"));

        while (true) {
            s = femaleFaceAFile.readLine();
            if (s == null) {
                break;
            }
            femaleFace.add(Integer.parseInt(s));
            femaleFaceA.add(Integer.parseInt(s));
        }

        BufferedReader femaleFaceMFile = new BufferedReader(new FileReader("femaleFaceM.txt"));

        while (true) {
            s = femaleFaceMFile.readLine();
            if (s == null) {
                break;
            }
            femaleFace.add(Integer.parseInt(s));
            femaleFaceM.add(Integer.parseInt(s));
        }

        BufferedReader female3DAFile = new BufferedReader(new FileReader("female3DA.txt"));

        while (true) {
            s = female3DAFile.readLine();
            if (s == null) {
                break;
            }
            female3D.add(Integer.parseInt(s));
            female3DA.add(Integer.parseInt(s));
        }

        BufferedReader female3DMFile = new BufferedReader(new FileReader("female3DM.txt"));

        while (true) {
            s = female3DMFile.readLine();
            if (s == null) {
                break;
            }
            female3D.add(Integer.parseInt(s));
            female3DM.add(Integer.parseInt(s));
        }

        if (shuffleLists) {
            if (!useNamelist) {
                Collections.shuffle(surname);
                Collections.shuffle(maleGivenName);
                Collections.shuffle(femaleGivenName);
            } else {
                Collections.shuffle(maleName);
                Collections.shuffle(femaleName);
            }
            Collections.shuffle(maleFace);
            Collections.shuffle(femaleFace);
            Collections.shuffle(maleFaceA);
            Collections.shuffle(maleFaceM);
            Collections.shuffle(maleFaceU);
            Collections.shuffle(femaleFaceA);
            Collections.shuffle(femaleFaceM);
        }
    }

    /**
     * @return the surname
     */
    public List<String> getSurname() {
        return surname;
    }

    /**
     * @return the malegivenname
     */
    public List<String> getMalegivenname() {
        return maleGivenName;
    }

    /**
     * @return the femalegivenname
     */
    public List<String> getFemalegivenname() {
        return femaleGivenName;
    }

    /**
     * @return the maleface
     */
    public List<Integer> getMaleface() {
        return maleFace;
    }

    /**
     * @return the femaleface
     */
    public List<Integer> getFemaleface() {
        return femaleFace;
    }

    /**
     * @return the maleFaceA
     */
    public List<Integer> getMaleFaceA() {
        return maleFaceA;
    }

    /**
     * @return the maleFaceM
     */
    public List<Integer> getMaleFaceM() {
        return maleFaceM;
    }

    /**
     * @return the maleFaceU
     */
    public List<Integer> getMaleFaceU() {
        return maleFaceU;
    }

    /**
     * @return the femaleFaceA
     */
    public List<Integer> getFemaleFaceA() {
        return femaleFaceA;
    }

    /**
     * @return the femaleFaceM
     */
    public List<Integer> getFemaleFaceM() {
        return femaleFaceM;
    }

    /**
     * @return the male3D
     */
    public List<Integer> getMale3D() {
        return male3D;
    }

    /**
     * @return the female3D
     */
    public List<Integer> getFemale3D() {
        return female3D;
    }

    /**
     * @return the male3DA
     */
    public List<Integer> getMale3DA() {
        return male3DA;
    }

    /**
     * @return the male3DM
     */
    public List<Integer> getMale3DM() {
        return male3DM;
    }

    /**
     * @return the female3DA
     */
    public List<Integer> getFemale3DA() {
        return female3DA;
    }

    /**
     * @return the female3DM
     */
    public List<Integer> getFemale3DM() {
        return female3DM;
    }

    /**
     * @return the maleName
     */
    public List<String> getMaleName() {
        return maleName;
    }

    /**
     * @return the femaleName
     */
    public List<String> getFemaleName() {
        return femaleName;
    }
}
