package s11abilityrandomizer;

import java.io.*;
import java.util.*;

/**
 *
 * @author Peter
 */
public class Officer {

    private static final String[] CHINESE_DIGIT = {"零", "一", "二", "三", "四", "五", "六", "七", "八", "九"};
    public static final int TOTAL_OFFICERS = 1000;
    public static final int MALE = 0;
    public static final int FEMALE = 1;
    public static final int NO_OFFICE = 80;
    public static final int NO_SUCH_OFFICER = 65535;
    public static final int NO_SPECIAL = 255;
    public static final int NO_TEAM = 65535;
    protected Random rng = new Random();
    protected Database db;
    protected int gender = 0;
    protected String surname, givenname, calledname;
    protected int leadership, might, intelligence, politics, glamour;
    protected int meritorious, office;
    protected int face;
    protected int debut, born, dead;
    protected boolean naturalDeath;
    protected int blood, father, mother, spouse, brother, generation;
    protected int personAttachment;
    protected int[] imitatingOfficer = new int[5], hateOfficer = new int[5];
    protected int spear, halberd, bow, calvary, siege, naval;
    protected int leadershipGrowthType, mightGrowthType, intelligenceGrowthType, politicsGrowthType, glamourGrowthType;
    protected int bornLocation, topicStrength, righteous, ambition,
            officerTendency, personality, speechType, speechWay, hanAttitude, stretagicalAttitude, locationAttitude;
    protected int special;
    protected int body, helmet, head, upper, cape, elbow, lower, arrowbag, unknown, leftweapon, rightweapon, horse, ageChangeFace;
    protected int team, base, location, loyalty, status;
    protected int id;
    //Tight blood is similar to blood but even set the same value for a pair of spouse
    private int tightBlood;
    //which team the base belong to
    protected static int[] baseTeam = null;
    //which faction the team belong to
    protected static int[] teamFaction = null;
    //generated specials
    protected static String[] specialName = new String[255];
    protected static String[] specialType = new String[255];
    protected static int[] specialLevel = new int[255];
    protected static String[] specialTroopUse = new String[255];
    protected static String[] specialDescription = new String[255];
    protected static int[][] specialCombinations = new int[255][8];
    //status codes
    public static final int STATUS_KING = 0;
    public static final int STATUS_CAPTAIN = 1;
    public static final int STATUS_MAYOR = 2;
    public static final int STATUS_NORMAL = 3;
    public static final int STATUS_UNEMPLOYED = 4;
    public static final int STATUS_CAPTURED = 5;
    public static final int STATUS_NOT_DEBUTTED = 6;
    public static final int STATUS_NOT_FOUND = 7;
    public static final int STATUS_DEAD = 8;
    public static final int NO_STATUS = -1;
    //public static final Map<Integer, List<Integer>> baseAdjacency = initBaseAdjacency();

    /*private static final Map<Integer, List<Integer>> initBaseAdjacency() {
        Map<Integer, List<Integer>> temp = new HashMap<Integer, List<Integer>>();
        temp.put(0, Arrays.asList(1));
        temp.put(1, Arrays.asList(0, 2, 3));
        temp.put(2, Arrays.asList(1, 3, 5));
        temp.put(3, Arrays.asList(1, 2, 4, 6));
        temp.put(4, Arrays.asList(3, 6, 7, 11));
        temp.put(5, Arrays.asList(2, 6));
        temp.put(6, Arrays.asList(3, 4, 5, 11, 12));
        temp.put(7, Arrays.asList(4, 8));
        temp.put(8, Arrays.asList(7, 9, 10));
        temp.put(9, Arrays.asList(8, 10, 11, 12));
        temp.put(10, Arrays.asList(8, 9, 14, 22, 25));
        temp.put(11, Arrays.asList(4, 6, 9, 12));
        temp.put(12, Arrays.asList(6, 9, 11, 13, 15, 16));
        temp.put(13, Arrays.asList(12, 14, 15, 16));
        temp.put(14, Arrays.asList(10, 13, 28));
        temp.put(15, Arrays.asList(12, 13, 16, 17));
        temp.put(16, Arrays.asList(12, 13, 15, 17, 18, 28));
        temp.put(17, Arrays.asList(15, 16, 19, 36));
        temp.put(18, Arrays.asList(16, 28, 36));
        temp.put(19, Arrays.asList(17, 20, 21));
        temp.put(20, Arrays.asList(19, 21, 36));
        temp.put(21, Arrays.asList(19, 20));
        temp.put(22, Arrays.asList(10, 23, 25, 26));
        temp.put(23, Arrays.asList(22, 24));
        temp.put(24, Arrays.asList(23));
        temp.put(25, Arrays.asList(10, 22, 26, 27));
        temp.put(26, Arrays.asList(22, 25, 27, 30, 31));
        temp.put(27, Arrays.asList(25, 26, 29, 30, 31));
        temp.put(28, Arrays.asList(14, 16, 18, 29));
        temp.put(29, Arrays.asList(27, 28, 30));
        temp.put(30, Arrays.asList(26, 27, 29, 31, 32, 35));
        temp.put(31, Arrays.asList(26, 27, 30, 32, 33));
        temp.put(32, Arrays.asList(30, 31, 34, 35));
        temp.put(33, Arrays.asList(31, 34));
        temp.put(34, Arrays.asList(32, 33));
        temp.put(35, Arrays.asList(30, 32, 38));
        temp.put(36, Arrays.asList(17, 18, 20, 37));
        temp.put(37, Arrays.asList(36, 38, 39));
        temp.put(38, Arrays.asList(35, 37, 39, 40));
        temp.put(39, Arrays.asList(37, 38, 40));
        temp.put(40, Arrays.asList(39, 41));
        temp.put(41, Arrays.asList(40));
        return Collections.unmodifiableMap(temp);
    }*/

    public Officer() {
        //init combins to -1
        for (int i = 0; i < specialCombinations.length; ++i){
            for (int j = 0; j < specialCombinations[i].length; ++j){
                specialCombinations[i][j] = -1;
            }
        }
    }

    public Officer(Database db, int id) {
        this.db = db;
        this.id = id;
        //init combins to -1
        for (int i = 0; i < specialCombinations.length; ++i){
            for (int j = 0; j < specialCombinations[i].length; ++j){
                specialCombinations[i][j] = -1;
            }
        }
    }

    public static void randomBaseTeam() {
        baseTeam = Utility.shuffle(baseTeam, 42);
    }

    /*public static void mergeTeam(double mergeProb, double multiMergeDecay) {
        int[] temp = Arrays.copyOf(baseTeam, baseTeam.length);
        temp = Utility.shuffle(temp);
        for (int i = 0; i < temp.length; ++i) {
            if (Utility.probTest(mergeProb)) {
                List<Integer> toSelect = baseAdjacency.get(temp[i]);
                //yet to complete...
            }
        }
    }*/

    public int getGender() {
        return gender;
    }

    public void setRandomGender(double femaleProb) {
        gender = rng.nextFloat() <= femaleProb ? FEMALE : MALE;
    }

    public void setSameSurname(Officer anotherOfficer) {
        surname = anotherOfficer.surname;
    }

    public boolean isSameSurname(Officer anotherOfficer) {
        return surname.equals(anotherOfficer.surname);
    }

    private static int maleNameListI = 0, femaleNameListI = 0;
    public void setRandomNames(double doubleNameProb, boolean useNamelist) {
        if (!useNamelist) {
            List<String> surnameList = db.getSurname();
            List<String> givennameList = gender == MALE ? db.getMalegivenname() : db.getFemalegivenname();
            String picked;

            picked = surnameList.get(rng.nextInt(surnameList.size()));
            surname = picked;

            picked = givennameList.get(rng.nextInt(givennameList.size()));
            givenname = picked;
            
            if (picked.length() == 1 && rng.nextFloat() <= doubleNameProb) {
                picked = givennameList.get(rng.nextInt(givennameList.size()));
                if (picked.length() == 1) {
                    givenname += picked;
                }
            }
        } else {
            String picked;
            if (gender == MALE){
                List<String> nameList = db.getMaleName();
                picked = nameList.get(maleNameListI);
                maleNameListI++;
                if (maleNameListI >= nameList.size()){
                    maleNameListI = 0;
                }
            } else {
                List<String> nameList = db.getFemaleName();
                picked = nameList.get(femaleNameListI);
                femaleNameListI++;
                if (femaleNameListI >= nameList.size()){
                    femaleNameListI = 0;
                }
            }
                        
            String[] s = picked.split(" ");
            if (s.length < 2){
                throw new ArrayIndexOutOfBoundsException("請確認" + (gender == MALE ? "malename.txt" : "femalename.txt") + "中的所有姓名均有半型空格分隔。");
            }

            surname = s[0];
            givenname = s[1];

        }

        calledname = "";

    }

    public int getId() {
        return id;
    }

    public void randomFaceImage() {
        List<Integer> list = gender == MALE ? db.getMaleface() : db.getFemaleface();
        face = list.get(rng.nextInt(list.size()));
    }

    public void setFace(int x) {
        face = x;
        ageChangeFace = 255;
    }

    public void setSameFace(Officer o) {
        face = o.face;
        ageChangeFace = o.ageChangeFace;
    }

    public void setSameGender(Officer o) {
        gender = o.gender;
    }

    public void setSameName(Officer o) {
        surname = o.surname;
        givenname = o.givenname;
        calledname = o.calledname;
    }

    public void tweakAbility(double mul, int abs) {
        leadership = (int) (leadership * mul + abs);
        might = (int) (might * mul + abs);
        intelligence = (int) (intelligence * mul + abs);
        politics = (int) (politics * mul + abs);
        glamour = (int) (glamour * mul + abs);
    }

    public void randomAbility(double mul, double abs, int loCap, int hiCap) {
        leadership = Utility.randBetween_f(1 * mul + abs, 100 * mul + abs);
        might = Utility.randBetween_f(1 * mul + abs, 100 * mul + abs);
        intelligence = Utility.randBetween_f(1 * mul + abs, 100 * mul + abs);
        politics = Utility.randBetween_f(1 * mul + abs, 100 * mul + abs);
        glamour = Utility.randBetween_f(1 * mul + abs, 100 * mul + abs);
        leadership = Utility.cap(leadership, loCap, hiCap);
        might = Utility.cap(might, loCap, hiCap);
        intelligence = Utility.cap(intelligence, loCap, hiCap);
        politics = Utility.cap(politics, loCap, hiCap);
        glamour = Utility.cap(glamour, loCap, hiCap);
    }

    public void sameAbility(Officer o) {
        leadership = o.leadership;
        might = o.might;
        intelligence = o.intelligence;
        politics = o.politics;
        glamour = o.glamour;
    }

    public int getAbilitySum() {
        return leadership + might + intelligence + politics + glamour;
    }

    public int getAbilityMin() {
        return Collections.min(Arrays.asList(leadership, might, intelligence, politics, glamour));
    }

    public int getAbilityMax() {
        return Collections.max(Arrays.asList(leadership, might, intelligence, politics, glamour));
    }

    public void zeroMeritorious() {
        meritorious = 0;
    }

    public void sameMeritorious(Officer o) {
        meritorious = o.meritorious;
    }

    public void randomMeritorious(int lo, int hi) {
        meritorious = Utility.randBetween(lo, hi);
    }

    public void setNoOffice() {
        office = NO_OFFICE;
    }

    public void sameOffice(Officer o) {
        office = o.office;
    }

    public void sameStatus(Officer oldOfficer) {
        status = oldOfficer.status;
        if (oldOfficer.status != NO_STATUS && oldOfficer.team < 42) {
            //find out where the original team go!
            int[] order = Utility.randomOrder(42);
            for (int i = 0; i < 42; ++i) {
                if (baseTeam[order[i]] == oldOfficer.team || !oldOfficer.isEmployed()) {
                    location = order[i];
                    break;
                }
            }
            if (oldOfficer.isEmployed()) {
                team = baseTeam[location];
            } else {
                team = NO_TEAM;
            }
            base = location;
        } else {
            team = oldOfficer.team;
            location = oldOfficer.location;
            base = oldOfficer.base;
        }
    }

    public void clearStatus(Officer oldOfficer) {
        if (oldOfficer.status != STATUS_KING) {
            status = NO_STATUS;
            location = 65535;
            base = 65535;
            team = NO_TEAM;
        } else {
            status = oldOfficer.status;
            //find out where the original team go!
            for (int i = 0; i < baseTeam.length; ++i) {
                if (baseTeam[i] == oldOfficer.team) {
                    location = i;
                    break;
                }
            }
            team = baseTeam[location];
            base = location;
        }
    }

    public boolean isEmployed() {
        return status == STATUS_KING || status == STATUS_CAPTAIN || status == STATUS_MAYOR || status == STATUS_NORMAL
                || status == STATUS_CAPTURED;
    }

    public void completeRandomYears(int lo, int hi, int bornLo, int bornHi, int livingLo, int livingHi) {
        debut = Utility.randBetween(lo, hi);
        born = debut - Utility.randBetween(bornLo, bornHi);
        dead = Math.min(debut + Utility.randBetween(livingLo, livingHi), born + 99);
    }

    public void randomYears(Officer oldOfficer, int scenYear, int lo, int hi, int bornLo, int bornHi, int livingLo, int livingHi) {
        if (hi < scenYear + 1) {
            hi = scenYear + 1;
        }
        if (lo > scenYear) {
            lo = scenYear;
        }
        debut = oldOfficer.status == STATUS_NOT_DEBUTTED ? Utility.randBetween(scenYear + 1, hi) : Utility.randBetween(lo, scenYear);
        born = debut - Utility.randBetween(bornLo, bornHi);
        dead = Math.min(debut + Utility.randBetween(livingLo, livingHi), born + 99);
    }

    public void randomYears(boolean randomizeBorn, Officer oldOfficer, int scenYear) {
        int margin = scenYear;
        if (randomizeBorn) {
            debut = Utility.randBetween(160, 250);
        } else {
            //debut = oldOfficer.status == STATUS_NOT_DEBUTTED ? Utility.randBetween( oldOfficer.debut, 250) : Utility.randBetween( 160, oldOfficer.debut);
            debut = oldOfficer.status == STATUS_NOT_DEBUTTED ? Utility.randBetween(margin + 1, 250) : Utility.randBetween(160, margin);
            //debut = oldOfficer.debut;
        }
        born = debut - Utility.randBetween(15, 30);
        dead = Math.max(Math.min(debut + Utility.randBetween(10, 85), born + 99), margin + Utility.randBetween(5, 10));
    }

    public void sameYear(Officer o) {
        debut = o.debut;
        born = o.born;
        dead = o.dead;
    }

    public int getBornYear() {
        return born;
    }
    private static int[] randLocationProb;

    public static void setRandLocationProb(int noTeamWeightLo, int noTeamWeightHi, int haveTeamWeightLo, int haveTeamWeightHi) {
        randLocationProb = new int[42];
        for (int i = 0; i < 42; ++i) {
            if (baseTeam[i] == -1) {
                randLocationProb[i] = Utility.randBetween(noTeamWeightLo, noTeamWeightHi);
            } else {
                randLocationProb[i] = Utility.randBetween(haveTeamWeightLo, haveTeamWeightHi);
            }
        }
    }

    public void randomLocation(boolean unemployedOnly, Officer oldOfficer, int scenYear, double unemployedProb) {
        if (unemployedOnly) {
            //change location only if it is not found or debutted
            if (oldOfficer.status == STATUS_NOT_DEBUTTED || oldOfficer.status == STATUS_NOT_FOUND || oldOfficer.status == STATUS_UNEMPLOYED
                    || oldOfficer.status == NO_STATUS) {
                location = Utility.randBetween(0, 41);
                loyalty = 0;
                team = NO_TEAM;
            } else {
                location = oldOfficer.location;
                if (oldOfficer.status == STATUS_KING) {
                    loyalty = 100;
                } else {
                    loyalty = Utility.randBetween(90, 100);
                }
                if (location > 41) {
                    team = NO_TEAM;
                } else {
                    team = baseTeam[location];
                }
            }
            status = oldOfficer.status;

        } else {
            //define prob array of going into any city

            if (oldOfficer.status != STATUS_KING) {
                location = Utility.randomCategorize_i(randLocationProb);
                if (baseTeam[location] == -1) {
                    //status = debut >= scenYear ? STATUS_NOT_FOUND : STATUS_NOT_DEBUTTED;
                    status = STATUS_NOT_FOUND;
                    loyalty = 0;
                    team = NO_TEAM;
                } else {
                    if (Math.random() < unemployedProb) {
                        status = STATUS_NORMAL;
                        loyalty = 100;
                        team = baseTeam[location];
                    } else {
                        status = STATUS_NOT_FOUND;
                        loyalty = 0;
                        team = NO_TEAM;
                    }
                }
            } else {
                status = oldOfficer.status;
                //find out where the original team go!
                for (int i = 0; i < baseTeam.length; ++i) {
                    if (baseTeam[i] == oldOfficer.team) {
                        location = i;
                        break;
                    }
                }
                team = baseTeam[location];
                loyalty = 100;
            }
        }
        base = location;
    }

    public void sameLoyalty(Officer o) {
        loyalty = o.loyalty;
    }

    public int getPersonAttachmentDifference(Officer anotherOfficer, int cap) {
        int result = Math.abs(anotherOfficer.personAttachment - this.personAttachment);
        if (result > cap / 2) {
            result = cap - result;
        }
        return result;
    }

    public void setLoyaltyByRelation(Officer anotherOfficer, int kingLo, int kingHi, int closeLo, int closeHi, int imitateLo, int imitateHi,
            int hateLo, int hateHi, int bloodLo, int bloodHi, int normalHi, int attachmentRange, int attachmentCap) {
        if (!isEmployed()) {
            loyalty = 0;
            return;
        }
        if (status == STATUS_KING) {
            loyalty = Utility.randBetween(kingLo, kingHi);
            return;
        }
        if (anotherOfficer == this) {
            return;
        }
        if (anotherOfficer.status == STATUS_KING && anotherOfficer.team == team) {
            if (spouse == anotherOfficer.id && spouse != NO_SUCH_OFFICER) {
                loyalty = Utility.randBetween(closeLo, closeHi);
                return;
            }
            if (brother == anotherOfficer.brother && brother != NO_SUCH_OFFICER) {
                loyalty = Utility.randBetween(closeLo, closeHi);
                return;
            }
            for (int i : imitatingOfficer) {
                if (i == anotherOfficer.id) {
                    loyalty = Utility.randBetween(imitateLo, imitateHi);
                    return;
                }
            }
            for (int i : hateOfficer) {
                if (i == anotherOfficer.id) {
                    loyalty = Utility.randBetween(hateLo, hateHi);
                    return;
                }
            }
            if (blood == anotherOfficer.blood) {
                loyalty = Utility.randBetween(bloodLo, bloodHi);
                return;
            }
            loyalty = (int) Math.round(normalHi - this.getPersonAttachmentDifference(anotherOfficer, attachmentCap) / (attachmentCap / 2.0) * attachmentRange);
        }
    }

    public int getTeam() {
        return team;
    }

    public int getStatus() {
        return status;
    }

    public void randomNaturalDeath(double naturalDeathProb) {
        naturalDeath = rng.nextFloat() <= naturalDeathProb ? true : false;
    }

    public void sameNaturalDeath(Officer o) {
        naturalDeath = o.naturalDeath;
    }

    public void setNoBrother() {
        brother = NO_SUCH_OFFICER;
    }

    public void sameBrother(Officer o) {
        brother = o.brother;
    }

    public void setNoBlood() {
        blood = id;
        tightBlood = id;
        father = NO_SUCH_OFFICER;
        mother = NO_SUCH_OFFICER;
        spouse = NO_SUCH_OFFICER;
        generation = 1;
    }

    public void sameBlood(Officer o) {
        blood = o.blood;
        tightBlood = o.tightBlood;
        father = o.father;
        mother = o.mother;
        spouse = o.spouse;
        generation = o.generation;
    }

    public int getTightBlood() {
        return tightBlood;
    }

    public int getBlood() {
        return blood;
    }

    public int getSpouse() {
        return spouse;
    }

    public int getBrother() {
        return brother;
    }

    public int getGeneration() {
        return generation;
    }

    public int getFather() {
        return father;
    }

    public int getMother() {
        return mother;
    }

    public void setTightBlood(int i) {
        tightBlood = i;
    }

    public void setSpouse(int i) {
        spouse = i;
    }

    public void setBlood(int i) {
        blood = i;
    }

    public void setFather(int i) {
        father = i;
    }

    public void setMother(int i) {
        mother = i;
    }

    public void setGeneration(int i) {
        generation = i;
    }

    public void setBrother(int i) {
        brother = i;
    }

    public void sameAttachment(Officer o) {
        personAttachment = o.personAttachment;
    }

    public void randomPersonAttachment(int lo, int hi) {
        personAttachment = Utility.randBetween(lo, hi);
    }

    public void randomPersonAttachment() {
        personAttachment = Utility.randBetween(0, 149);
    }

    public void randomPersonAttachmentWithinDiff(Officer reference, int value, int hi) {
        personAttachment = Utility.randBetween(reference.personAttachment - value, reference.personAttachment + value);
        if (personAttachment >= hi) {
            personAttachment -= hi;
        }
        if (personAttachment < 0) {
            personAttachment += hi;
        }
    }

    public void sameImitatingOfficers(Officer o) {
        noImitatingOfficers = 0;
        for (int i = 0; i < 5; ++i) {
            imitatingOfficer[i] = o.imitatingOfficer[i];
            if (imitatingOfficer[i] != NO_SUCH_OFFICER) {
                noImitatingOfficers++;
            }
        }
    }

    public void sameHateOfficers(Officer o) {
        noHateOfficers = 0;
        for (int i = 0; i < 5; ++i) {
            hateOfficer[i] = o.hateOfficer[i];
            if (hateOfficer[i] != NO_SUCH_OFFICER) {
                noHateOfficers++;
            }
        }
    }

    public void setNoImitatingOfficers() {
        for (int i = 0; i < 5; ++i) {
            imitatingOfficer[i] = NO_SUCH_OFFICER;
        }
        noImitatingOfficers = 0;
    }

    public void setNoHateOfficers() {
        for (int i = 0; i < 5; ++i) {
            hateOfficer[i] = NO_SUCH_OFFICER;
        }
        noHateOfficers = 0;
    }
    private int noImitatingOfficers = 0, noHateOfficers = 0;

    /*private boolean[] imitHateSet = new boolean[TOTAL_OFFICERS];
    
    public void setRandomImitatingOfficers(double stopRandProb) {
    for (int i = 0; i < 5; ++i) {
    imitHateSet[imitatingOfficer[i]] = false;
    imitatingOfficer[i] = NO_SUCH_OFFICER;
    }
    for (int i = 0; i < 5; ++i) {
    if (rng.nextFloat() < stopRandProb) {
    break;
    }
    do {
    imitatingOfficer[i] = Utility.randBetween( 0, TOTAL_OFFICERS - 1);
    } while (imitHateSet[imitatingOfficer[i]]);
    imitHateSet[imitatingOfficer[i]] = true;
    noImitatingOfficers++;
    }
    }
    
    public void setRandomHateOfficers(double stopRandProb) {
    for (int i = 0; i < 5; ++i) {
    imitHateSet[hateOfficer[i]] = false;
    hateOfficer[i] = NO_SUCH_OFFICER;
    }
    for (int i = 0; i < 5; ++i) {
    if (rng.nextFloat() < stopRandProb) {
    break;
    }
    do {
    hateOfficer[i] = Utility.randBetween( 0, TOTAL_OFFICERS - 1);
    } while (imitHateSet[hateOfficer[i]]);
    imitHateSet[hateOfficer[i]] = true;
    noHateOfficers++;
    }
    }*/
    public int getNoImitatingOfficers() {
        return noImitatingOfficers;
    }

    public int getNoHateOfficers() {
        return noHateOfficers;
    }

    public void addImitatingOfficers(Officer anotherOfficer) {
        if (noImitatingOfficers >= 5) {
            return;
        }
        if (id == anotherOfficer.id) {
            return;
        }
        //Check if there is repeat setting
        for (int i : imitatingOfficer) {
            if (i == anotherOfficer.id) {
                return;
            }
        }
        for (int i : hateOfficer) {
            if (i == anotherOfficer.id) {
                return;
            }
        }
        imitatingOfficer[noImitatingOfficers] = anotherOfficer.id;
        noImitatingOfficers++;
    }

    public void addHateOfficers(Officer anotherOfficer) {
        if (noHateOfficers >= 5) {
            return;
        }
        if (id == anotherOfficer.id) {
            return;
        }
        //Check if there is repeat setting
        for (int i : imitatingOfficer) {
            if (i == anotherOfficer.id) {
                return;
            }
        }
        for (int i : hateOfficer) {
            if (i == anotherOfficer.id) {
                return;
            }
        }
        //cannot hate his spouse or brother!
        if (spouse == anotherOfficer.id) {
            return;
        }
        if (brother == anotherOfficer.brother) {
            return;
        }
        hateOfficer[noHateOfficers] = anotherOfficer.id;
        noHateOfficers++;
    }

    public void tweakAdaptability(double mul, int abs) {
        spear = (int) (spear * mul + abs);
        halberd = (int) (halberd * mul + abs);
        bow = (int) (bow * mul + abs);
        calvary = (int) (calvary * mul + abs);
        siege = (int) (siege * mul + abs);
        naval = (int) (naval * mul + abs);
    }

    public void randomAdaptability(double mul, double abs, int loCap, int hiCap) {
        //C = 0, B = 1, ... S = 3, S+100% = 13, S+110% to S+130% only for SIRE, up to 16 (unconfirmed).
        spear = Utility.randBetween_f(0 * mul + abs, 3 * mul + abs);
        halberd = Utility.randBetween_f(0 * mul + abs, 3 * mul + abs);
        bow = Utility.randBetween_f(0 * mul + abs, 3 * mul + abs);
        calvary = Utility.randBetween_f(0 * mul + abs, 3 * mul + abs);
        siege = Utility.randBetween_f(0 * mul + abs, 3 * mul + abs);
        naval = Utility.randBetween_f(0 * mul + abs, 3 * mul + abs);
        Utility.cap(spear, loCap, hiCap);
        Utility.cap(halberd, loCap, hiCap);
        Utility.cap(bow, loCap, hiCap);
        Utility.cap(calvary, loCap, hiCap);
        Utility.cap(siege, loCap, hiCap);
        Utility.cap(naval, loCap, hiCap);
    }

    public void sameAdaptability(Officer o) {
        spear = o.spear;
        halberd = o.halberd;
        bow = o.bow;
        calvary = o.calvary;
        siege = o.siege;
        naval = o.naval;
    }

    public void randomGrowthType(boolean useSpecial) {
        //0 - 8, 8 is special "kai-yan" type. Refer to van-editor for details.
        leadershipGrowthType = Utility.randBetween(0, useSpecial ? 8 : 7);
        mightGrowthType = Utility.randBetween(0, useSpecial ? 8 : 7);
        intelligenceGrowthType = Utility.randBetween(0, useSpecial ? 8 : 7);
        politicsGrowthType = Utility.randBetween(0, useSpecial ? 8 : 7);
        glamourGrowthType = Utility.randBetween(0, useSpecial ? 8 : 7);
    }

    public void sameGrowthType(Officer o) {
        leadershipGrowthType = o.leadershipGrowthType;
        mightGrowthType = o.mightGrowthType;
        intelligenceGrowthType = o.intelligenceGrowthType;
        politicsGrowthType = o.politicsGrowthType;
        glamourGrowthType = o.glamourGrowthType;
    }

    public void sameHiddenValues(Officer o) {
        bornLocation = o.bornLocation;
        topicStrength = o.topicStrength;
        righteous = o.righteous;
        ambition = o.ambition;
        officerTendency = o.officerTendency;
        personality = o.personality;
        speechType = o.speechType;
        speechWay = o.speechWay;
        hanAttitude = o.hanAttitude;
        stretagicalAttitude = o.stretagicalAttitude;
        locationAttitude = o.locationAttitude;
    }

    public void randomHiddenValues(boolean useSpecial) {
        //bornLocation = 0 - 11, van-editor for more details
        bornLocation = Utility.randBetween(0, 11);

        //topic strength = 0 - 2
        topicStrength = Utility.randBetween(0, 2);

        //righteous = 0 - 4, higher = more righteous
        righteous = Utility.randBetween(0, 4);

        //ambition = 0 - 4, higher = more ambition
        ambition = Utility.randBetween(0, 4);

        //officer tendency = 0 - 4
        officerTendency = Utility.randBetween(0, 4);

        //personality = 0 - 3, 0 = timid, 1 = calm, 2 = brave, 3 = gutful
        personality = Utility.randBetween(0, 3);

        //speech type: 0 - 3 for male, 4 - 5 for female, 6, 7 is lubu and zhugeliang respectively (unused here)
        speechType = gender == MALE ? Utility.randBetween(0, useSpecial ? 5 : 3) : Utility.randBetween(4, 5);
        if (gender == MALE && speechType > 3) {
            speechType += 2;
        }

        //speech way: 0 - 4 for female, 5 - 15 for male, 5, 7 is zhangfei and guanyu respectively (unused here)
        speechWay = gender == MALE ? Utility.randBetween(useSpecial ? 5 : 7, 15) : Utility.randBetween(0, 4);
        if (speechWay == 7 && !useSpecial) {
            speechWay = 6;
        }

        //attitude towards han = 0 - 2, higher = better attitude towards Han
        hanAttitude = Utility.randBetween(0, 2);

        //stretagical attitude = 0 - 3, higher = less ambitious
        stretagicalAttitude = Utility.randBetween(0, 3);

        //location attitude = 0 - 2, higher = less concerned about homeland
        locationAttitude = Utility.randBetween(0, 2);

    }

    public static void generateSpecials(int idLo, int idHi, int cntLo, int cntHi, String encoding) throws IOException {
        //read skill file
        BufferedReader specialFile = new BufferedReader(new InputStreamReader(new FileInputStream((encoding.equals("GBK") ? "GBK/" : "") + "generationTemplate.skill"), encoding));

        String s;
        while (true) {
            s = specialFile.readLine();
            if (s == null) {
                break;
            }

            String[] d = s.split(",");
            int id = Integer.parseInt(d[1]);
            specialName[id] = d[2];
            specialType[id] = d[4];
            specialLevel[id] = Integer.parseInt(d[5]);
            specialTroopUse[id] = d[14];
        }

        specialFile.close();

        //make combinations
        int[] combinCnt = new int[255]; 
        for (int i = idLo; i <= idHi; ++i) {
            combinCnt[i] = Utility.randBetween(cntLo, cntHi);
            String[] pickedName = new String[combinCnt[i]];
            String[] pickedType = new String[combinCnt[i]];
            int[] pickedLevel = new int[combinCnt[i]];
            for (int j = 0; j < combinCnt[i]; ++j) {
                boolean ok = true;
                do {
                    ok = true;
                    specialCombinations[i][j] = Utility.randBetween(0, 127);
                    if (specialCombinations[i][j] >= 100) {
                        specialCombinations[i][j] += 20;
                        if (specialCombinations[i][j] >= 147) {
                            specialCombinations[i][j] += 2;
                        }
                    }
                    for (int k = 0; k < j; ++k){
                        if (specialCombinations[i][j] == specialCombinations[i][k]){
                            ok = false;
                        }
                    }
                } while (!ok);
                pickedName[j] = specialName[specialCombinations[i][j]];
                pickedType[j] = specialType[specialCombinations[i][j]];
                pickedLevel[j] = specialLevel[specialCombinations[i][j]];
            }
            specialName[i] = CHINESE_DIGIT[i / 10 % 10] + CHINESE_DIGIT[i % 10];
            specialDescription[i] = Utility.join(pickedName, "＋");
            Arrays.sort(pickedType);
            String maxType = pickedType[0];
            int maxTypeCnt = 1;
            int typeCnt = 0;
            for (int j = 1; j < pickedType.length; ++j){
                if (pickedType[j].equals(pickedType[j - 1])){
                    typeCnt++;
                    if (typeCnt > maxTypeCnt){
                        maxTypeCnt = typeCnt;
                        maxType = pickedType[j];
                    }
                } else {
                    typeCnt = 1;
                }
            }
            specialType[i] = maxType;
            int sum = 0;
            for (int j = 0; j < pickedLevel.length; ++j){
                sum += pickedLevel[j] * pickedLevel[j];
            }
            specialLevel[i] = (int) Math.sqrt(sum);
            String code = specialTroopUse[specialCombinations[i][0]];
            for (int j = 1; j < combinCnt[i]; ++j){
                for (int k = 0; k < 6; ++k){
                    if (specialTroopUse[specialCombinations[i][j]].charAt(k) == 'O'){
                        code = code.substring(0, k) + "O" + code.substring(k+1, 6);
                    }
                }
            }
            specialTroopUse[i] = code;
        }
        
        //write file
        Utility.copyFile((encoding.equals("GBK") ? "GBK/" : "") + "generationTemplate.skill", "generated.skill");
        
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream("generated.skill", true), encoding));
        
        for (int i = idLo; i <= idHi; ++i){
            bw.write("T," + i + "," + specialName[i] + "," + specialDescription[i] + "," + specialType[i] + "," + specialLevel[i] + ",");
            for (int j = 0; j < combinCnt[i]; ++j){
                bw.write(specialCombinations[i][j] + "-" + specialName[specialCombinations[i][j]] + ",");
            }
            for (int j = combinCnt[i] + 1; j <= 8; ++j){
                bw.write(",");
            }
            bw.write(specialTroopUse[i] + ",");
            bw.newLine();
        }
        
        bw.close();
    }

    public void randomSpecials(int idCap, double noSpecProb) {
        if (rng.nextFloat() < noSpecProb) {
            special = NO_SPECIAL;
        } else {
            special = Utility.randBetween(0, idCap);
        }
    }

    public void clearSpecial() {
        special = NO_SPECIAL;
    }

    public void sameSpecial(Officer o) {
        special = o.special;
    }

    public void same3DModels(Officer o) {
        body = o.body;
        helmet = o.helmet;
        head = o.head;
        upper = o.upper;
        cape = o.cape;
        elbow = o.elbow;
        lower = o.lower;
        arrowbag = o.arrowbag;
        unknown = o.unknown;
        leftweapon = o.leftweapon;
        rightweapon = o.rightweapon;
        horse = o.horse;
    }

    public void random3DModels(boolean useGender, boolean useType, boolean useSpecial) {
        int r;
        do {
            if (useGender || useType) {
                if (useGender && useType) {
                    if (gender == MALE) {
                        if (leadership + might > intelligence + politics) {
                            r = Utility.randomPick(db.getMale3DM());
                        } else {
                            r = Utility.randomPick(db.getMale3DA());
                        }
                    } else {
                        if (leadership + might > intelligence + politics) {
                            r = Utility.randomPick(db.getFemale3DM());
                        } else {
                            r = Utility.randomPick(db.getFemale3DA());
                        }
                    }
                } else if (useGender) {
                    r = Utility.randomPick(gender == MALE ? db.getMale3D() : db.getFemale3D());
                } else {
                    if (leadership + might > intelligence + politics) {
                        r = Utility.randomPick(db.getMale3DM());
                    } else {
                        r = Utility.randomPick(db.getMale3DA());
                    }
                }
            } else {
                r = Utility.randBetween(useSpecial ? 0 : 72, 127);
            }
        } while (r <= (useSpecial ? 0 : 72));
        body = gender == MALE ? 0 : 1;
        helmet = head = upper = cape = elbow = lower = arrowbag = unknown = r;
        leftweapon = rightweapon = horse = 255;
    }

    private static byte[] padBytes(byte[] s, int len){
        byte[] paddedBytes = new byte[4];
        int i;
        for (i = 0; i < s.length; ++i){
            paddedBytes[i] = s[i];
        }
        return paddedBytes;
    }
    
    public void writeOfficer(RandomAccessFile scenFile) throws IOException {
        long offset = id * 0x98;
        byte[] big5Bytes;
        
        scenFile.seek(0x4560 + offset); //surname
        big5Bytes = surname.getBytes("Big5");
        scenFile.write(padBytes(big5Bytes, 4));

        scenFile.seek(0x4565 + offset); //givenname
        big5Bytes = givenname.getBytes("Big5");
        scenFile.write(padBytes(big5Bytes, 4));

        scenFile.seek(0x456A + offset); //calledname
        big5Bytes = calledname.getBytes("Big5");
        scenFile.write(padBytes(big5Bytes, 4));

        scenFile.seek(0x4597 + offset); //gender
        scenFile.write(gender);

        scenFile.seek(0x45D1 + offset); //leadership
        scenFile.write(Utility.toByteArray(leadership, might, intelligence, politics, glamour));

        /*scenFile.write(getLeadership());
        
        //scenFile.seek(0x45D2 + offset); //might
        scenFile.write(getMight());
        
        //scenFile.seek(0x45D3 + offset); //intelligence
        scenFile.write(getIntelligence());
        
        //scenFile.seek(0x45D4 + offset); //politics
        scenFile.write(getPolitics());
        
        //scenFile.seek(0x45D5 + offset); //glamour
        scenFile.write(getGlamour());*/

        scenFile.seek(0x45C8 + offset); //loyalty
        scenFile.write(Utility.toByteArray(loyalty, Utility.twoBytesForWriting(meritorious)[0], Utility.twoBytesForWriting(meritorious)[1]));
        /*scenFile.write(loyalty);
        
        //scenFile.seek(0x45C9 + offset); //meritorious
        Utility.write2Bytes(scenFile, meritorious);*/

        scenFile.seek(0x45C5 + offset); //office
        scenFile.write(office);

        scenFile.seek(0x4595 + offset); //face image
        Utility.write2Bytes(scenFile, face);

        scenFile.seek(0x4598 + offset); //year on stage
        scenFile.write(Utility.toByteArray(Utility.twoBytesForWriting(debut)[0], Utility.twoBytesForWriting(debut)[1],
                Utility.twoBytesForWriting(born)[0], Utility.twoBytesForWriting(born)[1],
                Utility.twoBytesForWriting(dead)[0], Utility.twoBytesForWriting(dead)[1],
                naturalDeath ? 0 : 1,
                Utility.twoBytesForWriting(blood)[0], Utility.twoBytesForWriting(blood)[1],
                Utility.twoBytesForWriting(father)[0], Utility.twoBytesForWriting(father)[1],
                Utility.twoBytesForWriting(mother)[0], Utility.twoBytesForWriting(mother)[1],
                generation,
                Utility.twoBytesForWriting(spouse)[0], Utility.twoBytesForWriting(spouse)[1],
                Utility.twoBytesForWriting(brother)[0], Utility.twoBytesForWriting(brother)[1],
                personAttachment,
                Utility.twoBytesForWriting(imitatingOfficer[0])[0], Utility.twoBytesForWriting(imitatingOfficer[0])[1],
                Utility.twoBytesForWriting(imitatingOfficer[1])[0], Utility.twoBytesForWriting(imitatingOfficer[1])[1],
                Utility.twoBytesForWriting(imitatingOfficer[2])[0], Utility.twoBytesForWriting(imitatingOfficer[2])[1],
                Utility.twoBytesForWriting(imitatingOfficer[3])[0], Utility.twoBytesForWriting(imitatingOfficer[3])[1],
                Utility.twoBytesForWriting(imitatingOfficer[4])[0], Utility.twoBytesForWriting(imitatingOfficer[4])[1],
                Utility.twoBytesForWriting(hateOfficer[0])[0], Utility.twoBytesForWriting(hateOfficer[0])[1],
                Utility.twoBytesForWriting(hateOfficer[1])[0], Utility.twoBytesForWriting(hateOfficer[1])[1],
                Utility.twoBytesForWriting(hateOfficer[2])[0], Utility.twoBytesForWriting(hateOfficer[2])[1],
                Utility.twoBytesForWriting(hateOfficer[3])[0], Utility.twoBytesForWriting(hateOfficer[3])[1],
                Utility.twoBytesForWriting(hateOfficer[4])[0], Utility.twoBytesForWriting(hateOfficer[4])[1],
                team,
                Utility.twoBytesForWriting(base)[0], Utility.twoBytesForWriting(base)[1]));
        /*Utility.write2Bytes(scenFile, debut);
        
        //scenFile.seek(0x459A + offset); //year born
        Utility.write2Bytes(scenFile, born);
        
        //scenFile.seek(0x459C + offset); //year dead
        Utility.write2Bytes(scenFile, dead);
        
        //scenFile.seek(0x459E + offset); //dead naturally (0) or not (1)
        scenFile.write(naturalDeath ? 0 : 1);
        
        //scenFile.seek(0x459F + offset); //blood value
        Utility.write2Bytes(scenFile, blood);
        
        //scenFile.seek(0x45A1 + offset); //father, id, 2 bytes
        Utility.write2Bytes(scenFile, father);
        
        //scenFile.seek(0x45A3 + offset); //mother, id, 2 bytes
        Utility.write2Bytes(scenFile, mother);
        
        //scenFile.seek(0x45A5 + offset); //generation
        scenFile.write(generation);
        
        //scenFile.seek(0x45A6 + offset); //couple, id, 2 bytes
        Utility.write2Bytes(scenFile, spouse);
        
        //scenFile.seek(0x45A8 + offset); //brother, id, 2 bytes
        Utility.write2Bytes(scenFile, brother);
        
        //scenFile.seek(0x45AA + offset); //person attachment
        scenFile.write(personAttachment);
        
        //scenFile.seek(0x45AB + offset); //imitating officers (id), 5 x 2 bytes
        Utility.write2Bytes(scenFile, imitatingOfficer[0]);
        //scenFile.seek(0x45AD + offset);
        Utility.write2Bytes(scenFile, imitatingOfficer[1]);
        //scenFile.seek(0x45AF + offset);
        Utility.write2Bytes(scenFile, imitatingOfficer[2]);
        //scenFile.seek(0x45B1 + offset);
        Utility.write2Bytes(scenFile, imitatingOfficer[3]);
        //scenFile.seek(0x45B3 + offset);
        Utility.write2Bytes(scenFile, imitatingOfficer[4]);
        
        //scenFile.seek(0x45B5 + offset); //hate officers (id), 5 x 2 bytes
        Utility.write2Bytes(scenFile, hateOfficer[0]);
        //scenFile.seek(0x45B7 + offset);
        Utility.write2Bytes(scenFile, hateOfficer[1]);
        //scenFile.seek(0x45B9 + offset);
        Utility.write2Bytes(scenFile, hateOfficer[2]);
        //scenFile.seek(0x45BB + offset);
        Utility.write2Bytes(scenFile, hateOfficer[3]);
        //scenFile.seek(0x45BD + offset);
        Utility.write2Bytes(scenFile, hateOfficer[4]);
        
        //scenFile.seek(0x45BF + offset); //team belonging to
        scenFile.write(team);
        
        //scenFile.seek(0x45C0 + offset); //base belonging to
        scenFile.write(base);*/

        scenFile.seek(0x45C2 + offset); //base currently in
        Utility.write2Bytes(scenFile, location);

        scenFile.seek(0x45C4 + offset); //status. 
        scenFile.write(status);

        scenFile.seek(0x45CB + offset); //spearman adaptability
        scenFile.write(Utility.toByteArray(spear, halberd, bow, calvary, siege, naval));
        /*scenFile.write(spear); //0 - 13
        
        //scenFile.seek(0x45CC + offset); //halberd adaptability
        scenFile.write(halberd); //0 - 13
        
        //scenFile.seek(0x45CD + offset); //bowman adaptability
        scenFile.write(bow); //0 - 13
        
        //scenFile.seek(0x45CE + offset); //calvaryman adaptability
        scenFile.write(calvary); //0 - 13
        
        //scenFile.seek(0x45CF + offset); //siege weapon adaptability
        scenFile.write(siege); //0 - 13
        
        //scenFile.seek(0x45D0 + offset); //naval adaptability
        scenFile.write(naval); //0 - 13*/

        scenFile.seek(0x45D6 + offset); //leadership growth type
        scenFile.write(Utility.toByteArray(
                leadershipGrowthType, mightGrowthType, intelligenceGrowthType, politicsGrowthType, glamourGrowthType,
                bornLocation, special, topicStrength, righteous, ambition, officerTendency, personality, speechType, speechWay,
                hanAttitude, stretagicalAttitude, locationAttitude,
                body, helmet, head, upper, cape, elbow, lower, arrowbag, unknown, leftweapon, rightweapon, horse, ageChangeFace));
        /*scenFile.write(leadershipGrowthType); //0 - 8, last is special-crafted "Kai-yan" type
        
        //scenFile.seek(0x45D7 + offset); //might growth type
        scenFile.write(mightGrowthType); //0 - 8, last is special-crafted "Kai-yan" type
        
        //scenFile.seek(0x45D8 + offset); //intelligence growth type
        scenFile.write(intelligenceGrowthType); //0 - 8, last is special-crafted "Kai-yan" type
        
        //scenFile.seek(0x45D9 + offset); //politics growth type
        scenFile.write(politicsGrowthType); //0 - 8, last is special-crafted "Kai-yan" type
        
        //scenFile.seek(0x45DA + offset); //glamour growth type
        scenFile.write(glamourGrowthType); //0 - 8, last is special-crafted "Kai-yan" type
        
        //scenFile.seek(0x45DB + offset); //where he is born
        scenFile.write(bornLocation); //0 - 11
        
        //scenFile.seek(0x45DC + offset); //specials
        scenFile.write(special); //255 stands for none
        
        //scenFile.seek(0x45DD + offset); //topic strength in arguments
        scenFile.write(topicStrength);
        
        //scenFile.seek(0x45DE + offset); //righteous
        scenFile.write(righteous);
        
        //scenFile.seek(0x45DF + offset); //ambition
        scenFile.write(ambition);
        
        //scenFile.seek(0x45E0 + offset); //what kind of person to use
        scenFile.write(officerTendency);
        
        //scenFile.seek(0x45E1 + offset); //personality
        scenFile.write(personality);
        
        //scenFile.seek(0x45E2 + offset); //speech type
        scenFile.write(speechType); //0-3 male, 4-5 female
        
        //scenFile.seek(0x45E3 + offset); //speech way
        scenFile.write(speechWay);//0-10 male, 11-15 female
        
        //scenFile.seek(0x45E4 + offset); //attitude towards Han
        scenFile.write(hanAttitude);
        
        //scenFile.seek(0x45E5 + offset); //stretagical attitude
        scenFile.write(stretagicalAttitude);
        
        //scenFile.seek(0x45E6 + offset); //attitude towards born location
        scenFile.write(locationAttitude);
        
        //up to 0x45F3 - 3D body model type
        //scenFile.seek(0x45E7 + offset);
        scenFile.write(body);
        
        //scenFile.seek(0x45E8 + offset);
        scenFile.write(helmet);
        
        //scenFile.seek(0x45E9 + offset);
        scenFile.write(head);
        
        //scenFile.seek(0x45EA + offset);
        scenFile.write(upper);
        
        //scenFile.seek(0x45EB + offset);
        scenFile.write(cape);
        
        //scenFile.seek(0x45EC + offset);
        scenFile.write(elbow);
        
        //scenFile.seek(0x45ED + offset);
        scenFile.write(lower);
        
        //scenFile.seek(0x45EE + offset);
        scenFile.write(arrowbag);
        
        //scenFile.seek(0x45EF + offset);
        scenFile.write(unknown);
        
        //scenFile.seek(0x45F0 + offset);
        scenFile.write(leftweapon);
        
        //scenFile.seek(0x45F1 + offset);
        scenFile.write(rightweapon);
        
        //scenFile.seek(0x45F2 + offset);
        scenFile.write(horse);
        
        //scenFile.seek(0x45F3 + offset);
        scenFile.write(ageChangeFace);*/

        //scenFile.seek(0x45F4 + offset); //available argument technique (bitmap), bit 3-7

    }

    public static Officer readOfficer(Database db, RandomAccessFile scenFile, int id) throws IOException {
        Officer newOfficer = new Officer(db, id);

        long offset = id * 0x98;
        byte[] big5Bytes = new byte[4];

        scenFile.seek(0x4560 + offset); //surname
        scenFile.read(big5Bytes);
        newOfficer.surname = new String(big5Bytes, "Big5");

        scenFile.seek(0x4565 + offset); //givenname
        scenFile.read(big5Bytes);
        newOfficer.givenname = new String(big5Bytes, "Big5");

        scenFile.seek(0x456A + offset); //calledname
        scenFile.read(big5Bytes);
        newOfficer.calledname = new String(big5Bytes, "Big5");

        scenFile.seek(0x4597 + offset); //gender
        newOfficer.gender = scenFile.readByte();

        byte[] b5 = new byte[5];
        scenFile.seek(0x45D1 + offset); //leadership
        scenFile.read(b5);
        newOfficer.leadership = b5[0];
        newOfficer.might = b5[1];
        newOfficer.intelligence = b5[2];
        newOfficer.politics = b5[3];
        newOfficer.glamour = b5[4];
        /*newOfficer.leadership = scenFile.readByte();
        
        //scenFile.seek(0x45D2 + offset); //might
        newOfficer.might = scenFile.readByte();
        
        //scenFile.seek(0x45D3 + offset); //intelligence
        newOfficer.intelligence = scenFile.readByte();
        
        //scenFile.seek(0x45D4 + offset); //politics
        newOfficer.politics = scenFile.readByte();
        
        //scenFile.seek(0x45D5 + offset); //glamour
        newOfficer.glamour = scenFile.readByte();*/

        byte[] b3 = new byte[3];
        scenFile.seek(0x45C8 + offset); //loyalty
        scenFile.read(b3);
        newOfficer.loyalty = b3[0];
        newOfficer.meritorious = Utility.twoBytesFromReading(b3[1], b3[2]);
        /*newOfficer.loyalty = scenFile.readByte();
        
        //scenFile.seek(0x45C9 + offset); //meritorious
        newOfficer.meritorious = Utility.read2Bytes(scenFile);*/

        scenFile.seek(0x45C5 + offset); //office
        newOfficer.office = scenFile.readByte();

        scenFile.seek(0x4595 + offset); //face image
        newOfficer.face = Utility.read2Bytes(scenFile);

        scenFile.seek(0x4598 + offset); //year on stage
        byte[] b42 = new byte[42];
        scenFile.read(b42);
        newOfficer.debut = Utility.twoBytesFromReading(b42[0], b42[1]);
        newOfficer.born = Utility.twoBytesFromReading(b42[2], b42[3]);
        newOfficer.dead = Utility.twoBytesFromReading(b42[4], b42[5]);
        newOfficer.naturalDeath = b42[6] == 0 ? true : false;
        newOfficer.blood = Utility.twoBytesFromReading(b42[7], b42[8]);
        newOfficer.father = Utility.twoBytesFromReading(b42[9], b42[10]);
        newOfficer.mother = Utility.twoBytesFromReading(b42[11], b42[12]);
        newOfficer.generation = b42[13];
        newOfficer.spouse = Utility.twoBytesFromReading(b42[14], b42[15]);
        newOfficer.brother = Utility.twoBytesFromReading(b42[16], b42[17]);
        newOfficer.personAttachment = b42[18];
        newOfficer.imitatingOfficer[0] = Utility.twoBytesFromReading(b42[19], b42[20]);
        newOfficer.imitatingOfficer[1] = Utility.twoBytesFromReading(b42[21], b42[22]);
        newOfficer.imitatingOfficer[2] = Utility.twoBytesFromReading(b42[23], b42[24]);
        newOfficer.imitatingOfficer[3] = Utility.twoBytesFromReading(b42[25], b42[26]);
        newOfficer.imitatingOfficer[4] = Utility.twoBytesFromReading(b42[27], b42[28]);
        newOfficer.hateOfficer[0] = Utility.twoBytesFromReading(b42[29], b42[30]);
        newOfficer.hateOfficer[1] = Utility.twoBytesFromReading(b42[31], b42[32]);
        newOfficer.hateOfficer[2] = Utility.twoBytesFromReading(b42[33], b42[34]);
        newOfficer.hateOfficer[3] = Utility.twoBytesFromReading(b42[35], b42[36]);
        newOfficer.hateOfficer[4] = Utility.twoBytesFromReading(b42[37], b42[38]);
        newOfficer.team = b42[39];
        newOfficer.base = Utility.twoBytesFromReading(b42[40], b42[41]);
        /*newOfficer.debut = Utility.read2Bytes(scenFile);
        
        //scenFile.seek(0x459A + offset); //year born
        newOfficer.born = Utility.read2Bytes(scenFile);
        
        //scenFile.seek(0x459C + offset); //year dead
        newOfficer.dead = Utility.read2Bytes(scenFile);
        
        //scenFile.seek(0x459E + offset); //dead naturally (0) or not (1)
        newOfficer.naturalDeath = scenFile.readByte() == 0 ? true : false;
        
        //scenFile.seek(0x459F + offset); //blood value
        newOfficer.blood = Utility.read2Bytes(scenFile);
        
        //scenFile.seek(0x45A1 + offset); //father, id, 2 bytes
        newOfficer.father = Utility.read2Bytes(scenFile);
        
        //scenFile.seek(0x45A3 + offset); //mother, id, 2 bytes
        newOfficer.mother = Utility.read2Bytes(scenFile);
        
        //scenFile.seek(0x45A5 + offset); //generation
        newOfficer.generation = scenFile.readByte();
        
        //scenFile.seek(0x45A6 + offset); //couple, id, 2 bytes
        newOfficer.spouse = Utility.read2Bytes(scenFile);
        
        //scenFile.seek(0x45A8 + offset); //brother, id, 2 bytes
        newOfficer.brother = Utility.read2Bytes(scenFile);
        
        //scenFile.seek(0x45AA + offset); //person attachment
        newOfficer.personAttachment = scenFile.readByte();
        
        //scenFile.seek(0x45AB + offset); //imitating officers (id), 5 x 2 bytes
        newOfficer.imitatingOfficer[0] = Utility.read2Bytes(scenFile);
        //scenFile.seek(0x45AD + offset);
        newOfficer.imitatingOfficer[1] = Utility.read2Bytes(scenFile);
        //scenFile.seek(0x45AF + offset);
        newOfficer.imitatingOfficer[2] = Utility.read2Bytes(scenFile);
        //scenFile.seek(0x45B1 + offset);
        newOfficer.imitatingOfficer[3] = Utility.read2Bytes(scenFile);
        //scenFile.seek(0x45B3 + offset);
        newOfficer.imitatingOfficer[4] = Utility.read2Bytes(scenFile);
        
        //scenFile.seek(0x45B5 + offset); //hate officers (id), 5 x 2 bytes
        newOfficer.hateOfficer[0] = Utility.read2Bytes(scenFile);
        //scenFile.seek(0x45B7 + offset);
        newOfficer.hateOfficer[1] = Utility.read2Bytes(scenFile);
        //scenFile.seek(0x45B9 + offset);
        newOfficer.hateOfficer[2] = Utility.read2Bytes(scenFile);
        //scenFile.seek(0x45BB + offset);
        newOfficer.hateOfficer[3] = Utility.read2Bytes(scenFile);
        //scenFile.seek(0x45BD + offset);
        newOfficer.hateOfficer[4] = Utility.read2Bytes(scenFile);
        
        //scenFile.seek(0x45BF + offset); //team belonging to
        newOfficer.team = scenFile.readByte();
        
        //scenFile.seek(0x45C0 + offset); //base belonging to
        newOfficer.base = scenFile.readByte();*/

        scenFile.seek(0x45C2 + offset); //base currently in
        byte[] b2 = new byte[2];
        scenFile.read(b2);
        newOfficer.location = Utility.twoBytesFromReading(b2[0], b2[1]);

        scenFile.seek(0x45C4 + offset); //status. 0 king 1 captain 2 mayor 3 normal 4 unemployed 5 captured 6 not debut 7 not found 8 dead
        newOfficer.status = scenFile.readByte();

        byte[] b6 = new byte[6];
        scenFile.seek(0x45CB + offset); //spearman adaptability
        scenFile.read(b6);
        newOfficer.spear = b6[0];
        newOfficer.halberd = b6[1];
        newOfficer.bow = b6[2];
        newOfficer.calvary = b6[3];
        newOfficer.siege = b6[4];
        newOfficer.naval = b6[5];
        /*newOfficer.spear = scenFile.readByte();
        
        //scenFile.seek(0x45CC + offset); //halberd adaptability
        newOfficer.halberd = scenFile.readByte();
        
        //scenFile.seek(0x45CD + offset); //bowman adaptability
        newOfficer.bow = scenFile.readByte();
        
        //scenFile.seek(0x45CE + offset); //calvaryman adaptability
        newOfficer.calvary = scenFile.readByte();
        
        //scenFile.seek(0x45CF + offset); //siege weapon adaptability
        newOfficer.siege = scenFile.readByte();
        
        //scenFile.seek(0x45D0 + offset); //naval adaptability
        newOfficer.naval = scenFile.readByte();*/

        byte[] b30 = new byte[30];
        scenFile.seek(0x45D6 + offset); //leadership growth type
        scenFile.read(b30);
        newOfficer.leadershipGrowthType = b30[0];
        newOfficer.mightGrowthType = b30[1];
        newOfficer.intelligenceGrowthType = b30[2];
        newOfficer.politicsGrowthType = b30[3];
        newOfficer.glamourGrowthType = b30[4];
        newOfficer.bornLocation = b30[5];
        newOfficer.special = b30[6];
        newOfficer.topicStrength = b30[7];
        newOfficer.righteous = b30[8];
        newOfficer.ambition = b30[9];
        newOfficer.officerTendency = b30[10];
        newOfficer.personality = b30[11];
        newOfficer.speechType = b30[12];
        newOfficer.speechWay = b30[13];
        newOfficer.hanAttitude = b30[14];
        newOfficer.stretagicalAttitude = b30[15];
        newOfficer.locationAttitude = b30[16];
        newOfficer.body = b30[17];
        newOfficer.helmet = b30[18];
        newOfficer.head = b30[19];
        newOfficer.upper = b30[20];
        newOfficer.cape = b30[21];
        newOfficer.elbow = b30[22];
        newOfficer.lower = b30[23];
        newOfficer.arrowbag = b30[24];
        newOfficer.unknown = b30[25];
        newOfficer.leftweapon = b30[26];
        newOfficer.rightweapon = b30[27];
        newOfficer.horse = b30[28];
        newOfficer.ageChangeFace = b30[29];
        /*newOfficer.leadershipGrowthType = scenFile.readByte();
        
        //scenFile.seek(0x45D7 + offset); //might growth type
        newOfficer.mightGrowthType = scenFile.readByte();
        
        //scenFile.seek(0x45D8 + offset); //intelligence growth type
        newOfficer.intelligenceGrowthType = scenFile.readByte();
        
        //scenFile.seek(0x45D9 + offset); //politics growth type
        newOfficer.politicsGrowthType = scenFile.readByte();
        
        //scenFile.seek(0x45DA + offset); //glamour growth type
        newOfficer.glamourGrowthType = scenFile.readByte();
        
        //scenFile.seek(0x45DB + offset); //where he is born
        newOfficer.bornLocation = scenFile.readByte();
        
        //scenFile.seek(0x45DC + offset); //specials
        newOfficer.special = scenFile.readByte();
        
        //scenFile.seek(0x45DD + offset); //topic strength in arguments
        newOfficer.topicStrength = scenFile.readByte();
        
        //scenFile.seek(0x45DE + offset); //righteous
        newOfficer.righteous = scenFile.readByte();
        
        //scenFile.seek(0x45DF + offset); //ambition
        newOfficer.ambition = scenFile.readByte();
        
        //scenFile.seek(0x45E0 + offset); //what kind of person to use
        newOfficer.officerTendency = scenFile.readByte();
        
        //scenFile.seek(0x45E1 + offset); //personality
        newOfficer.personality = scenFile.readByte();
        
        //scenFile.seek(0x45E2 + offset); //speech type
        newOfficer.speechType = scenFile.readByte();
        
        //scenFile.seek(0x45E3 + offset); //speech way
        newOfficer.speechWay = scenFile.readByte();
        
        //scenFile.seek(0x45E4 + offset); //attitude towards Han
        newOfficer.hanAttitude = scenFile.readByte();
        
        //scenFile.seek(0x45E5 + offset); //stretagical attitude
        newOfficer.stretagicalAttitude = scenFile.readByte();
        
        //scenFile.seek(0x45E6 + offset); //attitude towards born location
        newOfficer.locationAttitude = scenFile.readByte();
        
        //up to 0x45F3 - 3D body model type
        //scenFile.seek(0x45E7 + offset);
        newOfficer.body = scenFile.readByte();
        
        //scenFile.seek(0x45E8 + offset);
        newOfficer.helmet = scenFile.readByte();
        
        //scenFile.seek(0x45E9 + offset);
        newOfficer.head = scenFile.readByte();
        
        //scenFile.seek(0x45EA + offset);
        newOfficer.upper = scenFile.readByte();
        
        //scenFile.seek(0x45EB + offset);
        newOfficer.cape = scenFile.readByte();
        
        //scenFile.seek(0x45EC + offset);
        newOfficer.elbow = scenFile.readByte();
        
        //scenFile.seek(0x45ED + offset);
        newOfficer.lower = scenFile.readByte();
        
        //scenFile.seek(0x45EE + offset);
        newOfficer.arrowbag = scenFile.readByte();
        
        //scenFile.seek(0x45EF + offset);
        newOfficer.unknown = scenFile.readByte();
        
        //scenFile.seek(0x45F0 + offset);
        newOfficer.leftweapon = scenFile.readByte();
        
        //scenFile.seek(0x45F1 + offset);
        newOfficer.rightweapon = scenFile.readByte();
        
        //scenFile.seek(0x45F2 + offset);
        newOfficer.horse = scenFile.readByte();
        
        //scenFile.seek(0x45F3 + offset);
        newOfficer.ageChangeFace = scenFile.readByte();*/

        //scenFile.seek(0x45F4 + offset); //available argument technique (bitmap), bit 3-7

        return newOfficer;

    }

    /**
     * @return the leadership
     */
    public int getLeadership() {
        return leadership;
    }

    /**
     * @return the might
     */
    public int getMight() {
        return might;
    }

    /**
     * @return the intelligence
     */
    public int getIntelligence() {
        return intelligence;
    }

    /**
     * @return the politics
     */
    public int getPolitics() {
        return politics;
    }

    /**
     * @return the glamour
     */
    public int getGlamour() {
        return glamour;
    }

    public static void readTeamFaction(RandomAccessFile scenFile) throws IOException {
        long offset;
        int i;
        teamFaction = new int[47];
        //for (i = 0, offset = 0x1E8; i < teamFaction.length; ++i, offset += 0x11) {
        for (i = 0, offset = 0x2618C; i < teamFaction.length; ++i, offset += 0x8) {
            scenFile.seek(offset);
            teamFaction[i] = scenFile.readByte();
        }
    }

    public static void readBaseTeam(RandomAccessFile scenFile) throws IOException {
        long offset;
        int i;
        baseTeam = new int[87];
        //for (i = 0, offset = 0x1DB; i < baseTeam.length; ++i, offset += 0x1) {
        for (i = 0, offset = 0x26304; i < baseTeam.length; ++i, offset += 0x51) {
            scenFile.seek(offset);
            baseTeam[i] = scenFile.readByte();
        }
    }
    private static final boolean[] navalAllowed = new boolean[]{false, false, false, false, true, false, true, true, true, false, true, true, true, false, false, false, false, false,
        true, false, false, false, true, true, false, true, true, true, true, true, true, true, true, false, false, true, false,
        false, false, false, false, false};
    private static final boolean[] horseAllowed = new boolean[]{true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false,
        true, false, true, true, true, false, false, false, false, false, false, false, false, false, false,
        false, false, false, false, false, false, false, false, false, false};

    public static void writeBaseTeam(RandomAccessFile scenFile, boolean resetResource, boolean resetSetting, boolean clearGates,
            int maxTroopLo, int maxTroopHi, int troopLo, int troopHi, int cashLo, int cashHi, int cropLo, int cropHi,
            int spearLo, int spearHi, int halberdLo, int halberdHi, int bowLo, int bowHi, int horseLo, int horseHi,
            int ramLo, int ramHi, int catapultLo, int catapultHi, int shipLo, int shipHi,
            int cashInLo, int cashInHi, int cropInLo, int cropInHi, int troopMorLo, int troopMorHi, int morLo, int morHi,
            double specialtyFirst, double specialtyLater, boolean horseSpecialLimit, boolean navalSpecialLimit,
            double bigTroop, double bigCash, double bigCrop,
            Set<Integer> powerTeam, double powerTroop, double powerCash, double powerCrop, double powerWeapon,
            double powerCashIn, double powerCropIn, int powerDurabilityLo, int powerDurabilityHi) throws IOException {
        long offset;
        int i;
        /*for (i = 0, offset = 0x1DB; i < baseTeam.length; ++i, offset += 0x1) {
        scenFile.seek(offset);
        scenFile.write(baseTeam[i]);
        }*/
        for (i = 0, offset = 0; i < 42; ++i, offset += 0x51) {
            //generate specialty
            boolean[] specialty = new boolean[6];
            boolean isBig;
            if (Utility.probTest(specialtyFirst)) {
                int k;
                do {
                    k = Utility.randBetween(0, navalAllowed[i] || !navalSpecialLimit ? 5 : 4);
                } while (k == 3 && !horseAllowed[i] && horseSpecialLimit);
                specialty[k] = true;
                for (int j = 1; j < 6; ++j) {
                    if (!Utility.probTest(specialtyLater)) {
                        break;
                    }
                    do {
                        if (j >= 4) {
                            if ((!navalAllowed[i] || navalSpecialLimit) && (!horseAllowed[i] && horseSpecialLimit)) {
                                break; //maximal specailty reached. get out of loop.
                            }
                        }
                        if (j >= 5) {
                            if ((!navalAllowed[i] || navalSpecialLimit) || (!horseAllowed[i] && horseSpecialLimit)) {
                                break; //maximal specailty reached. get out of loop.
                            }
                        }
                        k = Utility.randBetween(0, navalAllowed[i] || !navalSpecialLimit ? 5 : 4);
                    } while (specialty[k] || (k == 3 && !horseAllowed[i] && horseSpecialLimit));
                    specialty[k] = true;
                }
                isBig = false;
            } else {
                isBig = true;
            }
            scenFile.seek(0x26304 + offset);
            scenFile.write(baseTeam[i]);
            if (baseTeam[i] != -1) {
                //give resources to occupied cities
                //maxtroop
                scenFile.seek(0x26305 + offset);
                if (resetSetting) {
                    Utility.write4Bytes(scenFile, (int) (Math.round(Utility.randBetween(maxTroopLo, maxTroopHi) * 10000 * (isBig ? bigTroop : 1)) * (powerTeam.contains(baseTeam[i]) ? powerTroop : 1)));
                } else {
                    scenFile.skipBytes(4);
                }
                if (resetResource) {
                    //troop
                    Utility.write4Bytes(scenFile, (int) (Utility.randBetween(troopLo, troopHi) * 1000 * (powerTeam.contains(baseTeam[i]) ? powerTroop : 1)));
                    //cash
                    Utility.write4Bytes(scenFile, (int) (Utility.randBetween(cashLo, cashHi) * 1000 * (powerTeam.contains(baseTeam[i]) ? powerCash : 1)));
                    //crop
                    Utility.write4Bytes(scenFile, (int) (Utility.randBetween(cropLo, cropHi) * 10000 * (powerTeam.contains(baseTeam[i]) ? powerCrop : 1)));
                    //spear, halberd, bow, horse
                    scenFile.skipBytes(4);
                    Utility.write4Bytes(scenFile, (int) (Utility.randBetween(spearLo, spearHi) * 1000 * (powerTeam.contains(baseTeam[i]) ? powerWeapon : 1)));
                    Utility.write4Bytes(scenFile, (int) (Utility.randBetween(halberdLo, halberdHi) * 1000 * (powerTeam.contains(baseTeam[i]) ? powerWeapon : 1)));
                    Utility.write4Bytes(scenFile, (int) (Utility.randBetween(bowLo, bowHi) * 1000 * (powerTeam.contains(baseTeam[i]) ? powerWeapon : 1)));
                    Utility.write4Bytes(scenFile, (int) (Utility.randBetween(horseLo, horseHi) * 1000 * (powerTeam.contains(baseTeam[i]) ? powerWeapon : 1)));
                    //ram, moving tower, catapult, firer
                    int ram = (int) (Utility.randBetween(ramLo, ramHi) * (powerTeam.contains(baseTeam[i]) ? powerWeapon : 1));
                    int catapult = (int) (Utility.randBetween(catapultLo, catapultHi) * (powerTeam.contains(baseTeam[i]) ? powerWeapon : 1));
                    Utility.write4Bytes(scenFile, ram);
                    Utility.write4Bytes(scenFile, catapult);
                    Utility.write4Bytes(scenFile, catapult);
                    Utility.write4Bytes(scenFile, ram);
                    //ships
                    scenFile.skipBytes(4);
                    int ship = (int) (Utility.randBetween(shipLo, shipHi) * (powerTeam.contains(baseTeam[i]) ? powerWeapon : 1));
                    Utility.write4Bytes(scenFile, ship);
                    Utility.write4Bytes(scenFile, ship);
                } else {
                    scenFile.skipBytes(60);
                }
                //cash crop income
                scenFile.seek(0x26347 + offset);
                if (resetSetting) {
                    Utility.write2Bytes(scenFile, (int) Math.round(Utility.randBetween(cashInLo, cashInHi) * 100 * (isBig ? bigCash : 1) * (powerTeam.contains(baseTeam[i]) ? powerCashIn : 1)));
                    Utility.write2Bytes(scenFile, (int) Math.round(Utility.randBetween(cropInLo, cropInHi) * 1000 * (isBig ? bigCrop : 1) * (powerTeam.contains(baseTeam[i]) ? powerCropIn : 1)));
                } else {
                    scenFile.skipBytes(4);
                }
                //max durability
                if (powerTeam.contains(baseTeam[i])) {
                    Utility.write2Bytes(scenFile, Utility.randBetween(powerDurabilityLo, powerDurabilityHi) * 100);
                } else {
                    scenFile.skipBytes(2);
                }
                if (resetResource) {
                    //troop morale
                    scenFile.write(Utility.randBetween(troopMorLo, troopMorHi));
                    //city morale
                    scenFile.write(Utility.randBetween(morLo, morHi));
                } else {
                    scenFile.skipBytes(2);
                }
                if (resetSetting) {
                    //specialty
                    for (int j = 0; j < 6; ++j) {
                        scenFile.write(specialty[j] ? 1 : 0);
                    }
                } else {
                    scenFile.skipBytes(6);
                }
            } else {
                //clear empty cities
                scenFile.seek(0x26305 + offset);
                if (resetSetting) {
                    Utility.write4Bytes(scenFile, Utility.randBetween(maxTroopLo, maxTroopHi) * 10000);
                } else {
                    scenFile.skipBytes(4);
                }
                if (resetResource) {
                    //troop
                    Utility.write4Bytes(scenFile, 0);
                    //cash
                    Utility.write4Bytes(scenFile, 0);
                    //crop
                    Utility.write4Bytes(scenFile, 0);
                    //spear, halberd, bow, horse
                    scenFile.skipBytes(4);
                    Utility.write4Bytes(scenFile, 0);
                    Utility.write4Bytes(scenFile, 0);
                    Utility.write4Bytes(scenFile, 0);
                    Utility.write4Bytes(scenFile, 0);
                    //ram, moving tower, catapult, firer
                    int ram = 0;
                    int catapult = 0;
                    Utility.write4Bytes(scenFile, ram);
                    Utility.write4Bytes(scenFile, catapult);
                    Utility.write4Bytes(scenFile, catapult);
                    Utility.write4Bytes(scenFile, ram);
                    //ships
                    scenFile.skipBytes(4);
                    int ship = 0;
                    Utility.write4Bytes(scenFile, ship);
                    Utility.write4Bytes(scenFile, ship);
                } else {
                    scenFile.skipBytes(60);
                }
                //cash crop income
                scenFile.seek(0x26347 + offset);
                if (resetSetting) {
                    Utility.write2Bytes(scenFile, Utility.randBetween(cashInLo, cashInHi) * 100);
                    Utility.write2Bytes(scenFile, Utility.randBetween(cropInLo, cropInHi) * 1000);
                } else {
                    scenFile.skipBytes(4);
                }
                //max durability
                //Utility.write2Bytes(scenFile, Utility.randBetween(40, 100) * 100);
                scenFile.skipBytes(2);
                if (resetResource) {
                    //troop morale
                    scenFile.write(0);
                    //city morale
                    scenFile.write(50);
                } else {
                    scenFile.skipBytes(2);
                }
                if (resetSetting) {
                    //specialty
                    for (int j = 0; j < 6; ++j) {
                        scenFile.write(specialty[j] ? 1 : 0);
                    }
                } else {
                    scenFile.skipBytes(6);
                }
            }

        }
        if (clearGates) {
            //clear gates
            for (i = 0, offset = 0; i < 10; ++i, offset += 0x40) {
                scenFile.seek(0x2704E + offset);
                scenFile.write(255);
                scenFile.write(new byte[0x20]);
                scenFile.seek(0x2708B + offset);
                scenFile.write(0);
            }
            //clear harbours
            for (i = 0, offset = 0; i < 35; ++i, offset += 0x40) {
                scenFile.seek(0x272CE + offset);
                scenFile.write(255);
                scenFile.write(new byte[0x20]);
                scenFile.seek(0x2730B + offset);
                scenFile.write(0);
            }
        }
    }

    public static void clearCountryName(RandomAccessFile scenFile) throws IOException {
        long offset;
        int i;
        for (i = 0, offset = 0x25488; i < 42; ++i, offset += 0x48) {
            scenFile.seek(offset);
            scenFile.write(255);
        }
    }

    public static void clearAdvisor(RandomAccessFile scenFile) throws IOException {
        long offset;
        int i;
        for (i = 0, offset = 0x25456; i < 42; ++i, offset += 0x48) {
            scenFile.seek(offset);
            Utility.write2Bytes(scenFile, NO_SUCH_OFFICER);
        }
    }

    public static void clearTechnique(RandomAccessFile scenFile) throws IOException {
        long offset;
        int i;
        for (i = 0, offset = 0x25494; i < 42; ++i, offset += 0x48) {
            scenFile.seek(offset);
            scenFile.write(new byte[5]);
        }
    }

    public static void randomTechnique(RandomAccessFile scenFile, int probLo, int probHi, boolean sameProbForFaction) throws IOException {
        long offset;
        int i;
        for (i = 0, offset = 0x25494; i < 42; ++i, offset += 0x48) {
            scenFile.seek(offset);
            double prob = 0;
            if (sameProbForFaction) {
                prob = Utility.randBetween(probLo, probHi);
            }
            byte[] level = new byte[9];
            for (int j = 0; j < 9; ++j) {
                if (!sameProbForFaction) {
                    prob = Utility.randBetween(probLo, probHi);
                }
                for (level[j] = 0; level[j] < 4; ++level[j]) {
                    if (!Utility.probTest(prob)) {
                        break;
                    }
                }
                switch (level[j]) {
                    case 0:
                        level[j] = 0;
                        break;
                    case 1:
                        level[j] = 1;
                        break;
                    case 2:
                        level[j] = 3;
                        break;
                    case 3:
                        level[j] = 7;
                        break;
                    case 4:
                        level[j] = 15;
                        break;
                }
            }
            scenFile.write(new byte[]{(byte) (level[0] | (level[1] << 4)), (byte) (level[2] | (level[3] << 4)),
                        (byte) (level[4] | (level[5] << 4)), (byte) (level[6] | (level[7] << 4)), level[8]});
        }
    }

    public static void randomDiplomacy(boolean gaussian, RandomAccessFile scenFile, int lo, int hi, int allianceCap, double allianceProb) throws IOException {
        //diplomacy value
        byte[][] diplomacy = new byte[47][47];
        //randomize diplomacy matrix
        for (int i = 0; i < diplomacy.length; ++i) {
            for (int j = i; j < diplomacy[i].length; ++j) {
                byte d = (byte) (gaussian ? Utility.cap((int) Utility.randGaussian((lo + hi) / 2, (hi - lo) / 2), lo, hi) : Utility.randBetween(lo, hi));
                diplomacy[i][j] = d;
                //make the matrix symmetric
                diplomacy[j][i] = d;
            }
        }
        //alliance
        boolean[][] alliance = new boolean[47][47];
        for (int i = 0; i < 42; ++i) { //ignore revolt factions
            for (int j = i + 1; j < 42; ++j) {//excludes itself
                if (Utility.probTest(allianceProb) && diplomacy[i][j] >= allianceCap) {
                    alliance[i][j] = true;
                    alliance[j][i] = true;
                }
            }
        }
        //write file
        long offset;
        int z;
        for (z = 0, offset = 0x25458; z < 47; ++z, offset += 0x48) {
            scenFile.seek(offset);
            scenFile.write(diplomacy[z]);
            scenFile.skipBytes(5);
            byte[] allianceBytes = new byte[6];
            for (int j = 0; j < 42; ++j) {
                allianceBytes[j / 8] |= (alliance[z][j] ? 1 : 0) << (j % 8);
            }
            scenFile.write(allianceBytes);
        }
    }
}
