package s11abilityrandomizer;

import java.io.*;
import java.util.*;

/**
 *
 * @author Peter
 */
public class TypedOfficer extends Officer {

    public static final int GENERAL = 0;
    public static final int MIGHTY = 1;
    public static final int ADVISOR = 2;
    public static final int POLITICIAN = 3;
    public static final int INTEL_GENERAL = 4;
    public static final int EMPEROR = 5;
    public static final int ALL_ROUNDER = 6;
    public static final int NORMAL = 7;
    public static final int CHEAP = 8;
    public static final int NUMBER_OF_TYPES = 9;
    private int type;

    public TypedOfficer(Database indb, int intype, int id) {
        super(indb, id);
        this.type = intype;
    }

    @Override
    public void randomAbility(double mul, double abs, int loCap, int hiCap) {
        switch (type) {
            case GENERAL: {
                /*leadership = Utility.randBetween(70, 100);
                might = Utility.randBetween(70, 100);
                intelligence = Utility.randBetween(30, 60);
                politics = Utility.randBetween(10, 40);
                glamour = Utility.randBetween(30, 90);*/
                leadership = (int) Utility.randGaussian(85, 15);
                might = (int) Utility.randGaussian(85, 15);
                intelligence = (int) Utility.randGaussian(50, 20);
                politics = (int) Utility.randGaussian(40, 20);
                glamour = (int) Utility.randGaussian(60, 30);
                break;
            }
            case MIGHTY: {
                /*leadership = Utility.randBetween(40, 70);
                might = Utility.randBetween(80, 100);
                intelligence = Utility.randBetween(10, 40);
                politics = Utility.randBetween(1, 30);
                glamour = Utility.randBetween(1, 50);*/
                leadership = (int) Utility.randGaussian(55, 15);
                might = (int) Utility.randGaussian(90, 10);
                intelligence = (int) Utility.randGaussian(25, 15);
                politics = (int) Utility.randGaussian(15, 15);
                glamour = (int) Utility.randGaussian(30, 30);
                break;
            }
            case ADVISOR: {
                /*leadership = Utility.randBetween(70, 100);
                might = Utility.randBetween(1, 70);
                intelligence = Utility.randBetween(80, 100);
                politics = Utility.randBetween(70, 100);
                glamour = Utility.randBetween(60, 100);*/
                leadership = (int) Utility.randGaussian(80, 20);
                might = (int) Utility.randGaussian(35, 35);
                intelligence = (int) Utility.randGaussian(90, 10);
                politics = (int) Utility.randGaussian(85, 15);
                glamour = (int) Utility.randGaussian(80, 20);
                break;
            }
            case POLITICIAN: {
                /*leadership = Utility.randBetween(10, 40);
                might = Utility.randBetween(1, 40);
                intelligence = Utility.randBetween(70, 100);
                politics = Utility.randBetween(80, 100);
                glamour = Utility.randBetween(1, 100);*/
                leadership = (int) Utility.randGaussian(25, 25);
                might = (int) Utility.randGaussian(20, 20);
                intelligence = (int) Utility.randGaussian(85, 15);
                politics = (int) Utility.randGaussian(90, 10);
                glamour = (int) Utility.randGaussian(50, 50);
                break;
            }
            case INTEL_GENERAL: {
                /*leadership = Utility.randBetween(70, 100);
                might = Utility.randBetween(70, 100);
                intelligence = Utility.randBetween(70, 100);
                politics = Utility.randBetween(1, 50);
                glamour = Utility.randBetween(30, 90);*/
                leadership = (int) Utility.randGaussian(85, 15);
                might = (int) Utility.randGaussian(85, 15);
                intelligence = (int) Utility.randGaussian(85, 15);
                politics = (int) Utility.randGaussian(25, 25);
                glamour = (int) Utility.randGaussian(60, 30);
                break;
            }
            case EMPEROR: {
                /*leadership = Utility.randBetween(70, 100);
                might = Utility.randBetween(50, 70);
                intelligence = Utility.randBetween(60, 100);
                politics = Utility.randBetween(60, 100);
                glamour = Utility.randBetween(80, 100);*/
                leadership = (int) Utility.randGaussian(80, 20);
                might = (int) Utility.randGaussian(50, 20);
                intelligence = (int) Utility.randGaussian(80, 20);
                politics = (int) Utility.randGaussian(80, 20);
                glamour = (int) Utility.randGaussian(90, 10);
                break;
            }
            case ALL_ROUNDER: {
                /*leadership = Utility.randBetween(70, 100);
                might = Utility.randBetween(70, 100);
                intelligence = Utility.randBetween(70, 100);
                politics = Utility.randBetween(70, 100);
                glamour = Utility.randBetween(70, 100);*/
                leadership = (int) Utility.randGaussian(85, 15);
                might = (int) Utility.randGaussian(85, 15);
                intelligence = (int) Utility.randGaussian(85, 15);
                politics = (int) Utility.randGaussian(85, 15);
                glamour = (int) Utility.randGaussian(85, 15);
                break;
            }
            case NORMAL: {
                /*leadership = Utility.randBetween(50, 70);
                might = Utility.randBetween(50, 70);
                intelligence = Utility.randBetween(50, 70);
                politics = Utility.randBetween(50, 70);
                glamour = Utility.randBetween(50, 70);*/
                leadership = (int) Utility.randGaussian(60, 15);
                might = (int) Utility.randGaussian(60, 15);
                intelligence = (int) Utility.randGaussian(60, 15);
                politics = (int) Utility.randGaussian(60, 15);
                glamour = (int) Utility.randGaussian(60, 15);
                break;
            }
            case CHEAP: {
                /*leadership = Utility.randBetween(1, 50);
                might = Utility.randBetween(1, 50);
                intelligence = Utility.randBetween(1, 50);
                politics = Utility.randBetween(1, 50);
                glamour = Utility.randBetween(1, 50);*/
                leadership = (int) Utility.randGaussian(25, 25);
                might = (int) Utility.randGaussian(25, 25);
                intelligence = (int) Utility.randGaussian(25, 25);
                politics = (int) Utility.randGaussian(25, 25);
                glamour = (int) Utility.randGaussian(25, 25);
                break;
            }
        }
        leadership = (int) (leadership * mul + abs);
        might = (int) (might * mul + abs);
        intelligence = (int) (intelligence * mul + abs);
        politics = (int) (politics * mul + abs);
        glamour = (int) (glamour * mul + abs);
        //cap the values
        leadership = Utility.cap(leadership, loCap, hiCap);
        might = Utility.cap(might, loCap, hiCap);
        intelligence = Utility.cap(intelligence, loCap, hiCap);
        politics = Utility.cap(politics, loCap, hiCap);
        glamour = Utility.cap(glamour, loCap, hiCap);
    }

    @Override
    public void randomAdaptability(double mul, double abs, int loCap, int hiCap) {
        switch (type) {
            case GENERAL: {
                spear = Utility.randomCategorize(0.15, 0.25, 0.25, 0.35);
                halberd = Utility.randomCategorize(0.15, 0.25, 0.25, 0.35);
                bow = Utility.randomCategorize(0.15, 0.25, 0.25, 0.35);
                calvary = Utility.randomCategorize(0.15, 0.25, 0.25, 0.35);
                siege = Utility.randomCategorize(0.3, 0.3, 0.2, 0.2);
                naval = Utility.randomCategorize(0.2, 0.25, 0.25, 0.3);
                break;
            }
            case MIGHTY: {
                spear = Utility.randomCategorize(0.1, 0.4, 0.3, 0.2);
                halberd = Utility.randomCategorize(0.1, 0.4, 0.3, 0.2);
                bow = Utility.randomCategorize(0.4, 0.3, 0.2, 0.1);
                calvary = Utility.randomCategorize(0.1, 0.4, 0.3, 0.2);
                siege = Utility.randomCategorize(0.7, 0.2, 0.09, 0.01);
                naval = Utility.randomCategorize(0.25, 0.25, 0.25, 0.25);
                break;
            }
            case ADVISOR: {
                spear = Utility.randomCategorize(0.35, 0.25, 0.25, 0.15);
                halberd = Utility.randomCategorize(0.35, 0.25, 0.25, 0.15);
                bow = Utility.randomCategorize(0.15, 0.25, 0.25, 0.35);
                calvary = Utility.randomCategorize(0.35, 0.25, 0.25, 0.15);
                siege = Utility.randomCategorize(0.15, 0.25, 0.25, 0.35);
                naval = Utility.randomCategorize(0.25, 0.25, 0.25, 0.25);
                break;
            }
            case POLITICIAN: {
                spear = Utility.randomCategorize(0.8, 0.15, 0.04, 0.01);
                halberd = Utility.randomCategorize(0.8, 0.15, 0.04, 0.01);
                bow = Utility.randomCategorize(0.7, 0.2, 0.15, 0.05);
                calvary = Utility.randomCategorize(0.8, 0.15, 0.04, 0.01);
                siege = Utility.randomCategorize(0.4, 0.3, 0.2, 0.1);
                naval = Utility.randomCategorize(0.8, 0.15, 0.04, 0.01);
                break;
            }
            case INTEL_GENERAL: {
                spear = Utility.randomCategorize(0.15, 0.25, 0.25, 0.35);
                halberd = Utility.randomCategorize(0.15, 0.25, 0.25, 0.35);
                bow = Utility.randomCategorize(0.15, 0.25, 0.25, 0.35);
                calvary = Utility.randomCategorize(0.15, 0.25, 0.25, 0.35);
                siege = Utility.randomCategorize(0.15, 0.25, 0.25, 0.35);
                naval = Utility.randomCategorize(0.15, 0.25, 0.25, 0.35);
                break;
            }
            case EMPEROR: {
                spear = Utility.randomCategorize(0.3, 0.3, 0.2, 0.2);
                halberd = Utility.randomCategorize(0.3, 0.3, 0.2, 0.2);
                bow = Utility.randomCategorize(0.3, 0.3, 0.2, 0.2);
                calvary = Utility.randomCategorize(0.3, 0.3, 0.2, 0.2);
                siege = Utility.randomCategorize(0.3, 0.3, 0.2, 0.2);
                naval = Utility.randomCategorize(0.3, 0.3, 0.2, 0.2);
                break;
            }
            case ALL_ROUNDER: {
                spear = Utility.randomCategorize(0.01, 0.15, 0.25, 0.59);
                halberd = Utility.randomCategorize(0.01, 0.15, 0.25, 0.59);
                bow = Utility.randomCategorize(0.01, 0.15, 0.25, 0.59);
                calvary = Utility.randomCategorize(0.01, 0.15, 0.25, 0.59);
                siege = Utility.randomCategorize(0.01, 0.15, 0.25, 0.59);
                naval = Utility.randomCategorize(0.01, 0.15, 0.25, 0.59);
                break;
            }
            case NORMAL: {
                spear = Utility.randomCategorize(0.8, 0.1, 0.09, 0.01);
                halberd = Utility.randomCategorize(0.8, 0.1, 0.09, 0.01);
                bow = Utility.randomCategorize(0.8, 0.1, 0.09, 0.01);
                calvary = Utility.randomCategorize(0.8, 0.1, 0.09, 0.01);
                siege = Utility.randomCategorize(0.8, 0.1, 0.09, 0.01);
                naval = Utility.randomCategorize(0.8, 0.1, 0.09, 0.01);
                break;
            }
            case CHEAP: {
                spear = Utility.randomCategorize(0.9, 0.08, 0.01, 0.01);
                halberd = Utility.randomCategorize(0.9, 0.08, 0.01, 0.01);
                bow = Utility.randomCategorize(0.9, 0.08, 0.01, 0.01);
                calvary = Utility.randomCategorize(0.9, 0.08, 0.01, 0.01);
                siege = Utility.randomCategorize(0.9, 0.08, 0.01, 0.01);
                naval = Utility.randomCategorize(0.9, 0.08, 0.01, 0.01);
                break;
            }
        }
        spear = (int) (spear * mul / (mul > 1 ? Utility.randBetween(1.0, mul) : 1) + abs);
        halberd = (int) (halberd * mul / (mul > 1 ? Utility.randBetween(1.0, mul) : 1) + abs);
        bow = (int) (bow * mul / (mul > 1 ? Utility.randBetween(1.0, mul) : 1) + abs);
        calvary = (int) (calvary * mul / (mul > 1 ? Utility.randBetween(1.0, mul) : 1) + abs);
        siege = (int) (siege * mul / (mul > 1 ? Utility.randBetween(1.0, mul) : 1) + abs);
        naval = (int) (naval * mul / (mul > 1 ? Utility.randBetween(1.0, mul) : 1) + abs);
        spear = Utility.cap(spear, loCap, hiCap);
        halberd = Utility.cap(halberd, loCap, hiCap);
        bow = Utility.cap(bow, loCap, hiCap);
        calvary = Utility.cap(calvary, loCap, hiCap);
        siege = Utility.cap(siege, loCap, hiCap);
        naval = Utility.cap(naval, loCap, hiCap);
    }
    private static int[][] specialProbs = null;
    private static Map<Integer, Map<String, String>> specialCond = new HashMap<Integer, Map<String, String>>();

    public static void readSpecialProbs() {
        //read in skill prob settings
        if (specialProbs == null) {
            specialProbs = new int[NUMBER_OF_TYPES][255];

            //read special weights
            BufferedReader specialFile = null;
            try {
                specialFile = new BufferedReader(new FileReader("special.txt"));
            } catch (FileNotFoundException ex) {
                ex.printStackTrace();
                return;
            }

            for (int i = 0; i < 9; ++i) {
                try {
                    String s = specialFile.readLine();

                    String[] temps = s.split("\t");
                    for (int j = 0; j < temps.length; ++j) {
                        specialProbs[i][j] = Integer.parseInt(temps[j]);
                    }
                } catch (IOException ex) {
                    //Do not touch anything if file reading fails.
                    ex.printStackTrace();
                    return;
                }
            }

            //read conditions
            String s;
            try {
                while ((s = specialFile.readLine()) != null) {
                    String[] temps = s.split(" ");

                    Map<String, String> map = new HashMap<String, String>(6);
                    for (int i = 1; i < temps.length; i += 2) {
                        map.put(temps[i], temps[i + 1]);
                    }

                    specialCond.put(Integer.parseInt(temps[0]), map);
                }
            } catch (IOException ex) {
                //Do not touch anything if file reading fails.
                ex.printStackTrace();
                return;
            }

            //decide probs and conds for generated ones
            for (int t = 0; t < NUMBER_OF_TYPES; ++t) {
                for (int i = 0; i < specialCombinations.length; ++i) {
                    List<Integer> allProbs = new ArrayList<Integer>();
                    Map<String, String> allConds = new HashMap<String, String>(6);
                    for (int j = 0; j < specialCombinations[i].length; ++j) {
                        if (specialCombinations[i][j] == -1) {
                            break;
                        }
                        allProbs.add(specialProbs[t][specialCombinations[i][j]]);
                        if (specialCond.containsKey(specialCombinations[i][j])) {
                            Map<String, String> thisCond = specialCond.get(specialCombinations[i][j]);
                            for (String k : thisCond.keySet()) {
                                if (allConds.containsKey(k)) {
                                    if (thisCond.get(k).compareTo(allConds.get(k)) > 0) {
                                        allConds.put(k, thisCond.get(k));
                                    }
                                } else {
                                    allConds.put(k, thisCond.get(k));
                                }
                            }
                        }
                    }
                    if (allProbs.size() > 0) {
                        if (t != ALL_ROUNDER) {
                            int min = Collections.min(allProbs);
                            specialProbs[t][i] = (int) (min * (1 - (allProbs.size() - 1) * 0.1));
                        } else {
                            int max = Collections.max(allProbs);
                            specialProbs[t][i] = (int) (max * (1 + (allProbs.size() - 1) * 0.2));
                        }
                        specialCond.put(i, allConds);
                    }
                }
            }
        }
    }

    @Override
    public void randomSpecials(int idCap, double noSpecProb) {
        randomSpecials(idCap, noSpecProb, type);
    }

    public void randomSpecials(int idCap, double noSpecProb, int officerType) {
        readSpecialProbs();

        int[] p = specialProbs[officerType];

        if (rng.nextFloat() < noSpecProb) {
            special = NO_SPECIAL;
        } else {
            boolean ok;
            int trials = 0;
            do {
                trials++;
                special = Utility.randomCategorize_i(p);
                ok = true;
                //ensure conditions
                if (special > idCap) {
                    ok = false;
                }
                Map<String, String> condMap = specialCond.get(special);
                if (condMap != null) {
                    Iterator<Map.Entry<String, String>> it = condMap.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry<String, String> entry = it.next();
                        if (entry.getKey().equals("leadership")) {
                            if (leadership < Integer.parseInt(entry.getValue())) {
                                ok = false;
                            }
                        }
                        if (entry.getKey().equals("might")) {
                            if (might < Integer.parseInt(entry.getValue())) {
                                ok = false;
                            }
                        }
                        if (entry.getKey().equals("intelligence")) {
                            if (intelligence < Integer.parseInt(entry.getValue())) {
                                ok = false;
                            }
                        }
                        if (entry.getKey().equals("politics")) {
                            if (politics < Integer.parseInt(entry.getValue())) {
                                ok = false;
                            }
                        }
                        if (entry.getKey().equals("glamour")) {
                            if (glamour < Integer.parseInt(entry.getValue())) {
                                ok = false;
                            }
                        }
                        if (entry.getKey().equals("total")) {
                            if (leadership + might + intelligence + politics < Integer.parseInt(entry.getValue())) {
                                ok = false;
                            }
                        }
                        if (entry.getKey().equals("spear")) {
                            if (entry.getValue().equals("highest")) {
                                if (halberd > spear || bow > spear || calvary > spear) {
                                    ok = false;
                                }
                            } else if (spear < Integer.parseInt(entry.getValue())) {
                                ok = false;
                            }
                        }
                        if (entry.getKey().equals("halberd")) {
                            if (entry.getValue().equals("highest")) {
                                if (spear > halberd || bow > halberd || calvary > halberd) {
                                    ok = false;
                                }
                            } else if (halberd < Integer.parseInt(entry.getValue())) {
                                ok = false;
                            }
                        }
                        if (entry.getKey().equals("bow")) {
                            if (entry.getValue().equals("highest")) {
                                if (halberd > bow || spear > bow || calvary > bow) {
                                    ok = false;
                                }
                            } else if (bow < Integer.parseInt(entry.getValue())) {
                                ok = false;
                            }
                        }
                        if (entry.getKey().equals("calvary")) {
                            if (entry.getValue().equals("highest")) {
                                if (halberd > calvary || bow > calvary || spear > calvary) {
                                    ok = false;
                                }
                            } else if (calvary < Integer.parseInt(entry.getValue())) {
                                ok = false;
                            }
                        }
                        if (entry.getKey().equals("siege")) {
                            if (siege < Integer.parseInt(entry.getValue())) {
                                ok = false;
                            }
                        }
                        if (entry.getKey().equals("naval")) {
                            if (naval < Integer.parseInt(entry.getValue())) {
                                ok = false;
                            }
                        }
                        if (entry.getKey().equals("ash")) {
                            if (spear + halberd < Integer.parseInt(entry.getValue())) {
                                ok = false;
                            }
                        }
                        if (entry.getKey().equals("atotal")) {
                            if (spear + halberd + bow + calvary < Integer.parseInt(entry.getValue())) {
                                ok = false;
                            }
                        }
                        if (entry.getKey().equals("atotaln")) {
                            if (spear + halberd + bow + calvary + naval < Integer.parseInt(entry.getValue())) {
                                ok = false;
                            }
                        }
                        if (entry.getKey().equals("atotalsn")) {
                            if (spear + halberd + bow + calvary + siege + naval < Integer.parseInt(entry.getValue())) {
                                ok = false;
                            }
                        }
                        if (entry.getKey().equals("gender")) {
                            if (entry.getValue().equals("male")) {
                                if (gender != MALE) {
                                    ok = false;
                                }
                            } else if (entry.getValue().equals("female")) {
                                if (gender != FEMALE) {
                                    ok = false;
                                }
                            }
                        }
                    }
                }
            } while (!ok && trials < 1000);
            if (!ok) {
                special = NO_SPECIAL;
            }
        }
    }

    @Override
    public void randomHiddenValues(boolean useSpecial) {
        //bornLocation = 0 - 11, van-editor for more details
        bornLocation = Utility.randBetween(0, 11);

        //topic strength = 0 - 2
        topicStrength = Utility.randBetween(0, 2);

        //attitude towards han = 0 - 2, higher = better attitude towards Han
        hanAttitude = Utility.randBetween(0, 2);

        //location attitude = 0 - 2, higher = less concerned about homeland
        locationAttitude = Utility.randBetween(0, 2);

        //officer tendency = 0 - 4
        officerTendency = Utility.randBetween(0, 4);

        switch (type) {
            case GENERAL: {
                righteous = Utility.randomCategorize(0.1, 0.2, 0.4, 0.2, 0.1);
                ambition = Utility.randomCategorize(0.1, 0.25, 0.3, 0.25, 0.1);
                personality = Utility.randomCategorize(0.05, 0.3, 0.4, 0.25);
                break;
            }
            case MIGHTY: {
                righteous = Utility.randomCategorize(0.05, 0.1, 0.25, 0.3, 0.3);
                ambition = Utility.randomCategorize(0.15, 0.25, 0.3, 0.2, 0.1);
                personality = Utility.randomCategorize(0.05, 0.1, 0.35, 0.5);
                break;
            }
            case ADVISOR: {
                righteous = Utility.randomCategorize(0.1, 0.2, 0.4, 0.2, 0.1);
                ambition = Utility.randomCategorize(0.1, 0.25, 0.3, 0.25, 0.1);
                personality = Utility.randomCategorize(0.15, 0.6, 0.2, 0.05);
                break;
            }
            case POLITICIAN: {
                righteous = Utility.randomCategorize(0.1, 0.2, 0.4, 0.2, 0.1);
                ambition = Utility.randomCategorize(0.15, 0.25, 0.3, 0.2, 0.1);
                personality = Utility.randomCategorize(0.3, 0.5, 0.15, 0.05);
                break;
            }
            case INTEL_GENERAL: {
                righteous = Utility.randomCategorize(0.1, 0.2, 0.4, 0.2, 0.1);
                ambition = Utility.randomCategorize(0.1, 0.2, 0.3, 0.25, 0.15);
                personality = Utility.randomCategorize(0.05, 0.55, 0.35, 0.05);
                break;
            }
            case EMPEROR: {
                righteous = Utility.randomCategorize(0.1, 0.2, 0.4, 0.2, 0.1);
                ambition = Utility.randomCategorize(0.05, 0.1, 0.2, 0.3, 0.35);
                personality = Utility.randomCategorize(0.05, 0.6, 0.3, 0.05);
                break;
            }
            case ALL_ROUNDER: {
                righteous = Utility.randomCategorize(0.1, 0.2, 0.4, 0.2, 0.1);
                ambition = Utility.randomCategorize(0.1, 0.2, 0.3, 0.25, 0.15);
                personality = Utility.randomCategorize(0.1, 0.4, 0.4, 0.1);
                break;
            }
            case NORMAL: {
                righteous = Utility.randomCategorize(0.1, 0.2, 0.4, 0.2, 0.1);
                ambition = Utility.randomCategorize(0.2, 0.3, 0.3, 0.1, 0.1);
                personality = Utility.randomCategorize(0.25, 0.25, 0.25, 0.25);
                break;
            }
            case CHEAP: {
                righteous = Utility.randomCategorize(0.35, 0.3, 0.2, 0.1, 0.05);
                ambition = Utility.randomCategorize(0.35, 0.3, 0.2, 0.1, 0.05);
                personality = Utility.randomCategorize(0.55, 0.3, 0.1, 0.05);
                break;
            }
        }

        if (gender == MALE) {
            int adjust = Utility.randomCategorize(0.05, 0.15, 0.6, 0.15, 0.05) - 2;
            speechType = Utility.cap(personality + adjust, 0, 3);
            if (rng.nextFloat() < 0.01 && useSpecial) {
                speechType = Utility.randBetween(4, 5);
            }
        } else {
            int adjust = Utility.randomCategorize(0.05, 0.15, 0.6, 0.15, 0.05) - 2;
            speechType = personality + adjust <= 1 ? 4 : 5;
        }

        switch (personality) {
            case 0: {
                speechWay = gender == MALE ? (Utility.randomCategorize(0.01, 0.01, 0.01, 0.01, 0.01, 0.15, 0.3, 0.3) + 7) : Utility.randomCategorize(0.01, 0.1, 0.3, 0.3);
                if (speechWay == 7) {
                    speechWay = 6;
                }
                break;
            }
            case 1: {
                speechWay = gender == MALE ? (Utility.randomCategorize(0.01, 0.1, 0.03, 0.03, 0.01, 0.3, 0.15, 0.2) + 7) : Utility.randomCategorize(0.01, 0.1, 0.5, 0.2);
                if (speechWay == 7) {
                    speechWay = 6;
                }
                break;
            }
            case 2: {
                speechWay = gender == MALE ? (Utility.randomCategorize(0.1, 0.1, 0.25, 0.2, 0.2, 0.15, 0.01, 0.01) + 7) : Utility.randomCategorize(0.2, 0.5, 0.01, 0.01);
                if (speechWay == 7) {
                    speechWay = 6;
                }
                break;
            }
            case 3: {
                speechWay = gender == MALE ? (Utility.randomCategorize(0.2, 0.1, 0.2, 0.15, 0.25, 0.01, 0.01, 0.01) + 7) : Utility.randomCategorize(0.3, 0.6, 0.01, 0.01);
                if (speechWay == 7) {
                    speechWay = 6;
                }
                break;
            }
        }
        if (rng.nextFloat() < 0.01 && useSpecial && gender == MALE) {
            speechWay = Utility.randBetween(5, 6);
            if (speechWay == 6) {
                speechWay = 7;
            }
        }

        int adjust = Utility.randomCategorize(0.05, 0.15, 0.6, 0.15, 0.05) - 2;
        stretagicalAttitude = Utility.cap(3 - (ambition + adjust), 0, 3);
    }

    public int getType() {
        return type;
    }
}
