/*
 * Frontend.java
 *
 * Created on 2011年7月1日, 下午07:28:29
 *
 */
package s11abilityrandomizer.frontend;

import java.io.*;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.*;
import javax.swing.UnsupportedLookAndFeelException;
import s11abilityrandomizer.*;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.event.DocumentListener;
import javax.swing.event.DocumentEvent;

/**
 *
 * @author Peter
 */
public class Frontend extends javax.swing.JFrame {

    public static final String APP_NAME = "三國志11劇本隨機化(v1.4b) by 耒戈氏";
    public static final String SETTING_FILE_EXTENSION = "ORSET";
    RandomAccessFile scenFile = null;
    final JFileChooser scenFileChooser;
    final JFileChooser settingFileChooser;

    /** Creates new form Frontend */
    public Frontend() {

        initComponents();
        scenFileChooser = new JFileChooser();
        scenFileChooser.addChoosableFileFilter(new javax.swing.filechooser.FileFilter() {

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().toUpperCase().matches("SCEN[0-9]{3}.S11") || pathname.isDirectory();
            }

            @Override
            public String getDescription() {
                return "三11劇本檔(SCEN???.S11)";
            }
        });
        scenFileChooser.setCurrentDirectory(new File(System.getProperty("user.dir")));

        settingFileChooser = new JFileChooser();
        settingFileChooser.addChoosableFileFilter(new javax.swing.filechooser.FileFilter() {

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().toUpperCase().endsWith(SETTING_FILE_EXTENSION) || pathname.isDirectory();
            }

            @Override
            public String getDescription() {
                return "三11劇本隨機化設定檔(*." + SETTING_FILE_EXTENSION + ")";
            }
        });
        settingFileChooser.setCurrentDirectory(new File(System.getProperty("user.dir")));

    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        faceRadioGroup = new javax.swing.ButtonGroup();
        selectedRandomizeOfficerButtonGroup = new javax.swing.ButtonGroup();
        officerGenerationTypeGroup = new javax.swing.ButtonGroup();
        randomizeSpecialGroup = new javax.swing.ButtonGroup();
        teamGroup = new javax.swing.ButtonGroup();
        randomizeCountGroup = new javax.swing.ButtonGroup();
        bloodGroup = new javax.swing.ButtonGroup();
        brotherGroup = new javax.swing.ButtonGroup();
        bloodImitateGroup = new javax.swing.ButtonGroup();
        imitateGroup = new javax.swing.ButtonGroup();
        hateGroup = new javax.swing.ButtonGroup();
        factionTechniqueButtonGroup = new javax.swing.ButtonGroup();
        jLabel170 = new javax.swing.JLabel();
        buttonGroup1 = new javax.swing.ButtonGroup();
        openFileButton = new javax.swing.JButton();
        filePathLabel = new javax.swing.JLabel();
        jTabbedPane1 = new javax.swing.JTabbedPane();
        jPanel1 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        femaleOfficerProbSlider = new javax.swing.JSlider();
        femaleOfficerProbLabel = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        doubleNameProbSlider = new javax.swing.JSlider();
        doubleNameProbLabel = new javax.swing.JLabel();
        jPanel2 = new javax.swing.JPanel();
        randomFaceRadio = new javax.swing.JRadioButton();
        genderFaceRadio = new javax.swing.JRadioButton();
        typedFaceRadio = new javax.swing.JRadioButton();
        noRandomFaceRadio = new javax.swing.JRadioButton();
        jPanel3 = new javax.swing.JPanel();
        ignoreScenYearCheckbox = new javax.swing.JCheckBox();
        jLabel3 = new javax.swing.JLabel();
        debutYearLoText = new javax.swing.JTextField();
        debutYearHiText = new javax.swing.JTextField();
        jLabel4 = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();
        bornYearLoText = new javax.swing.JTextField();
        jLabel6 = new javax.swing.JLabel();
        bornYearHiText = new javax.swing.JTextField();
        jLabel7 = new javax.swing.JLabel();
        deadYearLoText = new javax.swing.JTextField();
        jLabel8 = new javax.swing.JLabel();
        deadYearHiText = new javax.swing.JTextField();
        jLabel9 = new javax.swing.JLabel();
        jLabel10 = new javax.swing.JLabel();
        randomizeYearCheckbox = new javax.swing.JCheckBox();
        jLabel11 = new javax.swing.JLabel();
        attachmentLoText = new javax.swing.JTextField();
        jLabel12 = new javax.swing.JLabel();
        attachmentHiText = new javax.swing.JTextField();
        jLabel13 = new javax.swing.JLabel();
        naturalDeathProbSlider = new javax.swing.JSlider();
        natrualDeathProbLabel = new javax.swing.JLabel();
        randomizeGenderCheckbox = new javax.swing.JCheckBox();
        randomizeNameCheckbox = new javax.swing.JCheckBox();
        randomizeAttachmentCheckbox = new javax.swing.JCheckBox();
        randomizeNaturalDeathCheckbox = new javax.swing.JCheckBox();
        jPanel5 = new javax.swing.JPanel();
        randomTypeOfficerRadio = new javax.swing.JRadioButton();
        typedOfficerRadio = new javax.swing.JRadioButton();
        officerTypePanel = new javax.swing.JPanel();
        jLabel14 = new javax.swing.JLabel();
        generalTypeWeightText = new javax.swing.JTextField();
        typePercentageLabel = new javax.swing.JLabel();
        jLabel15 = new javax.swing.JLabel();
        mightyTypeWeightText = new javax.swing.JTextField();
        typePercentageLabel1 = new javax.swing.JLabel();
        jLabel16 = new javax.swing.JLabel();
        advisorTypeWeightText = new javax.swing.JTextField();
        typePercentageLabel2 = new javax.swing.JLabel();
        jLabel17 = new javax.swing.JLabel();
        politicianTypeWeightText = new javax.swing.JTextField();
        typePercentageLabel3 = new javax.swing.JLabel();
        jLabel18 = new javax.swing.JLabel();
        intelGeneralTypeWeightText = new javax.swing.JTextField();
        typePercentageLabel4 = new javax.swing.JLabel();
        jLabel19 = new javax.swing.JLabel();
        emperorTypeWeightText = new javax.swing.JTextField();
        typePercentageLabel5 = new javax.swing.JLabel();
        jLabel20 = new javax.swing.JLabel();
        allRounderTypeWeightText = new javax.swing.JTextField();
        typePercentageLabel6 = new javax.swing.JLabel();
        jLabel21 = new javax.swing.JLabel();
        normalTypeWeightText = new javax.swing.JTextField();
        typePercentageLabel7 = new javax.swing.JLabel();
        jLabel22 = new javax.swing.JLabel();
        cheapTypeWeightText = new javax.swing.JTextField();
        typePercentageLabel8 = new javax.swing.JLabel();
        jPanel15 = new javax.swing.JPanel();
        officer670Radio = new javax.swing.JRadioButton();
        officer700Radio = new javax.swing.JRadioButton();
        officer800Radio = new javax.swing.JRadioButton();
        officerAnyRadio = new javax.swing.JRadioButton();
        idHiText = new javax.swing.JTextField();
        randomizeDeadOnlyCheckbox = new javax.swing.JCheckBox();
        jPanel28 = new javax.swing.JPanel();
        combineNameRadio = new javax.swing.JRadioButton();
        directNameRadio = new javax.swing.JRadioButton();
        noSurnameChangeCheckbox = new javax.swing.JCheckBox();
        jPanel4 = new javax.swing.JPanel();
        jPanel7 = new javax.swing.JPanel();
        jLabel23 = new javax.swing.JLabel();
        abilityMulText = new javax.swing.JTextField();
        jLabel24 = new javax.swing.JLabel();
        abilityAbsText = new javax.swing.JTextField();
        jLabel25 = new javax.swing.JLabel();
        abilityHiText = new javax.swing.JTextField();
        jLabel26 = new javax.swing.JLabel();
        abilityLoText = new javax.swing.JTextField();
        randomizeAbilityCheckbox = new javax.swing.JCheckBox();
        randomizeGrowthTypeCheckbox = new javax.swing.JCheckBox();
        useSpecialGrowthTypeCheckbox = new javax.swing.JCheckBox();
        jPanel8 = new javax.swing.JPanel();
        jLabel27 = new javax.swing.JLabel();
        adaptabilityMulText = new javax.swing.JTextField();
        jLabel28 = new javax.swing.JLabel();
        adaptabilityAbsText = new javax.swing.JTextField();
        jLabel29 = new javax.swing.JLabel();
        jLabel30 = new javax.swing.JLabel();
        randomizeAdaptabilityCheckbox = new javax.swing.JCheckBox();
        adaptabilityHiCombo = new javax.swing.JComboBox();
        adaptabilityLoCombo = new javax.swing.JComboBox();
        jPanel9 = new javax.swing.JPanel();
        randomizeNoSpecialRadio = new javax.swing.JRadioButton();
        randomizeNormalSpecialRadio = new javax.swing.JRadioButton();
        randomizeSireSpecialRadio = new javax.swing.JRadioButton();
        randomizeAllSpecialRadio = new javax.swing.JRadioButton();
        jPanel10 = new javax.swing.JPanel();
        jLabel31 = new javax.swing.JLabel();
        noSpecialProb1Slider = new javax.swing.JSlider();
        noSpecialProb1Label = new javax.swing.JLabel();
        jLabel32 = new javax.swing.JLabel();
        noSpecialProb1Slider1 = new javax.swing.JSlider();
        noSpecialProb1Label1 = new javax.swing.JLabel();
        jLabel33 = new javax.swing.JLabel();
        noSpecialProb1Slider2 = new javax.swing.JSlider();
        noSpecialProb1Label2 = new javax.swing.JLabel();
        jLabel34 = new javax.swing.JLabel();
        noSpecialProb1Slider3 = new javax.swing.JSlider();
        noSpecialProb1Label3 = new javax.swing.JLabel();
        jLabel35 = new javax.swing.JLabel();
        noSpecialProb1Slider4 = new javax.swing.JSlider();
        noSpecialProb1Label4 = new javax.swing.JLabel();
        jLabel36 = new javax.swing.JLabel();
        noSpecialProb1Slider5 = new javax.swing.JSlider();
        noSpecialProb1Label5 = new javax.swing.JLabel();
        jLabel37 = new javax.swing.JLabel();
        noSpecialProb1Slider6 = new javax.swing.JSlider();
        noSpecialProb1Label6 = new javax.swing.JLabel();
        jLabel38 = new javax.swing.JLabel();
        noSpecialProb1Slider7 = new javax.swing.JSlider();
        noSpecialProb1Label7 = new javax.swing.JLabel();
        jLabel39 = new javax.swing.JLabel();
        noSpecialProb1Slider8 = new javax.swing.JSlider();
        noSpecialProb1Label8 = new javax.swing.JLabel();
        randomizeAllSpecialText = new javax.swing.JTextField();
        clearSpecialRadio = new javax.swing.JRadioButton();
        jPanel29 = new javax.swing.JPanel();
        jLabel169 = new javax.swing.JLabel();
        generateCombineSkillCheckbox = new javax.swing.JCheckBox();
        combineSkillIdLoText = new javax.swing.JTextField();
        jLabel171 = new javax.swing.JLabel();
        combineSkillIdHiText = new javax.swing.JTextField();
        jLabel172 = new javax.swing.JLabel();
        combineSkillCntLoText = new javax.swing.JTextField();
        jLabel173 = new javax.swing.JLabel();
        combineSkillCntHiText = new javax.swing.JTextField();
        jPanel11 = new javax.swing.JPanel();
        clearOfficerCheckbox = new javax.swing.JCheckBox();
        jPanel12 = new javax.swing.JPanel();
        jLabel43 = new javax.swing.JLabel();
        kingLoyaltyLoText = new javax.swing.JTextField();
        jLabel44 = new javax.swing.JLabel();
        kingLoyaltyHiText = new javax.swing.JTextField();
        closeLoyaltyHiText = new javax.swing.JTextField();
        jLabel45 = new javax.swing.JLabel();
        closeLoyaltyLoText = new javax.swing.JTextField();
        jLabel46 = new javax.swing.JLabel();
        imitateLoyaltyHiText = new javax.swing.JTextField();
        jLabel47 = new javax.swing.JLabel();
        imitateLoyaltyLoText = new javax.swing.JTextField();
        jLabel48 = new javax.swing.JLabel();
        hateLoyaltyHiText = new javax.swing.JTextField();
        jLabel49 = new javax.swing.JLabel();
        hateLoyaltyLoText = new javax.swing.JTextField();
        jLabel50 = new javax.swing.JLabel();
        bloodLoyaltyHiText = new javax.swing.JTextField();
        jLabel51 = new javax.swing.JLabel();
        bloodLoyaltyLoText = new javax.swing.JTextField();
        jLabel52 = new javax.swing.JLabel();
        jLabel53 = new javax.swing.JLabel();
        jLabel54 = new javax.swing.JLabel();
        normalLoyaltyHiText = new javax.swing.JTextField();
        normalLoyaltyRangeText = new javax.swing.JTextField();
        randomizeLoyaltyCheckbox = new javax.swing.JCheckBox();
        jPanel13 = new javax.swing.JPanel();
        noChangeTeamRadio = new javax.swing.JRadioButton();
        changeUnemployedTeamRadio = new javax.swing.JRadioButton();
        changeAllTeamRadio = new javax.swing.JRadioButton();
        jLabel40 = new javax.swing.JLabel();
        goNoTeamWeightLoText = new javax.swing.JTextField();
        jLabel41 = new javax.swing.JLabel();
        goHaveTeamWeightLoText = new javax.swing.JTextField();
        jLabel42 = new javax.swing.JLabel();
        employProbSlider = new javax.swing.JSlider();
        employProbLabel = new javax.swing.JLabel();
        jLabel88 = new javax.swing.JLabel();
        jLabel89 = new javax.swing.JLabel();
        goNoTeamWeightHiText = new javax.swing.JTextField();
        goHaveTeamWeightHiText = new javax.swing.JTextField();
        randomizeHiddenValuesCheckbox = new javax.swing.JCheckBox();
        useSpecialSpeechCheckbox = new javax.swing.JCheckBox();
        modelGenderCheckbox = new javax.swing.JCheckBox();
        useSpecial3dModelCheckbox = new javax.swing.JCheckBox();
        jLabel86 = new javax.swing.JLabel();
        meritoriousLoText = new javax.swing.JTextField();
        jLabel87 = new javax.swing.JLabel();
        meritoriousHiText = new javax.swing.JTextField();
        randomizeMeritoriousCheckbox = new javax.swing.JCheckBox();
        randomize3dModelCheckbox = new javax.swing.JCheckBox();
        modelTypeCheckbox = new javax.swing.JCheckBox();
        jPanel14 = new javax.swing.JPanel();
        jPanel16 = new javax.swing.JPanel();
        randomizeNoBloodRadio = new javax.swing.JRadioButton();
        clearBloodRadio = new javax.swing.JRadioButton();
        randomizeBloodRadio = new javax.swing.JRadioButton();
        jLabel56 = new javax.swing.JLabel();
        jLabel58 = new javax.swing.JLabel();
        jLabel60 = new javax.swing.JLabel();
        jLabel62 = new javax.swing.JLabel();
        spouseAttachmentProbSlider = new javax.swing.JSlider();
        spouseAttachmentProbLabel = new javax.swing.JLabel();
        jLabel55 = new javax.swing.JLabel();
        childAttachmentText = new javax.swing.JTextField();
        jLabel64 = new javax.swing.JLabel();
        jLabel65 = new javax.swing.JLabel();
        jLabel66 = new javax.swing.JLabel();
        jLabel67 = new javax.swing.JLabel();
        childAttachmentProbSlider = new javax.swing.JSlider();
        childAttachmentProbLabel = new javax.swing.JLabel();
        jLabel72 = new javax.swing.JLabel();
        jLabel73 = new javax.swing.JLabel();
        spouseAttachmentText = new javax.swing.JTextField();
        childMultipleDegradeText = new javax.swing.JTextField();
        jLabel59 = new javax.swing.JLabel();
        spouseNoFactionText = new javax.swing.JTextField();
        spouseSameFactionText = new javax.swing.JTextField();
        spouseDiffFactionText = new javax.swing.JTextField();
        childSameFactionText = new javax.swing.JTextField();
        childDiffFactionText = new javax.swing.JTextField();
        childNoFactionText = new javax.swing.JTextField();
        jPanel17 = new javax.swing.JPanel();
        randomizeNoBrotherRadio = new javax.swing.JRadioButton();
        clearBrotherRadio = new javax.swing.JRadioButton();
        randomizeBrotherRadio = new javax.swing.JRadioButton();
        jLabel61 = new javax.swing.JLabel();
        jLabel63 = new javax.swing.JLabel();
        jLabel68 = new javax.swing.JLabel();
        brotherAttachmentProbSlider = new javax.swing.JSlider();
        brotherAttachmentProbLabel = new javax.swing.JLabel();
        jLabel75 = new javax.swing.JLabel();
        jLabel77 = new javax.swing.JLabel();
        brotherAttachmentText = new javax.swing.JTextField();
        jLabel78 = new javax.swing.JLabel();
        brotherSameFactionText = new javax.swing.JTextField();
        brotherDiffFactionText = new javax.swing.JTextField();
        brotherNoFactionText = new javax.swing.JTextField();
        jPanel18 = new javax.swing.JPanel();
        jPanel19 = new javax.swing.JPanel();
        randomizeNoBloodImitateRadio = new javax.swing.JRadioButton();
        randomizeBloodImitateRadio = new javax.swing.JRadioButton();
        jLabel85 = new javax.swing.JLabel();
        jLabel57 = new javax.swing.JLabel();
        childImitateParentSlider = new javax.swing.JSlider();
        childImitateParentLabel = new javax.swing.JLabel();
        jLabel69 = new javax.swing.JLabel();
        parentImitateChildSlider = new javax.swing.JSlider();
        parentImitateChildLabel = new javax.swing.JLabel();
        jLabel70 = new javax.swing.JLabel();
        brotherImitateSlider = new javax.swing.JSlider();
        brotherImitateLabel = new javax.swing.JLabel();
        jLabel71 = new javax.swing.JLabel();
        brotherImitate2Slider = new javax.swing.JSlider();
        brotherImitate2Label = new javax.swing.JLabel();
        jPanel20 = new javax.swing.JPanel();
        randomizeNoImitateRadio = new javax.swing.JRadioButton();
        clearImitateRadio = new javax.swing.JRadioButton();
        randomizeImitateRadio = new javax.swing.JRadioButton();
        jLabel74 = new javax.swing.JLabel();
        imitateSlider = new javax.swing.JSlider();
        imitateLabel = new javax.swing.JLabel();
        jLabel79 = new javax.swing.JLabel();
        imitate2Slider = new javax.swing.JSlider();
        imitate2Label = new javax.swing.JLabel();
        jLabel81 = new javax.swing.JLabel();
        imitateDegradeText = new javax.swing.JTextField();
        jLabel83 = new javax.swing.JLabel();
        jPanel21 = new javax.swing.JPanel();
        randomizeNoHateRadio = new javax.swing.JRadioButton();
        clearHateRadio = new javax.swing.JRadioButton();
        randomizeHateRadio = new javax.swing.JRadioButton();
        jLabel76 = new javax.swing.JLabel();
        hateSlider = new javax.swing.JSlider();
        hateLabel = new javax.swing.JLabel();
        jLabel80 = new javax.swing.JLabel();
        hate2Slider = new javax.swing.JSlider();
        hate2Label = new javax.swing.JLabel();
        jLabel82 = new javax.swing.JLabel();
        hateDegradeText = new javax.swing.JTextField();
        jLabel84 = new javax.swing.JLabel();
        jPanel25 = new javax.swing.JPanel();
        clearAdvisorCheckbox = new javax.swing.JCheckBox();
        clearCountryNameCheckbox = new javax.swing.JCheckBox();
        jPanel22 = new javax.swing.JPanel();
        noChangeTechniqueRadio = new javax.swing.JRadioButton();
        clearTechniqueRadio = new javax.swing.JRadioButton();
        randomizeTechniqueRadio = new javax.swing.JRadioButton();
        jLabel90 = new javax.swing.JLabel();
        techniqueProbLoText = new javax.swing.JTextField();
        jLabel91 = new javax.swing.JLabel();
        techniqueProbHiText = new javax.swing.JTextField();
        sameProbForFactionCheckbox = new javax.swing.JCheckBox();
        jPanel26 = new javax.swing.JPanel();
        randomizeDiplomacyCheckbox = new javax.swing.JCheckBox();
        jLabel142 = new javax.swing.JLabel();
        diplomacyLoText = new javax.swing.JTextField();
        jLabel143 = new javax.swing.JLabel();
        diplomacyHiText = new javax.swing.JTextField();
        jLabel144 = new javax.swing.JLabel();
        allianceCapText = new javax.swing.JTextField();
        jLabel145 = new javax.swing.JLabel();
        allianceProbSlider = new javax.swing.JSlider();
        allianceProbLabel = new javax.swing.JLabel();
        diplomacyGaussianCheckbox = new javax.swing.JCheckBox();
        jPanel27 = new javax.swing.JPanel();
        jLabel146 = new javax.swing.JLabel();
        jLabel147 = new javax.swing.JLabel();
        strongFactionMinOfficerText = new javax.swing.JTextField();
        strongFactionHiText = new javax.swing.JTextField();
        jLabel148 = new javax.swing.JLabel();
        strongFactionLoText = new javax.swing.JTextField();
        jLabel149 = new javax.swing.JLabel();
        strongFactionOfficerProbLabel = new javax.swing.JLabel();
        strongFactionOfficerProbSlider = new javax.swing.JSlider();
        jLabel150 = new javax.swing.JLabel();
        strongFactionAbyMulText = new javax.swing.JTextField();
        jLabel151 = new javax.swing.JLabel();
        strongFactionAbyAbsText = new javax.swing.JTextField();
        jLabel152 = new javax.swing.JLabel();
        strongFactionAdpMulText = new javax.swing.JTextField();
        jLabel153 = new javax.swing.JLabel();
        strongFactionAdpAbsText = new javax.swing.JTextField();
        strongFactionSpecialCheckbox = new javax.swing.JCheckBox();
        strongFactionRelationCheckbox = new javax.swing.JCheckBox();
        jLabel154 = new javax.swing.JLabel();
        strongFactionTroopLoText = new javax.swing.JTextField();
        jLabel155 = new javax.swing.JLabel();
        strongFactionTroopHiText = new javax.swing.JTextField();
        jLabel156 = new javax.swing.JLabel();
        strongFactionCashLoText = new javax.swing.JTextField();
        jLabel157 = new javax.swing.JLabel();
        strongFactionCashHiText = new javax.swing.JTextField();
        jLabel158 = new javax.swing.JLabel();
        jLabel159 = new javax.swing.JLabel();
        strongFactionCropHiText = new javax.swing.JTextField();
        strongFactionCropLoText = new javax.swing.JTextField();
        jLabel160 = new javax.swing.JLabel();
        strongFactionWeaponLoText = new javax.swing.JTextField();
        strongFactionWeaponHiText = new javax.swing.JTextField();
        jLabel161 = new javax.swing.JLabel();
        strongFactionCashInLoText = new javax.swing.JTextField();
        jLabel162 = new javax.swing.JLabel();
        jLabel163 = new javax.swing.JLabel();
        strongFactionCashInHiText = new javax.swing.JTextField();
        jLabel164 = new javax.swing.JLabel();
        strongFactionCropInLoText = new javax.swing.JTextField();
        jLabel165 = new javax.swing.JLabel();
        strongFactionCropInHiText = new javax.swing.JTextField();
        strongFactionDurabilityLoText = new javax.swing.JTextField();
        strongFactionDurabilityHiText = new javax.swing.JTextField();
        jLabel166 = new javax.swing.JLabel();
        jLabel167 = new javax.swing.JLabel();
        jLabel168 = new javax.swing.JLabel();
        randomizeFactionColourCheckbox = new javax.swing.JCheckBox();
        jPanel6 = new javax.swing.JPanel();
        swapCountryCheckbox = new javax.swing.JCheckBox();
        clearGateCheckbox = new javax.swing.JCheckBox();
        jPanel23 = new javax.swing.JPanel();
        jLabel95 = new javax.swing.JLabel();
        troopLoText = new javax.swing.JTextField();
        jLabel96 = new javax.swing.JLabel();
        troopHiText = new javax.swing.JTextField();
        jLabel97 = new javax.swing.JLabel();
        jLabel98 = new javax.swing.JLabel();
        cashLoText = new javax.swing.JTextField();
        jLabel99 = new javax.swing.JLabel();
        cashHiText = new javax.swing.JTextField();
        jLabel100 = new javax.swing.JLabel();
        jLabel101 = new javax.swing.JLabel();
        cropLoText = new javax.swing.JTextField();
        jLabel102 = new javax.swing.JLabel();
        cropHiText = new javax.swing.JTextField();
        jLabel103 = new javax.swing.JLabel();
        jLabel104 = new javax.swing.JLabel();
        spearLoText = new javax.swing.JTextField();
        jLabel105 = new javax.swing.JLabel();
        spearHiText = new javax.swing.JTextField();
        jLabel106 = new javax.swing.JLabel();
        jLabel107 = new javax.swing.JLabel();
        halberdLoText = new javax.swing.JTextField();
        jLabel108 = new javax.swing.JLabel();
        halberdHiText = new javax.swing.JTextField();
        jLabel109 = new javax.swing.JLabel();
        jLabel110 = new javax.swing.JLabel();
        bowLoText = new javax.swing.JTextField();
        jLabel111 = new javax.swing.JLabel();
        bowHiText = new javax.swing.JTextField();
        jLabel112 = new javax.swing.JLabel();
        jLabel113 = new javax.swing.JLabel();
        horseLoText = new javax.swing.JTextField();
        jLabel114 = new javax.swing.JLabel();
        horseHiText = new javax.swing.JTextField();
        jLabel115 = new javax.swing.JLabel();
        jLabel116 = new javax.swing.JLabel();
        ramLoText = new javax.swing.JTextField();
        jLabel117 = new javax.swing.JLabel();
        ramHiText = new javax.swing.JTextField();
        jLabel128 = new javax.swing.JLabel();
        jLabel118 = new javax.swing.JLabel();
        catapultLoText = new javax.swing.JTextField();
        jLabel119 = new javax.swing.JLabel();
        catapultHiText = new javax.swing.JTextField();
        jLabel129 = new javax.swing.JLabel();
        jLabel120 = new javax.swing.JLabel();
        shipLoText = new javax.swing.JTextField();
        jLabel121 = new javax.swing.JLabel();
        shipHiText = new javax.swing.JTextField();
        jLabel130 = new javax.swing.JLabel();
        jLabel131 = new javax.swing.JLabel();
        troopMorLoText = new javax.swing.JTextField();
        jLabel132 = new javax.swing.JLabel();
        troopMorHiText = new javax.swing.JTextField();
        jLabel133 = new javax.swing.JLabel();
        jLabel134 = new javax.swing.JLabel();
        moraleLoText = new javax.swing.JTextField();
        jLabel135 = new javax.swing.JLabel();
        moraleHiText = new javax.swing.JTextField();
        jLabel136 = new javax.swing.JLabel();
        resetBaseResourceCheckbox = new javax.swing.JCheckBox();
        jPanel24 = new javax.swing.JPanel();
        jLabel92 = new javax.swing.JLabel();
        maxTroopLoText = new javax.swing.JTextField();
        jLabel93 = new javax.swing.JLabel();
        maxTroopHiText = new javax.swing.JTextField();
        jLabel94 = new javax.swing.JLabel();
        jLabel122 = new javax.swing.JLabel();
        cashInLoText = new javax.swing.JTextField();
        jLabel123 = new javax.swing.JLabel();
        cashInHiText = new javax.swing.JTextField();
        jLabel124 = new javax.swing.JLabel();
        jLabel125 = new javax.swing.JLabel();
        cropInLoText = new javax.swing.JTextField();
        jLabel126 = new javax.swing.JLabel();
        cropInHiText = new javax.swing.JTextField();
        jLabel127 = new javax.swing.JLabel();
        jLabel137 = new javax.swing.JLabel();
        firstSpecialProbSlider = new javax.swing.JSlider();
        firstSpecialProbLabel = new javax.swing.JLabel();
        jLabel138 = new javax.swing.JLabel();
        moreSpecialProbSlider = new javax.swing.JSlider();
        moreSpecialProbLabel = new javax.swing.JLabel();
        navalSpecialLimitCheckbox = new javax.swing.JCheckBox();
        horseSpecialLimitCheckbox = new javax.swing.JCheckBox();
        jLabel139 = new javax.swing.JLabel();
        bigCityCashText = new javax.swing.JTextField();
        jLabel140 = new javax.swing.JLabel();
        bigCityCropText = new javax.swing.JTextField();
        jLabel141 = new javax.swing.JLabel();
        bigCityTroopText = new javax.swing.JTextField();
        resetBaseSettingCheckbox = new javax.swing.JCheckBox();
        exportSettingButton = new javax.swing.JButton();
        importSettingButton = new javax.swing.JButton();
        combineSkillLangCombo = new javax.swing.JComboBox();

        jLabel170.setText("jLabel170");

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle(APP_NAME);
        setMinimumSize(new java.awt.Dimension(640, 480));
        setResizable(false);

        openFileButton.setText("隨機化劇本");
        openFileButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                openFileButtonMouseClicked(evt);
            }
        });

        filePathLabel.setText("開啟劇本檔，並對劇本進行隨機化。過程一般不會超過數秒。");

        jTabbedPane1.setPreferredSize(new java.awt.Dimension(720, 479));

        jPanel1.setPreferredSize(new java.awt.Dimension(720, 413));

        jLabel1.setText("女武將機率　");

        femaleOfficerProbSlider.setMajorTickSpacing(10);
        femaleOfficerProbSlider.setMinorTickSpacing(1);
        femaleOfficerProbSlider.setToolTipText("生成女武將的機率。");
        femaleOfficerProbSlider.setValue(25);
        femaleOfficerProbSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                femaleOfficerProbSliderStateChanged(evt);
            }
        });

        femaleOfficerProbLabel.setText("25%");

        jLabel2.setText("複名機率　");

        doubleNameProbSlider.setMajorTickSpacing(10);
        doubleNameProbSlider.setMinorTickSpacing(1);
        doubleNameProbSlider.setToolTipText("<html>生成武將名稱時，出現由兩個單字組成的名稱的機率。<br>\n注：實際機率可能與這數有出入。這是由於部分名稱在設定檔中已經是複名了，不需要組合。");
        doubleNameProbSlider.setValue(25);
        doubleNameProbSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                doubleNameProbSliderStateChanged(evt);
            }
        });

        doubleNameProbLabel.setText("25%");

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder("頭像"));

        faceRadioGroup.add(randomFaceRadio);
        randomFaceRadio.setText("完全隨意");
        randomFaceRadio.setToolTipText("完全隨意地分配武將頭像，即是男武將也可能會分配到女武將的頭像。");

        faceRadioGroup.add(genderFaceRadio);
        genderFaceRadio.setText("依據性別");
        genderFaceRadio.setToolTipText("<html>把武將頭像依據武將的性別重新分配。另外會盡量避免頭像的重覆，<br>\n但假若頭像數量不足，就可能會出現重覆頭像的情況。");

        faceRadioGroup.add(typedFaceRadio);
        typedFaceRadio.setText("依據性別及文武官");
        typedFaceRadio.setToolTipText("<html>把武將頭像依據武將的性別及能力重新分配，統武較高者分配武官頭像，<br>\n智政較高者分配文官頭像，能力低下者分配庸才頭像。<br>\n另外會盡量避免頭像的重覆，但假若頭像數量不足，就可能會出現重覆頭像的情況。");

        faceRadioGroup.add(noRandomFaceRadio);
        noRandomFaceRadio.setSelected(true);
        noRandomFaceRadio.setText("不要隨機化");
        noRandomFaceRadio.setToolTipText("不要隨機化武將的頭像");

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(randomFaceRadio)
                    .addComponent(genderFaceRadio)
                    .addComponent(typedFaceRadio)
                    .addComponent(noRandomFaceRadio))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup()
                .addComponent(noRandomFaceRadio)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(randomFaceRadio)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(genderFaceRadio)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(typedFaceRadio))
        );

        jPanel3.setBorder(javax.swing.BorderFactory.createTitledBorder("年份"));

        ignoreScenYearCheckbox.setText("無視劇本年份");
        ignoreScenYearCheckbox.setToolTipText("<html>隨機化武將出生、登場及死亡年時不考慮當前劇本年份。<br>\n注意：這選項是供無視年齡的劇本使用。在年齡生效的劇本使用可能會出現<br>\n武將年齡不合理或未登場武將沒法登場的情況。<br>\n另：如關閉這項，請關閉所屬下的「變更君主以外所有武將所屬/所在」一項，否則這功能會失效。");

        jLabel3.setText("登場年");

        debutYearLoText.setText("160");

        debutYearHiText.setText("250");

        jLabel4.setText("至");

        jLabel5.setText("出生年較登場年早");

        bornYearLoText.setText("15");
        bornYearLoText.setToolTipText("把武將出生年設在其登場年前的年數(即是登場年齡)下限");

        jLabel6.setText("至");

        bornYearHiText.setText("30");
        bornYearHiText.setToolTipText("把武將出生年設在其登場年前的年數(即是登場年齡)上限");

        jLabel7.setText("死亡年較登場年遲");

        deadYearLoText.setText("10");
        deadYearLoText.setToolTipText("把武將死亡年設在其登場年後的年數(即是在劇本出現的時間)下限");

        jLabel8.setText("至");

        deadYearHiText.setText("85");
        deadYearHiText.setToolTipText("把武將死亡年設在其登場年後的年數(即是在劇本出現的時間)上限");

        jLabel9.setText("年");

        jLabel10.setText("年");

        randomizeYearCheckbox.setText("隨機化");
        randomizeYearCheckbox.setToolTipText("<html>是否對武將的出生、登場及死亡年隨機化。<br>\n如果「無視劇本年份」沒點上，未登場的武將只會把登場年改至較後日期，<br>未登場的武將只會把登場年改至較前日期");

        javax.swing.GroupLayout jPanel3Layout = new javax.swing.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addGap(10, 10, 10)
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel3Layout.createSequentialGroup()
                        .addComponent(ignoreScenYearCheckbox)
                        .addComponent(randomizeYearCheckbox))
                    .addGroup(jPanel3Layout.createSequentialGroup()
                        .addComponent(jLabel3)
                        .addGap(4, 4, 4)
                        .addComponent(debutYearLoText, javax.swing.GroupLayout.PREFERRED_SIZE, 57, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(7, 7, 7)
                        .addComponent(jLabel4)
                        .addGap(8, 8, 8)
                        .addComponent(debutYearHiText, javax.swing.GroupLayout.PREFERRED_SIZE, 57, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel3Layout.createSequentialGroup()
                        .addComponent(jLabel5)
                        .addGap(4, 4, 4)
                        .addComponent(bornYearLoText, javax.swing.GroupLayout.PREFERRED_SIZE, 57, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(4, 4, 4)
                        .addComponent(jLabel6)
                        .addGap(4, 4, 4)
                        .addComponent(bornYearHiText, javax.swing.GroupLayout.PREFERRED_SIZE, 57, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(8, 8, 8)
                        .addComponent(jLabel9))
                    .addGroup(jPanel3Layout.createSequentialGroup()
                        .addComponent(jLabel7)
                        .addGap(4, 4, 4)
                        .addComponent(deadYearLoText, javax.swing.GroupLayout.PREFERRED_SIZE, 57, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(4, 4, 4)
                        .addComponent(jLabel8)
                        .addGap(4, 4, 4)
                        .addComponent(deadYearHiText, javax.swing.GroupLayout.PREFERRED_SIZE, 57, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(8, 8, 8)
                        .addComponent(jLabel10)))
                .addContainerGap(10, Short.MAX_VALUE))
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(ignoreScenYearCheckbox)
                    .addComponent(randomizeYearCheckbox))
                .addGap(6, 6, 6)
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel3Layout.createSequentialGroup()
                        .addGap(2, 2, 2)
                        .addComponent(jLabel3))
                    .addComponent(debutYearLoText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(jPanel3Layout.createSequentialGroup()
                        .addGap(2, 2, 2)
                        .addComponent(jLabel4))
                    .addComponent(debutYearHiText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(6, 6, 6)
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel3Layout.createSequentialGroup()
                        .addGap(3, 3, 3)
                        .addComponent(jLabel5))
                    .addComponent(bornYearLoText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(jPanel3Layout.createSequentialGroup()
                        .addGap(3, 3, 3)
                        .addComponent(jLabel6))
                    .addComponent(bornYearHiText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(jPanel3Layout.createSequentialGroup()
                        .addGap(3, 3, 3)
                        .addComponent(jLabel9)))
                .addGap(6, 6, 6)
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel3Layout.createSequentialGroup()
                        .addGap(3, 3, 3)
                        .addComponent(jLabel7))
                    .addComponent(deadYearLoText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(jPanel3Layout.createSequentialGroup()
                        .addGap(3, 3, 3)
                        .addComponent(jLabel8))
                    .addComponent(deadYearHiText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(jPanel3Layout.createSequentialGroup()
                        .addGap(3, 3, 3)
                        .addComponent(jLabel10)))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jLabel11.setText("相性");

        attachmentLoText.setText("0");
        attachmentLoText.setToolTipText("<html>相性下限<br>\n注：相性超過149，可能會出現褒獎武將時忠誠下降，或武將沒法登庸的情況");

        jLabel12.setText("至");

        attachmentHiText.setText("149");
        attachmentHiText.setToolTipText("<html>相性上限<br>\n注：相性超過149，可能會出現褒獎武將時忠誠下降，或武將沒法登庸的情況");

        jLabel13.setText("自然死機率　");

        naturalDeathProbSlider.setMajorTickSpacing(10);
        naturalDeathProbSlider.setMinorTickSpacing(1);
        naturalDeathProbSlider.setToolTipText("武將設定為自然死的機率");
        naturalDeathProbSlider.setValue(75);
        naturalDeathProbSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                naturalDeathProbSliderStateChanged(evt);
            }
        });

        natrualDeathProbLabel.setText("75%");

        randomizeGenderCheckbox.setText("隨機化");
        randomizeGenderCheckbox.setToolTipText("是否把武將的性別隨機化。");

        randomizeNameCheckbox.setText("隨機化");
        randomizeNameCheckbox.setToolTipText("是否隨機化武將名稱。");

        randomizeAttachmentCheckbox.setText("隨機化");
        randomizeAttachmentCheckbox.setToolTipText("是否隨機化武將的相性");

        randomizeNaturalDeathCheckbox.setText("隨機化");
        randomizeNaturalDeathCheckbox.setToolTipText("是否隨機化武將是否自然死的設定");

        jPanel5.setBorder(javax.swing.BorderFactory.createTitledBorder("武將生成方式"));

        officerGenerationTypeGroup.add(randomTypeOfficerRadio);
        randomTypeOfficerRadio.setSelected(true);
        randomTypeOfficerRadio.setText("完全隨意");
        randomTypeOfficerRadio.setToolTipText("<html>完全隨機地生成武將。影響包括：武將能力（生成50-100間的隨機數，可在武將能力中修正 )、<br>\n武將適性、武將特技、武將性格、部分隱藏數值如義理等");

        officerGenerationTypeGroup.add(typedOfficerRadio);
        typedOfficerRadio.setText("依種類");
        typedOfficerRadio.setToolTipText("<html>生成武將時先決定武將類型，然後依據這個類型作相應的隨機化。<br>影響包括：武將能力、武將適性、武將特技、武將性格、部分隱藏數值如義理等");

        officerTypePanel.setBorder(javax.swing.BorderFactory.createTitledBorder("武將種類比重"));
        officerTypePanel.setLayout(new java.awt.GridLayout(9, 4, 4, 4));

        jLabel14.setText("將軍");
        officerTypePanel.add(jLabel14);

        generalTypeWeightText.setText("1");
        generalTypeWeightText.setToolTipText("<html>設定將軍型的武將（如孫堅、馬超、呂布等）數量比重。<br>\n將軍型武將擁有較高的統率、武力、適性較高、特技也偏向戰鬥型，但智力及政治較低。");
        officerTypePanel.add(generalTypeWeightText);
        generalTypeWeightText.getDocument().addDocumentListener(new DocumentListener() {
            public void changedUpdate(DocumentEvent e) {
                updatePercentLabels();
            }
            public void removeUpdate(DocumentEvent e) {
                updatePercentLabels();
            }
            public void insertUpdate(DocumentEvent e) {
                updatePercentLabels();
            }
        });

        typePercentageLabel.setText("11.1%");
        officerTypePanel.add(typePercentageLabel);

        jLabel15.setText("猛將");
        officerTypePanel.add(jLabel15);

        mightyTypeWeightText.setText("1");
        mightyTypeWeightText.setToolTipText("<html>設定猛將型的武將（如典韋、許禇等）數量比重。<br>\n猛將型武將擁有很高的武力、特技也偏向戰鬥型，性格較莾撞，但其他能力，尤其智力及政治，均較低下。");
        officerTypePanel.add(mightyTypeWeightText);
        mightyTypeWeightText.getDocument().addDocumentListener(new DocumentListener() {
            public void changedUpdate(DocumentEvent e) {
                updatePercentLabels();
            }
            public void removeUpdate(DocumentEvent e) {
                updatePercentLabels();
            }
            public void insertUpdate(DocumentEvent e) {
                updatePercentLabels();
            }
        });

        typePercentageLabel1.setText("11.1%");
        officerTypePanel.add(typePercentageLabel1);

        jLabel16.setText("軍師");
        officerTypePanel.add(jLabel16);

        advisorTypeWeightText.setText("1");
        advisorTypeWeightText.setToolTipText("<html>設定軍師型的武將（如諸葛亮、司馬懿）數量比重。<br>\n軍師型武將擁有較高的統率、智力及政治，性格較冷靜，特技偏向計策型，但武力偏低。");
        officerTypePanel.add(advisorTypeWeightText);
        advisorTypeWeightText.getDocument().addDocumentListener(new DocumentListener() {
            public void changedUpdate(DocumentEvent e) {
                updatePercentLabels();
            }
            public void removeUpdate(DocumentEvent e) {
                updatePercentLabels();
            }
            public void insertUpdate(DocumentEvent e) {
                updatePercentLabels();
            }
        });

        typePercentageLabel2.setText("11.1%");
        officerTypePanel.add(typePercentageLabel2);

        jLabel17.setText("識者");
        officerTypePanel.add(jLabel17);

        politicianTypeWeightText.setText("1");
        politicianTypeWeightText.setToolTipText("<html>設定識者型的武將（如荀彧、張昭等）數量比重。<br>\n識者型武將擁有較高的智力及政治，特技偏向內政型，但統率、武力及適性也較低。");
        officerTypePanel.add(politicianTypeWeightText);
        politicianTypeWeightText.getDocument().addDocumentListener(new DocumentListener() {
            public void changedUpdate(DocumentEvent e) {
                updatePercentLabels();
            }
            public void removeUpdate(DocumentEvent e) {
                updatePercentLabels();
            }
            public void insertUpdate(DocumentEvent e) {
                updatePercentLabels();
            }
        });

        typePercentageLabel3.setText("11.1%");
        officerTypePanel.add(typePercentageLabel3);

        jLabel18.setText("智將");
        officerTypePanel.add(jLabel18);

        intelGeneralTypeWeightText.setText("1");
        intelGeneralTypeWeightText.setToolTipText("<html>設定智將型的武將（如姜維、甘寧等）數量比重。<br>\n智將型武將擁有較高的統率、武力、智力及適性，但政治較低。");
        officerTypePanel.add(intelGeneralTypeWeightText);
        intelGeneralTypeWeightText.getDocument().addDocumentListener(new DocumentListener() {
            public void changedUpdate(DocumentEvent e) {
                updatePercentLabels();
            }
            public void removeUpdate(DocumentEvent e) {
                updatePercentLabels();
            }
            public void insertUpdate(DocumentEvent e) {
                updatePercentLabels();
            }
        });

        typePercentageLabel4.setText("11.1%");
        officerTypePanel.add(typePercentageLabel4);

        jLabel19.setText("群雄");
        officerTypePanel.add(jLabel19);

        emperorTypeWeightText.setText("1");
        emperorTypeWeightText.setToolTipText("<html>設定群雄型的武將（如袁紹、張角等）數量比重。<br>\n群雄型武將能力較平均，武力稍低，魅力很高，野心較高。");
        officerTypePanel.add(emperorTypeWeightText);
        emperorTypeWeightText.getDocument().addDocumentListener(new DocumentListener() {
            public void changedUpdate(DocumentEvent e) {
                updatePercentLabels();
            }
            public void removeUpdate(DocumentEvent e) {
                updatePercentLabels();
            }
            public void insertUpdate(DocumentEvent e) {
                updatePercentLabels();
            }
        });

        typePercentageLabel5.setText("11.1%");
        officerTypePanel.add(typePercentageLabel5);

        jLabel20.setText("全能");
        officerTypePanel.add(jLabel20);

        allRounderTypeWeightText.setText("1");
        allRounderTypeWeightText.setToolTipText("<html>設定全能型的武將數量比重。<br>\n全能型武將擁有很高的能力、適性，而且較大機會擁有較強力的特技。");
        officerTypePanel.add(allRounderTypeWeightText);
        allRounderTypeWeightText.getDocument().addDocumentListener(new DocumentListener() {
            public void changedUpdate(DocumentEvent e) {
                updatePercentLabels();
            }
            public void removeUpdate(DocumentEvent e) {
                updatePercentLabels();
            }
            public void insertUpdate(DocumentEvent e) {
                updatePercentLabels();
            }
        });

        typePercentageLabel6.setText("11.1%");
        officerTypePanel.add(typePercentageLabel6);

        jLabel21.setText("平凡");
        officerTypePanel.add(jLabel21);

        normalTypeWeightText.setText("1");
        normalTypeWeightText.setToolTipText("<html>設定平凡型的武將數量比重。<br>\n平凡型武將各項能力一般，沒有突出的才華，較少有突出之處。");
        officerTypePanel.add(normalTypeWeightText);
        normalTypeWeightText.getDocument().addDocumentListener(new DocumentListener() {
            public void changedUpdate(DocumentEvent e) {
                updatePercentLabels();
            }
            public void removeUpdate(DocumentEvent e) {
                updatePercentLabels();
            }
            public void insertUpdate(DocumentEvent e) {
                updatePercentLabels();
            }
        });

        typePercentageLabel7.setText("11.1%");
        officerTypePanel.add(typePercentageLabel7);

        jLabel22.setText("庸才");
        officerTypePanel.add(jLabel22);

        cheapTypeWeightText.setText("1");
        cheapTypeWeightText.setToolTipText("<html>設定庸才型的武將數量比重。<br>\n庸才型武將各項能力低下，性格偏向膽小，而且義理及野心較低。");
        officerTypePanel.add(cheapTypeWeightText);
        cheapTypeWeightText.getDocument().addDocumentListener(new DocumentListener() {
            public void changedUpdate(DocumentEvent e) {
                updatePercentLabels();
            }
            public void removeUpdate(DocumentEvent e) {
                updatePercentLabels();
            }
            public void insertUpdate(DocumentEvent e) {
                updatePercentLabels();
            }
        });

        typePercentageLabel8.setText("11.1%");
        officerTypePanel.add(typePercentageLabel8);

        javax.swing.GroupLayout jPanel5Layout = new javax.swing.GroupLayout(jPanel5);
        jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(
            jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel5Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(officerTypePanel, javax.swing.GroupLayout.DEFAULT_SIZE, 173, Short.MAX_VALUE)
                    .addComponent(randomTypeOfficerRadio)
                    .addComponent(typedOfficerRadio))
                .addContainerGap())
        );
        jPanel5Layout.setVerticalGroup(
            jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel5Layout.createSequentialGroup()
                .addComponent(randomTypeOfficerRadio)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(typedOfficerRadio)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(officerTypePanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );

        jPanel15.setBorder(javax.swing.BorderFactory.createTitledBorder("處理武將數量"));

        randomizeCountGroup.add(officer670Radio);
        officer670Radio.setSelected(true);
        officer670Radio.setText("所有原有武將");
        officer670Radio.setToolTipText("把所有在一般劇本也會使用的武將(編號0-669)也進行處理。");

        randomizeCountGroup.add(officer700Radio);
        officer700Radio.setText("所有正常可用武將");
        officer700Radio.setToolTipText("<html>把所有在沒修改器的情況下使用的武將，包括光榮留下的30個武將空位\n<br>(即編號0-699)也進行處理。");

        randomizeCountGroup.add(officer800Radio);
        officer800Radio.setText("所有SIRE可用武將");
        officer800Radio.setToolTipText("把所有用上SIRE修改器可達至的最大數目的武將(共800個)也進行處理。");

        randomizeCountGroup.add(officerAnyRadio);
        officerAnyRadio.setText("指定數量");
        officerAnyRadio.setToolTipText("<html>指定隨機化武將的數目。其他武將將不會出現在劇本中。<br>\n注意：劇本中的君主不會被重設狀態，避免邏輯錯誤。");

        idHiText.setText("670");
        idHiText.setToolTipText("<html>指定隨機化武將的數目。其他武將將不會出現在劇本中。<br>\n注意：劇本中的君主不會被重設狀態，避免邏輯錯誤。");

        randomizeDeadOnlyCheckbox.setText("只隨機化已死或沒狀態武將");
        randomizeDeadOnlyCheckbox.setToolTipText("只隨機化劇本中已死或沒狀態武將，可用於增加武將而不影響原來在劇本中的武將。");

        javax.swing.GroupLayout jPanel15Layout = new javax.swing.GroupLayout(jPanel15);
        jPanel15.setLayout(jPanel15Layout);
        jPanel15Layout.setHorizontalGroup(
            jPanel15Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel15Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel15Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel15Layout.createSequentialGroup()
                        .addGroup(jPanel15Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(officer700Radio)
                            .addComponent(officer670Radio))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addGroup(jPanel15Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(jPanel15Layout.createSequentialGroup()
                                .addComponent(officerAnyRadio)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(idHiText, javax.swing.GroupLayout.PREFERRED_SIZE, 83, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addComponent(officer800Radio)))
                    .addComponent(randomizeDeadOnlyCheckbox))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        jPanel15Layout.setVerticalGroup(
            jPanel15Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel15Layout.createSequentialGroup()
                .addGroup(jPanel15Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(officer670Radio)
                    .addComponent(officerAnyRadio)
                    .addComponent(idHiText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel15Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(officer700Radio)
                    .addComponent(officer800Radio))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(randomizeDeadOnlyCheckbox))
        );

        jPanel28.setBorder(javax.swing.BorderFactory.createTitledBorder("生成名稱方法"));

        buttonGroup1.add(combineNameRadio);
        combineNameRadio.setSelected(true);
        combineNameRadio.setText("姓氏+名稱隨機化");
        combineNameRadio.setToolTipText("隨機選取姓氏及名稱，然後組合。");

        buttonGroup1.add(directNameRadio);
        directNameRadio.setText("從名稱列表直接隨機選取");
        directNameRadio.setToolTipText("從malenames.txt及femalenames.txt中的名稱列表中，直接隨機抽選一個作為武將姓名。");

        noSurnameChangeCheckbox.setText("不容許姓氏被改變");
        noSurnameChangeCheckbox.setToolTipText("隨機化父子關係時，會把武將的姓氏改變，點上這選項以防止這事情發生。");

        javax.swing.GroupLayout jPanel28Layout = new javax.swing.GroupLayout(jPanel28);
        jPanel28.setLayout(jPanel28Layout);
        jPanel28Layout.setHorizontalGroup(
            jPanel28Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(combineNameRadio)
            .addComponent(directNameRadio)
            .addComponent(noSurnameChangeCheckbox)
        );
        jPanel28Layout.setVerticalGroup(
            jPanel28Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel28Layout.createSequentialGroup()
                .addComponent(combineNameRadio)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(directNameRadio)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 3, Short.MAX_VALUE)
                .addComponent(noSurnameChangeCheckbox))
        );

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(jPanel1Layout.createSequentialGroup()
                                .addComponent(jPanel15, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jPanel28, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addGroup(jPanel1Layout.createSequentialGroup()
                                .addComponent(jLabel1)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(femaleOfficerProbSlider, javax.swing.GroupLayout.PREFERRED_SIZE, 281, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(femaleOfficerProbLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 32, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGap(7, 7, 7)
                                .addComponent(randomizeGenderCheckbox))
                            .addGroup(jPanel1Layout.createSequentialGroup()
                                .addComponent(jLabel2)
                                .addGap(16, 16, 16)
                                .addComponent(doubleNameProbSlider, javax.swing.GroupLayout.PREFERRED_SIZE, 281, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGap(4, 4, 4)
                                .addComponent(doubleNameProbLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 32, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGap(7, 7, 7)
                                .addComponent(randomizeNameCheckbox))
                            .addGroup(jPanel1Layout.createSequentialGroup()
                                .addComponent(jPanel3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addGroup(jPanel1Layout.createSequentialGroup()
                                .addComponent(jLabel11)
                                .addGap(4, 4, 4)
                                .addComponent(attachmentLoText, javax.swing.GroupLayout.PREFERRED_SIZE, 61, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGap(4, 4, 4)
                                .addComponent(jLabel12)
                                .addGap(4, 4, 4)
                                .addComponent(attachmentHiText, javax.swing.GroupLayout.PREFERRED_SIZE, 61, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGap(2, 2, 2)
                                .addComponent(randomizeAttachmentCheckbox)))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jPanel5, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(jLabel13)
                        .addGap(4, 4, 4)
                        .addComponent(naturalDeathProbSlider, javax.swing.GroupLayout.PREFERRED_SIZE, 281, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(natrualDeathProbLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 32, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(7, 7, 7)
                        .addComponent(randomizeNaturalDeathCheckbox)))
                .addContainerGap())
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addGap(14, 14, 14)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel28, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanel15, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGap(8, 8, 8)
                        .addComponent(jLabel1))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGap(4, 4, 4)
                        .addComponent(randomizeGenderCheckbox))
                    .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                        .addComponent(femaleOfficerProbSlider, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(femaleOfficerProbLabel)))
                .addGap(2, 2, 2)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGap(4, 4, 4)
                        .addComponent(jLabel2))
                    .addComponent(doubleNameProbSlider, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGap(4, 4, 4)
                        .addComponent(doubleNameProbLabel))
                    .addComponent(randomizeNameCheckbox))
                .addGap(10, 10, 10)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jPanel3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(9, 9, 9)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGap(4, 4, 4)
                        .addComponent(jLabel11))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGap(1, 1, 1)
                        .addComponent(attachmentLoText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGap(4, 4, 4)
                        .addComponent(jLabel12))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGap(1, 1, 1)
                        .addComponent(attachmentHiText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addComponent(randomizeAttachmentCheckbox))
                .addGap(5, 5, 5)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGap(4, 4, 4)
                        .addComponent(jLabel13))
                    .addComponent(naturalDeathProbSlider, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(randomizeNaturalDeathCheckbox)
                        .addComponent(natrualDeathProbLabel)))
                .addGap(34, 34, 34))
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel5, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(75, Short.MAX_VALUE))
        );

        jTabbedPane1.addTab("基本", jPanel1);

        jPanel7.setBorder(javax.swing.BorderFactory.createTitledBorder("武將能力調整"));

        jLabel23.setText("能力 = 隨機得出能力 x ");

        abilityMulText.setText("1");
        abilityMulText.setToolTipText("把所有武將的能力隨機化後，再乘上這個數字作修正");

        jLabel24.setText("+");

        abilityAbsText.setText("0");
        abilityAbsText.setToolTipText("把所有武將的能力隨機化後，再加上這個數字作修正");

        jLabel25.setText("能力上限");

        abilityHiText.setText("100");
        abilityHiText.setToolTipText("經所有加成後的最終能力上限");

        jLabel26.setText("能力下限");

        abilityLoText.setText("1");
        abilityLoText.setToolTipText("經所有加成後的最終能力下限");

        randomizeAbilityCheckbox.setText("隨機化武將能力");
        randomizeAbilityCheckbox.setToolTipText("是否隨機化武將能力");

        randomizeGrowthTypeCheckbox.setText("隨機化成長類型");
        randomizeGrowthTypeCheckbox.setToolTipText("是否隨機化武將的成長類型");

        useSpecialGrowthTypeCheckbox.setText("使用開眼型成長類型");
        useSpecialGrowthTypeCheckbox.setToolTipText("隨機化成長類型時，是否使用開眼型（張飛型）的成長類型。");

        javax.swing.GroupLayout jPanel7Layout = new javax.swing.GroupLayout(jPanel7);
        jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(
            jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel7Layout.createSequentialGroup()
                .addGap(10, 10, 10)
                .addGroup(jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel7Layout.createSequentialGroup()
                        .addComponent(jLabel23)
                        .addGap(6, 6, 6)
                        .addComponent(abilityMulText, javax.swing.GroupLayout.PREFERRED_SIZE, 60, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(4, 4, 4)
                        .addComponent(jLabel24)
                        .addGap(4, 4, 4)
                        .addComponent(abilityAbsText, javax.swing.GroupLayout.PREFERRED_SIZE, 60, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel7Layout.createSequentialGroup()
                        .addComponent(jLabel25)
                        .addGap(4, 4, 4)
                        .addComponent(abilityHiText, javax.swing.GroupLayout.PREFERRED_SIZE, 68, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel7Layout.createSequentialGroup()
                        .addComponent(jLabel26)
                        .addGap(4, 4, 4)
                        .addComponent(abilityLoText, javax.swing.GroupLayout.PREFERRED_SIZE, 68, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel7Layout.createSequentialGroup()
                        .addComponent(randomizeGrowthTypeCheckbox)
                        .addComponent(useSpecialGrowthTypeCheckbox))
                    .addComponent(randomizeAbilityCheckbox))
                .addContainerGap(76, Short.MAX_VALUE))
        );
        jPanel7Layout.setVerticalGroup(
            jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel7Layout.createSequentialGroup()
                .addGroup(jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel7Layout.createSequentialGroup()
                        .addGap(3, 3, 3)
                        .addComponent(jLabel23))
                    .addComponent(abilityMulText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(jPanel7Layout.createSequentialGroup()
                        .addGap(3, 3, 3)
                        .addComponent(jLabel24))
                    .addComponent(abilityAbsText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(6, 6, 6)
                .addGroup(jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel7Layout.createSequentialGroup()
                        .addGap(3, 3, 3)
                        .addComponent(jLabel25))
                    .addComponent(abilityHiText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(6, 6, 6)
                .addGroup(jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel7Layout.createSequentialGroup()
                        .addGap(3, 3, 3)
                        .addComponent(jLabel26))
                    .addComponent(abilityLoText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(6, 6, 6)
                .addComponent(randomizeAbilityCheckbox)
                .addGroup(jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(randomizeGrowthTypeCheckbox)
                    .addComponent(useSpecialGrowthTypeCheckbox)))
        );

        jPanel8.setBorder(javax.swing.BorderFactory.createTitledBorder("適性調整"));

        jLabel27.setText("適性 = 隨機得出適性 x ");

        adaptabilityMulText.setText("1");
        adaptabilityMulText.setToolTipText("把所有武將的適性的對應值（Ｃ為０，Ｓ為３）隨機化後，再乘上這個數字作修正");

        jLabel28.setText("+");

        adaptabilityAbsText.setText("0");
        adaptabilityAbsText.setToolTipText("把所有武將的適性的對應值（Ｃ為０，Ｓ為３）隨機化後，再加上這個數字作修正");

        jLabel29.setText("適性上限");

        jLabel30.setText("適性下限");

        randomizeAdaptabilityCheckbox.setText("隨機化武將適性");
        randomizeAdaptabilityCheckbox.setToolTipText("是否隨機化武將的兵種適性");

        adaptabilityHiCombo.setMaximumRowCount(18);
        adaptabilityHiCombo.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Ｃ", "Ｂ", "Ａ", "Ｓ", "Ｓ+10%", "Ｓ+20%", "Ｓ+30%", "Ｓ+40%", "Ｓ+50%", "Ｓ+60%", "Ｓ+70%", "Ｓ+80%", "Ｓ+90%", "Ｓ+100%", "Ｓ+110%", "Ｓ+120%", "Ｓ+130%" }));
        adaptabilityHiCombo.setSelectedIndex(3);
        adaptabilityHiCombo.setToolTipText("經所有加成後的最終適性上限");

        adaptabilityLoCombo.setMaximumRowCount(18);
        adaptabilityLoCombo.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Ｃ", "Ｂ", "Ａ", "Ｓ", "Ｓ+10%", "Ｓ+20%", "Ｓ+30%", "Ｓ+40%", "Ｓ+50%", "Ｓ+60%", "Ｓ+70%", "Ｓ+80%", "Ｓ+90%", "Ｓ+100%", "Ｓ+110%", "Ｓ+120%", "Ｓ+130%" }));
        adaptabilityLoCombo.setToolTipText("經所有加成後的最終適性下限");

        javax.swing.GroupLayout jPanel8Layout = new javax.swing.GroupLayout(jPanel8);
        jPanel8.setLayout(jPanel8Layout);
        jPanel8Layout.setHorizontalGroup(
            jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel8Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(randomizeAdaptabilityCheckbox)
                    .addGroup(jPanel8Layout.createSequentialGroup()
                        .addGroup(jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(jPanel8Layout.createSequentialGroup()
                                .addComponent(jLabel30)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(adaptabilityLoCombo, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addGroup(jPanel8Layout.createSequentialGroup()
                                .addComponent(jLabel29)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(adaptabilityHiCombo, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addComponent(jLabel27))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(adaptabilityMulText, javax.swing.GroupLayout.PREFERRED_SIZE, 60, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabel28)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(adaptabilityAbsText, javax.swing.GroupLayout.PREFERRED_SIZE, 60, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap(72, Short.MAX_VALUE))
        );
        jPanel8Layout.setVerticalGroup(
            jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel8Layout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGroup(jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel27)
                    .addComponent(adaptabilityMulText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel28)
                    .addComponent(adaptabilityAbsText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel29)
                    .addComponent(adaptabilityHiCombo, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel30)
                    .addComponent(adaptabilityLoCombo, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(randomizeAdaptabilityCheckbox))
        );

        jPanel9.setBorder(javax.swing.BorderFactory.createTitledBorder("特技"));

        randomizeSpecialGroup.add(randomizeNoSpecialRadio);
        randomizeNoSpecialRadio.setSelected(true);
        randomizeNoSpecialRadio.setText("不要隨機化特技");
        randomizeNoSpecialRadio.setToolTipText("不要變動武將的特技");

        randomizeSpecialGroup.add(randomizeNormalSpecialRadio);
        randomizeNormalSpecialRadio.setText("只使用一般特技");
        randomizeNormalSpecialRadio.setToolTipText("隨機化特技時只使用官方特技");

        randomizeSpecialGroup.add(randomizeSireSpecialRadio);
        randomizeSireSpecialRadio.setText("使用一般及SIRE預設新增特技");
        randomizeSireSpecialRadio.setToolTipText("隨機化特技時使用官方特技及SIRE加入的特技(編號120-145,148,149)");

        randomizeSpecialGroup.add(randomizeAllSpecialRadio);
        randomizeAllSpecialRadio.setText("使用一般及SIRE自訂特技至編號");
        randomizeAllSpecialRadio.setToolTipText("隨機化特技時使用特技編號0至特定編號");

        jPanel10.setBorder(javax.swing.BorderFactory.createTitledBorder("無特技機率"));
        jPanel10.setMinimumSize(new java.awt.Dimension(136, 297));
        jPanel10.setLayout(new java.awt.GridLayout(9, 3, 8, 8));

        jLabel31.setText("將軍");
        jPanel10.add(jLabel31);

        noSpecialProb1Slider.setMajorTickSpacing(10);
        noSpecialProb1Slider.setMinorTickSpacing(1);
        noSpecialProb1Slider.setToolTipText("將軍型武將得不到特技的機率");
        noSpecialProb1Slider.setValue(0);
        noSpecialProb1Slider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                noSpecialProb1SliderStateChanged(evt);
            }
        });
        jPanel10.add(noSpecialProb1Slider);

        noSpecialProb1Label.setText("0%");
        jPanel10.add(noSpecialProb1Label);

        jLabel32.setText("猛將");
        jPanel10.add(jLabel32);

        noSpecialProb1Slider1.setMajorTickSpacing(10);
        noSpecialProb1Slider1.setMinorTickSpacing(1);
        noSpecialProb1Slider1.setToolTipText("猛將型武將得不到特技的機率");
        noSpecialProb1Slider1.setValue(0);
        noSpecialProb1Slider1.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                noSpecialProb1Slider1StateChanged(evt);
            }
        });
        jPanel10.add(noSpecialProb1Slider1);

        noSpecialProb1Label1.setText("0%");
        jPanel10.add(noSpecialProb1Label1);

        jLabel33.setText("軍師");
        jPanel10.add(jLabel33);

        noSpecialProb1Slider2.setMajorTickSpacing(10);
        noSpecialProb1Slider2.setMinorTickSpacing(1);
        noSpecialProb1Slider2.setToolTipText("軍師型武將得不到特技的機率");
        noSpecialProb1Slider2.setValue(0);
        noSpecialProb1Slider2.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                noSpecialProb1Slider2StateChanged(evt);
            }
        });
        jPanel10.add(noSpecialProb1Slider2);

        noSpecialProb1Label2.setText("0%");
        jPanel10.add(noSpecialProb1Label2);

        jLabel34.setText("識者");
        jPanel10.add(jLabel34);

        noSpecialProb1Slider3.setMajorTickSpacing(10);
        noSpecialProb1Slider3.setMinorTickSpacing(1);
        noSpecialProb1Slider3.setToolTipText("識者型武將得不到特技的機率");
        noSpecialProb1Slider3.setValue(0);
        noSpecialProb1Slider3.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                noSpecialProb1Slider3StateChanged(evt);
            }
        });
        jPanel10.add(noSpecialProb1Slider3);

        noSpecialProb1Label3.setText("0%");
        jPanel10.add(noSpecialProb1Label3);

        jLabel35.setText("智將");
        jPanel10.add(jLabel35);

        noSpecialProb1Slider4.setMajorTickSpacing(10);
        noSpecialProb1Slider4.setMinorTickSpacing(1);
        noSpecialProb1Slider4.setToolTipText("智將型武將得不到特技的機率");
        noSpecialProb1Slider4.setValue(0);
        noSpecialProb1Slider4.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                noSpecialProb1Slider4StateChanged(evt);
            }
        });
        jPanel10.add(noSpecialProb1Slider4);

        noSpecialProb1Label4.setText("0%");
        jPanel10.add(noSpecialProb1Label4);

        jLabel36.setText("群雄");
        jPanel10.add(jLabel36);

        noSpecialProb1Slider5.setMajorTickSpacing(10);
        noSpecialProb1Slider5.setMinorTickSpacing(1);
        noSpecialProb1Slider5.setToolTipText("群雄型武將得不到特技的機率");
        noSpecialProb1Slider5.setValue(0);
        noSpecialProb1Slider5.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                noSpecialProb1Slider5StateChanged(evt);
            }
        });
        jPanel10.add(noSpecialProb1Slider5);

        noSpecialProb1Label5.setText("0%");
        jPanel10.add(noSpecialProb1Label5);

        jLabel37.setText("全能");
        jPanel10.add(jLabel37);

        noSpecialProb1Slider6.setMajorTickSpacing(10);
        noSpecialProb1Slider6.setMinorTickSpacing(1);
        noSpecialProb1Slider6.setToolTipText("全能型武將得不到特技的機率");
        noSpecialProb1Slider6.setValue(0);
        noSpecialProb1Slider6.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                noSpecialProb1Slider6StateChanged(evt);
            }
        });
        jPanel10.add(noSpecialProb1Slider6);

        noSpecialProb1Label6.setText("0%");
        jPanel10.add(noSpecialProb1Label6);

        jLabel38.setText("平凡");
        jPanel10.add(jLabel38);

        noSpecialProb1Slider7.setMajorTickSpacing(10);
        noSpecialProb1Slider7.setMinorTickSpacing(1);
        noSpecialProb1Slider7.setToolTipText("平凡型武將得不到特技的機率");
        noSpecialProb1Slider7.setValue(40);
        noSpecialProb1Slider7.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                noSpecialProb1Slider7StateChanged(evt);
            }
        });
        jPanel10.add(noSpecialProb1Slider7);

        noSpecialProb1Label7.setText("40%");
        jPanel10.add(noSpecialProb1Label7);

        jLabel39.setText("庸才");
        jPanel10.add(jLabel39);

        noSpecialProb1Slider8.setMajorTickSpacing(10);
        noSpecialProb1Slider8.setMinorTickSpacing(1);
        noSpecialProb1Slider8.setToolTipText("庸才型武將得不到特技的機率");
        noSpecialProb1Slider8.setValue(80);
        noSpecialProb1Slider8.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                noSpecialProb1Slider8StateChanged(evt);
            }
        });
        jPanel10.add(noSpecialProb1Slider8);

        noSpecialProb1Label8.setText("80%");
        jPanel10.add(noSpecialProb1Label8);

        randomizeAllSpecialText.setText("200");
        randomizeAllSpecialText.setToolTipText("隨機化特技時使用特技編號0至特定編號");

        randomizeSpecialGroup.add(clearSpecialRadio);
        clearSpecialRadio.setText("清空所有特技");
        clearSpecialRadio.setToolTipText("把所有武將的特技也清空（白板）");

        javax.swing.GroupLayout jPanel9Layout = new javax.swing.GroupLayout(jPanel9);
        jPanel9.setLayout(jPanel9Layout);
        jPanel9Layout.setHorizontalGroup(
            jPanel9Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel9Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel9Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel10, javax.swing.GroupLayout.PREFERRED_SIZE, 299, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(jPanel9Layout.createSequentialGroup()
                        .addComponent(randomizeNoSpecialRadio)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(clearSpecialRadio))
                    .addComponent(randomizeNormalSpecialRadio)
                    .addComponent(randomizeSireSpecialRadio)
                    .addGroup(jPanel9Layout.createSequentialGroup()
                        .addComponent(randomizeAllSpecialRadio)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(randomizeAllSpecialText, javax.swing.GroupLayout.PREFERRED_SIZE, 93, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap())
        );
        jPanel9Layout.setVerticalGroup(
            jPanel9Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel9Layout.createSequentialGroup()
                .addGroup(jPanel9Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(randomizeNoSpecialRadio)
                    .addComponent(clearSpecialRadio))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(randomizeNormalSpecialRadio)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(randomizeSireSpecialRadio)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel9Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(randomizeAllSpecialRadio)
                    .addComponent(randomizeAllSpecialText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel10, javax.swing.GroupLayout.PREFERRED_SIZE, 273, javax.swing.GroupLayout.PREFERRED_SIZE))
        );

        jPanel29.setBorder(javax.swing.BorderFactory.createTitledBorder("生成組合特技"));

        jLabel169.setText("生成特技編號");

        generateCombineSkillCheckbox.setText("生成組合特技");
        generateCombineSkillCheckbox.setToolTipText("<html>生成SIRE組合特技。這功能會在修改器的資料夾中生成一個名為generated.skill的檔案，\n<br>要使用生成組合特技者，開啟SIRE修改器並導入generated.skill即可");

        combineSkillIdLoText.setText("150");
        combineSkillIdLoText.setToolTipText("生成特技的編號範圍");

        jLabel171.setText("至");

        combineSkillIdHiText.setText("200");
        combineSkillIdHiText.setToolTipText("生成特技的編號範圍");

        jLabel172.setText("特技組合數量");

        combineSkillCntLoText.setText("2");
        combineSkillCntLoText.setToolTipText("組合特技時，最少組合的特技個數");

        jLabel173.setText("至");

        combineSkillCntHiText.setText("8");
        combineSkillCntHiText.setToolTipText("組合特技時，最多組合的特技個數");

        javax.swing.GroupLayout jPanel29Layout = new javax.swing.GroupLayout(jPanel29);
        jPanel29.setLayout(jPanel29Layout);
        jPanel29Layout.setHorizontalGroup(
            jPanel29Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel29Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel29Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel29Layout.createSequentialGroup()
                        .addComponent(generateCombineSkillCheckbox)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jLabel169)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 10, Short.MAX_VALUE)
                        .addComponent(combineSkillIdLoText, javax.swing.GroupLayout.PREFERRED_SIZE, 57, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(7, 7, 7)
                        .addComponent(jLabel171)
                        .addGap(8, 8, 8)
                        .addComponent(combineSkillIdHiText, javax.swing.GroupLayout.PREFERRED_SIZE, 57, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel29Layout.createSequentialGroup()
                        .addComponent(jLabel172)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(combineSkillCntLoText, javax.swing.GroupLayout.PREFERRED_SIZE, 25, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabel173)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(combineSkillCntHiText, javax.swing.GroupLayout.PREFERRED_SIZE, 23, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap())
        );
        jPanel29Layout.setVerticalGroup(
            jPanel29Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel29Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel29Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addGroup(jPanel29Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addComponent(combineSkillIdLoText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGroup(jPanel29Layout.createSequentialGroup()
                            .addGap(2, 2, 2)
                            .addComponent(jLabel171))
                        .addComponent(combineSkillIdHiText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel29Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(generateCombineSkillCheckbox)
                        .addComponent(jLabel169)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel29Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addGroup(jPanel29Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(jLabel172)
                        .addComponent(combineSkillCntLoText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel29Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(jLabel173)
                        .addComponent(combineSkillCntHiText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout jPanel4Layout = new javax.swing.GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel4Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel29, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanel7, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanel8, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel9, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
        jPanel4Layout.setVerticalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel4Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel9, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(jPanel4Layout.createSequentialGroup()
                        .addComponent(jPanel7, javax.swing.GroupLayout.PREFERRED_SIZE, 158, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jPanel8, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jPanel29, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
                .addGap(10, 10, 10))
        );

        jTabbedPane1.addTab("武將能力", jPanel4);

        clearOfficerCheckbox.setText("清空官職");
        clearOfficerCheckbox.setToolTipText("<html>把所有武將的官職清空。<br>\n假若武將的所屬改變，建議點上這選項，否則可能會出現一個勢力中有多個武將擁有同一官職。");

        jPanel12.setBorder(javax.swing.BorderFactory.createTitledBorder("忠誠"));

        jLabel43.setText("君主忠誠");

        kingLoyaltyLoText.setText("100");
        kingLoyaltyLoText.setToolTipText("隨機化君主的「忠誠」。忠誠低下者滅國時有較大機會馬上投降。");

        jLabel44.setText("至");

        kingLoyaltyHiText.setText("100");
        kingLoyaltyHiText.setToolTipText("隨機化君主的「忠誠」。忠誠低下者滅國時有較大機會馬上投降。");

        closeLoyaltyHiText.setText("255");
        closeLoyaltyHiText.setToolTipText("若武將仕官的君主為該武將的配偶或義兄弟時，該武將的忠誠。");

        jLabel45.setText("至");

        closeLoyaltyLoText.setText("150");
        closeLoyaltyLoText.setToolTipText("若武將仕官的君主為該武將的配偶或義兄弟時，該武將的忠誠。");

        jLabel46.setText("親密忠誠");

        imitateLoyaltyHiText.setText("120");
        imitateLoyaltyHiText.setToolTipText("若武將仕官的君主為該武將的親愛武將時，該武將的忠誠。");

        jLabel47.setText("至");

        imitateLoyaltyLoText.setText("120");
        imitateLoyaltyLoText.setToolTipText("若武將仕官的君主為該武將的親愛武將時，該武將的忠誠。");

        jLabel48.setText("親愛忠誠");

        hateLoyaltyHiText.setText("80");
        hateLoyaltyHiText.setToolTipText("若武將仕官的君主為該武將的厭惡武將時，該武將的忠誠。");

        jLabel49.setText("至");

        hateLoyaltyLoText.setText("60");
        hateLoyaltyLoText.setToolTipText("若武將仕官的君主為該武將的厭惡武將時，該武將的忠誠。");

        jLabel50.setText("厭惡忠誠");

        bloodLoyaltyHiText.setText("120");
        bloodLoyaltyHiText.setToolTipText("若武將仕官的君主與該武將有血緣關係時，該武將的忠誠。");

        jLabel51.setText("至");

        bloodLoyaltyLoText.setText("120");
        bloodLoyaltyLoText.setToolTipText("若武將仕官的君主與該武將有血緣關係時，該武將的忠誠。");

        jLabel52.setText("血緣忠誠");

        jLabel53.setText("一般忠誠上限");

        jLabel54.setText("一般忠誠相性遞減");

        normalLoyaltyHiText.setText("105");
        normalLoyaltyHiText.setToolTipText("若武將仕官的君主與該武將沒特殊關係（以上各種情況），而相性契合時的武將忠誠。");

        normalLoyaltyRangeText.setText("15");
        normalLoyaltyRangeText.setToolTipText("若武將仕官的君主與該武將沒特殊關係（以上各種情況），該武將忠誠依該武將與君主的相性差遞減的程度。");

        randomizeLoyaltyCheckbox.setText("隨機化");
        randomizeLoyaltyCheckbox.setToolTipText("<html>是否隨機化武將的忠誠<br>\n假若點上了重新分佈武將的選項，建議點上這項，否則可能會出現部分在野武將沒法登庸，仕官武將零忠誠的情況。");

        javax.swing.GroupLayout jPanel12Layout = new javax.swing.GroupLayout(jPanel12);
        jPanel12.setLayout(jPanel12Layout);
        jPanel12Layout.setHorizontalGroup(
            jPanel12Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel12Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel12Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel12Layout.createSequentialGroup()
                        .addComponent(jLabel43)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(kingLoyaltyLoText, javax.swing.GroupLayout.PREFERRED_SIZE, 74, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabel44)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(kingLoyaltyHiText, javax.swing.GroupLayout.PREFERRED_SIZE, 74, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel12Layout.createSequentialGroup()
                        .addComponent(jLabel46)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(closeLoyaltyLoText, javax.swing.GroupLayout.PREFERRED_SIZE, 74, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabel45)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(closeLoyaltyHiText, javax.swing.GroupLayout.PREFERRED_SIZE, 74, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel12Layout.createSequentialGroup()
                        .addComponent(jLabel48)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(imitateLoyaltyLoText, javax.swing.GroupLayout.PREFERRED_SIZE, 74, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabel47)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(imitateLoyaltyHiText, javax.swing.GroupLayout.PREFERRED_SIZE, 74, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel12Layout.createSequentialGroup()
                        .addComponent(jLabel50)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(hateLoyaltyLoText, javax.swing.GroupLayout.PREFERRED_SIZE, 74, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabel49)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(hateLoyaltyHiText, javax.swing.GroupLayout.PREFERRED_SIZE, 74, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel12Layout.createSequentialGroup()
                        .addComponent(jLabel52)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(bloodLoyaltyLoText, javax.swing.GroupLayout.PREFERRED_SIZE, 74, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabel51)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(bloodLoyaltyHiText, javax.swing.GroupLayout.PREFERRED_SIZE, 74, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel12Layout.createSequentialGroup()
                        .addComponent(jLabel53)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(normalLoyaltyHiText, javax.swing.GroupLayout.PREFERRED_SIZE, 82, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel12Layout.createSequentialGroup()
                        .addComponent(jLabel54)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(normalLoyaltyRangeText, javax.swing.GroupLayout.PREFERRED_SIZE, 84, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addComponent(randomizeLoyaltyCheckbox))
                .addContainerGap(10, Short.MAX_VALUE))
        );
        jPanel12Layout.setVerticalGroup(
            jPanel12Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel12Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel12Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel43)
                    .addComponent(kingLoyaltyLoText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel44)
                    .addComponent(kingLoyaltyHiText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel12Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel46)
                    .addComponent(closeLoyaltyLoText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel45)
                    .addComponent(closeLoyaltyHiText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel12Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel48)
                    .addComponent(imitateLoyaltyLoText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel47)
                    .addComponent(imitateLoyaltyHiText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel12Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel50)
                    .addComponent(hateLoyaltyLoText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel49)
                    .addComponent(hateLoyaltyHiText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel12Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel52)
                    .addComponent(bloodLoyaltyLoText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel51)
                    .addComponent(bloodLoyaltyHiText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel12Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel53)
                    .addComponent(normalLoyaltyHiText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel12Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel54)
                    .addComponent(normalLoyaltyRangeText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(randomizeLoyaltyCheckbox)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jPanel13.setBorder(javax.swing.BorderFactory.createTitledBorder("所屬/所在"));

        teamGroup.add(noChangeTeamRadio);
        noChangeTeamRadio.setSelected(true);
        noChangeTeamRadio.setText("不要變更所屬");
        noChangeTeamRadio.setToolTipText("不變更武將的所屬及所在");

        teamGroup.add(changeUnemployedTeamRadio);
        changeUnemployedTeamRadio.setText("只變更沒仕官武將所在");
        changeUnemployedTeamRadio.setToolTipText("只變更在野、未發現或未登場武將的所在");

        teamGroup.add(changeAllTeamRadio);
        changeAllTeamRadio.setText("變更君主以外所有武將所屬/所在");
        changeAllTeamRadio.setToolTipText("變更君主以外所有武將的所屬及所在");

        jLabel40.setText("前往沒所屬城池比重");

        goNoTeamWeightLoText.setText("2");
        goNoTeamWeightLoText.setToolTipText("當把武將重新分佈時，武將被編往沒所屬城池的機率比重");

        jLabel41.setText("前往有所屬城池比重");

        goHaveTeamWeightLoText.setText("5");
        goHaveTeamWeightLoText.setToolTipText("當把武將重新分佈時，武將被編往有所屬城池的機率比重");

        jLabel42.setText("有所屬城池仕官武將比率");

        employProbSlider.setMajorTickSpacing(10);
        employProbSlider.setMinorTickSpacing(1);
        employProbSlider.setToolTipText("武將被編往有所屬城池後，在該城池仕官的機率");
        employProbSlider.setValue(70);
        employProbSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                employProbSliderStateChanged(evt);
            }
        });

        employProbLabel.setText("70%");

        jLabel88.setText("至");

        jLabel89.setText("至");

        goNoTeamWeightHiText.setText("2");
        goNoTeamWeightHiText.setToolTipText("當把武將重新分佈時，武將被編往沒所屬城池的機率比重");

        goHaveTeamWeightHiText.setText("5");
        goHaveTeamWeightHiText.setToolTipText("當把武將重新分佈時，武將被編往有所屬城池的機率比重");

        javax.swing.GroupLayout jPanel13Layout = new javax.swing.GroupLayout(jPanel13);
        jPanel13.setLayout(jPanel13Layout);
        jPanel13Layout.setHorizontalGroup(
            jPanel13Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel13Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel13Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel13Layout.createSequentialGroup()
                        .addComponent(jLabel42)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(employProbSlider, javax.swing.GroupLayout.PREFERRED_SIZE, 147, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(4, 4, 4)
                        .addComponent(employProbLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 37, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addComponent(noChangeTeamRadio)
                    .addComponent(changeUnemployedTeamRadio)
                    .addComponent(changeAllTeamRadio)
                    .addGroup(jPanel13Layout.createSequentialGroup()
                        .addComponent(jLabel40)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(goNoTeamWeightLoText, javax.swing.GroupLayout.PREFERRED_SIZE, 67, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabel88)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(goNoTeamWeightHiText, javax.swing.GroupLayout.PREFERRED_SIZE, 67, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel13Layout.createSequentialGroup()
                        .addComponent(jLabel41)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(goHaveTeamWeightLoText, javax.swing.GroupLayout.PREFERRED_SIZE, 67, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabel89)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(goHaveTeamWeightHiText, javax.swing.GroupLayout.PREFERRED_SIZE, 67, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addGap(15, 15, 15))
        );
        jPanel13Layout.setVerticalGroup(
            jPanel13Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel13Layout.createSequentialGroup()
                .addComponent(noChangeTeamRadio)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(changeUnemployedTeamRadio)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(changeAllTeamRadio)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel13Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(goNoTeamWeightLoText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel40)
                    .addComponent(jLabel88)
                    .addComponent(goNoTeamWeightHiText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel13Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel41)
                    .addComponent(goHaveTeamWeightLoText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel89)
                    .addComponent(goHaveTeamWeightHiText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel13Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(employProbLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 20, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel42)
                    .addComponent(employProbSlider, javax.swing.GroupLayout.PREFERRED_SIZE, 20, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );

        randomizeHiddenValuesCheckbox.setText("隨機化隱藏特性");
        randomizeHiddenValuesCheckbox.setToolTipText("隨機化武將的隱藏特性，包括義理、野心、性格、音聲、語調、出身地、地緣執著、漢室、戰略傾向、舌戰得意話題。");

        useSpecialSpeechCheckbox.setText("使用特殊語調");
        useSpecialSpeechCheckbox.setToolTipText("隨機化武將語氣與語調時，使用呂布及諸葛亮型的音聲，使用關羽、張飛型的語調。");

        modelGenderCheckbox.setText("隨機化3D模組時根據性別");
        modelGenderCheckbox.setToolTipText("隨機化武將的3D造型時以其性別設定");

        useSpecial3dModelCheckbox.setText("使用特殊3D模組");
        useSpecial3dModelCheckbox.setToolTipText("隨機化武將的3D造型時使用有名武將的造型。");

        jLabel86.setText("功績");

        meritoriousLoText.setText("0");
        meritoriousLoText.setToolTipText("隨機化功績下限");

        jLabel87.setText("至");

        meritoriousHiText.setText("0");
        meritoriousHiText.setToolTipText("隨機化功績上限");

        randomizeMeritoriousCheckbox.setText("隨機化");
        randomizeMeritoriousCheckbox.setToolTipText("是否隨機化武將的功績");

        randomize3dModelCheckbox.setText("隨機化3D模組");
        randomize3dModelCheckbox.setToolTipText("隨機化武將的3D造型");

        modelTypeCheckbox.setText("隨機化3D模組時根據文武官");
        modelTypeCheckbox.setToolTipText("隨機化武將的3D造型時，統武較高者分配武官模組，智政較高者分配文官模組");

        javax.swing.GroupLayout jPanel11Layout = new javax.swing.GroupLayout(jPanel11);
        jPanel11.setLayout(jPanel11Layout);
        jPanel11Layout.setHorizontalGroup(
            jPanel11Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel11Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel11Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel11Layout.createSequentialGroup()
                        .addComponent(useSpecial3dModelCheckbox)
                        .addGap(18, 18, 18)
                        .addComponent(modelTypeCheckbox))
                    .addGroup(jPanel11Layout.createSequentialGroup()
                        .addGroup(jPanel11Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jPanel13, javax.swing.GroupLayout.PREFERRED_SIZE, 352, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addGroup(jPanel11Layout.createSequentialGroup()
                                .addComponent(jLabel86)
                                .addGap(4, 4, 4)
                                .addComponent(meritoriousLoText, javax.swing.GroupLayout.PREFERRED_SIZE, 57, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGap(7, 7, 7)
                                .addComponent(jLabel87)
                                .addGap(8, 8, 8)
                                .addComponent(meritoriousHiText, javax.swing.GroupLayout.PREFERRED_SIZE, 57, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(randomizeMeritoriousCheckbox))
                            .addComponent(clearOfficerCheckbox)
                            .addGroup(jPanel11Layout.createSequentialGroup()
                                .addGroup(jPanel11Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(randomizeHiddenValuesCheckbox)
                                    .addComponent(randomize3dModelCheckbox))
                                .addGap(18, 18, 18)
                                .addGroup(jPanel11Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(modelGenderCheckbox)
                                    .addComponent(useSpecialSpeechCheckbox))))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jPanel12, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap(95, Short.MAX_VALUE))
        );
        jPanel11Layout.setVerticalGroup(
            jPanel11Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel11Layout.createSequentialGroup()
                .addGap(10, 10, 10)
                .addGroup(jPanel11Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel12, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(jPanel11Layout.createSequentialGroup()
                        .addComponent(jPanel13, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanel11Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addGroup(jPanel11Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                .addGroup(jPanel11Layout.createSequentialGroup()
                                    .addGap(3, 3, 3)
                                    .addComponent(jLabel86))
                                .addComponent(meritoriousLoText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGroup(jPanel11Layout.createSequentialGroup()
                                    .addGap(2, 2, 2)
                                    .addComponent(jLabel87))
                                .addComponent(meritoriousHiText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addComponent(randomizeMeritoriousCheckbox))
                        .addGap(6, 6, 6)
                        .addComponent(clearOfficerCheckbox)
                        .addGap(2, 2, 2)
                        .addGroup(jPanel11Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(randomizeHiddenValuesCheckbox)
                            .addComponent(useSpecialSpeechCheckbox))))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel11Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(modelGenderCheckbox)
                    .addComponent(randomize3dModelCheckbox))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel11Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(useSpecial3dModelCheckbox)
                    .addComponent(modelTypeCheckbox))
                .addGap(93, 93, 93))
        );

        jTabbedPane1.addTab("所屬與隱藏特性", jPanel11);

        jPanel16.setBorder(javax.swing.BorderFactory.createTitledBorder("血緣"));
        jPanel16.setLayout(new java.awt.GridBagLayout());

        bloodGroup.add(randomizeNoBloodRadio);
        randomizeNoBloodRadio.setSelected(true);
        randomizeNoBloodRadio.setText("不要隨機化");
        randomizeNoBloodRadio.setToolTipText("不要隨機化武將的血緣關係。");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel16.add(randomizeNoBloodRadio, gridBagConstraints);

        bloodGroup.add(clearBloodRadio);
        clearBloodRadio.setText("清空");
        clearBloodRadio.setToolTipText("刪除所有武將的血緣關係。");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel16.add(clearBloodRadio, gridBagConstraints);

        bloodGroup.add(randomizeBloodRadio);
        randomizeBloodRadio.setText("隨機化");
        randomizeBloodRadio.setToolTipText("隨機化武將的血緣關係。");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel16.add(randomizeBloodRadio, gridBagConstraints);

        jLabel56.setText("子女相性修正機率");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel16.add(jLabel56, gridBagConstraints);

        jLabel58.setText("不同軍團配偶參數");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel16.add(jLabel58, gridBagConstraints);

        jLabel60.setText("沒仕官配偶參數");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel16.add(jLabel60, gridBagConstraints);

        jLabel62.setText("配偶相性修正機率");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel16.add(jLabel62, gridBagConstraints);

        spouseAttachmentProbSlider.setMajorTickSpacing(10);
        spouseAttachmentProbSlider.setMinorTickSpacing(1);
        spouseAttachmentProbSlider.setToolTipText("把配偶的相性重設的機率。");
        spouseAttachmentProbSlider.setValue(90);
        spouseAttachmentProbSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                spouseAttachmentProbSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel16.add(spouseAttachmentProbSlider, gridBagConstraints);

        spouseAttachmentProbLabel.setText("90%");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel16.add(spouseAttachmentProbLabel, gridBagConstraints);

        jLabel55.setText("子女相性最大相差");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel16.add(jLabel55, gridBagConstraints);

        childAttachmentText.setText("5");
        childAttachmentText.setToolTipText("重設相性時，父母子女間最大的相性相差");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel16.add(childAttachmentText, gridBagConstraints);

        jLabel64.setText("相同軍團子女參數");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel16.add(jLabel64, gridBagConstraints);

        jLabel65.setText("不同軍團子女參數");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel16.add(jLabel65, gridBagConstraints);

        jLabel66.setText("沒仕官子女參數");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel16.add(jLabel66, gridBagConstraints);

        jLabel67.setText("相同軍團配偶參數");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel16.add(jLabel67, gridBagConstraints);

        childAttachmentProbSlider.setMajorTickSpacing(10);
        childAttachmentProbSlider.setMinorTickSpacing(1);
        childAttachmentProbSlider.setToolTipText("把父母子女的相性重設的機率。");
        childAttachmentProbSlider.setValue(90);
        childAttachmentProbSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                childAttachmentProbSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel16.add(childAttachmentProbSlider, gridBagConstraints);

        childAttachmentProbLabel.setText("90%");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel16.add(childAttachmentProbLabel, gridBagConstraints);

        jLabel72.setText("多名子女下降參數");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel16.add(jLabel72, gridBagConstraints);

        jLabel73.setText("配偶相性最大相差");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel16.add(jLabel73, gridBagConstraints);

        spouseAttachmentText.setText("5");
        spouseAttachmentText.setToolTipText("重設相性時，配偶間最大的相性相差");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel16.add(spouseAttachmentText, gridBagConstraints);

        childMultipleDegradeText.setText("4");
        childMultipleDegradeText.setToolTipText("當武將有多名子女時，再得到子女的機率下降的速度。");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel16.add(childMultipleDegradeText, gridBagConstraints);

        jLabel59.setText("           ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanel16.add(jLabel59, gridBagConstraints);

        spouseNoFactionText.setText("3");
        spouseNoFactionText.setToolTipText("<html>在未仕官的武將裡，把兩個武將相互設成配偶的參數。參數愈高機率愈大。<br>\n配偶條件：不同性別、不同血緣、未有其他配偶、年齡相差少於40。");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel16.add(spouseNoFactionText, gridBagConstraints);

        spouseSameFactionText.setText("30");
        spouseSameFactionText.setToolTipText("<html>在同一個軍團裡，把兩個武將相互設成配偶的參數。參數愈高機率愈大。<br>\n配偶條件：不同性別、不同血緣、未有其他配偶、年齡相差少於40。");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel16.add(spouseSameFactionText, gridBagConstraints);

        spouseDiffFactionText.setText("0");
        spouseDiffFactionText.setToolTipText("<html>在不同的軍團（不同的勢力）裡，把兩個武將相互設成配偶的參數。參數愈高機率愈大。<br>\n配偶條件：不同性別、不同血緣、未有其他配偶、年齡相差少於40。");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel16.add(spouseDiffFactionText, gridBagConstraints);

        childSameFactionText.setText("200");
        childSameFactionText.setToolTipText("<html>在同一個軍團裡，把兩個武將相互設成父母子女的參數。參數愈高機率愈大。<br>\n父母均必須較子女年長15至60歲。");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel16.add(childSameFactionText, gridBagConstraints);

        childDiffFactionText.setText("0");
        childDiffFactionText.setToolTipText("<html>在不同的軍團（不同的勢力）裡，把兩個武將相互設成父母子女的參數。參數愈高機率愈大。<br>\n父母均必須較子女年長15至60歲。");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel16.add(childDiffFactionText, gridBagConstraints);

        childNoFactionText.setText("30");
        childNoFactionText.setToolTipText("<html>在未仕官的武將裡，把兩個武將相互設成父母子女的參數。參數愈高機率愈大。<br>\n父母均必須較子女年長15至60歲。");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel16.add(childNoFactionText, gridBagConstraints);

        jPanel17.setBorder(javax.swing.BorderFactory.createTitledBorder("義兄弟"));
        jPanel17.setLayout(new java.awt.GridBagLayout());

        brotherGroup.add(randomizeNoBrotherRadio);
        randomizeNoBrotherRadio.setSelected(true);
        randomizeNoBrotherRadio.setText("不要隨機化");
        randomizeNoBrotherRadio.setToolTipText("不要隨機化武將的義兄弟關係。");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel17.add(randomizeNoBrotherRadio, gridBagConstraints);

        brotherGroup.add(clearBrotherRadio);
        clearBrotherRadio.setText("清空");
        clearBrotherRadio.setToolTipText("刪除所有武將的義兄弟關係。");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel17.add(clearBrotherRadio, gridBagConstraints);

        brotherGroup.add(randomizeBrotherRadio);
        randomizeBrotherRadio.setText("隨機化");
        randomizeBrotherRadio.setToolTipText("隨機化武將的義兄弟關係。");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel17.add(randomizeBrotherRadio, gridBagConstraints);

        jLabel61.setText("不同軍團義兄參數");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel17.add(jLabel61, gridBagConstraints);

        jLabel63.setText("沒仕官義兄參數");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel17.add(jLabel63, gridBagConstraints);

        jLabel68.setText("義兄相性修正機率");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel17.add(jLabel68, gridBagConstraints);

        brotherAttachmentProbSlider.setMajorTickSpacing(10);
        brotherAttachmentProbSlider.setMinorTickSpacing(1);
        brotherAttachmentProbSlider.setToolTipText("把義兄弟的相性重設的機率。");
        brotherAttachmentProbSlider.setValue(90);
        brotherAttachmentProbSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                brotherAttachmentProbSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel17.add(brotherAttachmentProbSlider, gridBagConstraints);

        brotherAttachmentProbLabel.setText("90%");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel17.add(brotherAttachmentProbLabel, gridBagConstraints);

        jLabel75.setText("相同軍團義兄參數");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel17.add(jLabel75, gridBagConstraints);

        jLabel77.setText("義兄相性最大相差");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel17.add(jLabel77, gridBagConstraints);

        brotherAttachmentText.setText("5");
        brotherAttachmentText.setToolTipText("重設相性時，義兄弟間最大的相性相差");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel17.add(brotherAttachmentText, gridBagConstraints);

        jLabel78.setText("           ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanel17.add(jLabel78, gridBagConstraints);

        brotherSameFactionText.setText("5");
        brotherSameFactionText.setToolTipText("<html>在同一個軍團裡，把兩個武將相互設成義兄弟的參數。參數愈高機率愈大。<br>\n義兄弟條件：相同性別、不同血緣、未有其他義兄、年齡相差少於40。");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel17.add(brotherSameFactionText, gridBagConstraints);

        brotherDiffFactionText.setText("0");
        brotherDiffFactionText.setToolTipText("<html>在不同的軍團（不同的勢力）裡，把兩個武將相互設成義兄弟的參數。參數愈高機率愈大。<br>\n義兄弟條件：相同性別、不同血緣、未有其他義兄、年齡相差少於40。");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel17.add(brotherDiffFactionText, gridBagConstraints);

        brotherNoFactionText.setText("5");
        brotherNoFactionText.setToolTipText("<html>在未仕官的武將裡，把兩個武將相互設成義兄弟的參數。參數愈高機率愈大。<br>\n義兄弟條件：相同性別、不同血緣、未有其他義兄、年齡相差少於40。");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel17.add(brotherNoFactionText, gridBagConstraints);

        javax.swing.GroupLayout jPanel14Layout = new javax.swing.GroupLayout(jPanel14);
        jPanel14.setLayout(jPanel14Layout);
        jPanel14Layout.setHorizontalGroup(
            jPanel14Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel14Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel16, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(jPanel17, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
        jPanel14Layout.setVerticalGroup(
            jPanel14Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel14Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel14Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel17, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jPanel16, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(71, Short.MAX_VALUE))
        );

        jTabbedPane1.addTab("人物關係", jPanel14);

        jPanel19.setBorder(javax.swing.BorderFactory.createTitledBorder("血緣親愛武將"));
        jPanel19.setLayout(new java.awt.GridLayout(5, 3, 8, 8));

        bloodImitateGroup.add(randomizeNoBloodImitateRadio);
        randomizeNoBloodImitateRadio.setSelected(true);
        randomizeNoBloodImitateRadio.setText("不要隨機化");
        randomizeNoBloodImitateRadio.setToolTipText("不要因血緣關係新增親愛武將關係。");
        jPanel19.add(randomizeNoBloodImitateRadio);

        bloodImitateGroup.add(randomizeBloodImitateRadio);
        randomizeBloodImitateRadio.setText("隨機化");
        randomizeBloodImitateRadio.setToolTipText("以血緣關係增加親愛武將關係。");
        jPanel19.add(randomizeBloodImitateRadio);
        jPanel19.add(jLabel85);

        jLabel57.setText("子親愛父機率");
        jPanel19.add(jLabel57);

        childImitateParentSlider.setMajorTickSpacing(10);
        childImitateParentSlider.setMinorTickSpacing(1);
        childImitateParentSlider.setToolTipText("設定父母為子女的親愛武將的機率。");
        childImitateParentSlider.setValue(90);
        childImitateParentSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                childImitateParentSliderStateChanged(evt);
            }
        });
        jPanel19.add(childImitateParentSlider);

        childImitateParentLabel.setText("90%");
        jPanel19.add(childImitateParentLabel);

        jLabel69.setText("父親愛子機率");
        jPanel19.add(jLabel69);

        parentImitateChildSlider.setMajorTickSpacing(10);
        parentImitateChildSlider.setMinorTickSpacing(1);
        parentImitateChildSlider.setToolTipText("設定子女為父母的親愛武將的機率。");
        parentImitateChildSlider.setValue(90);
        parentImitateChildSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                parentImitateChildSliderStateChanged(evt);
            }
        });
        jPanel19.add(parentImitateChildSlider);

        parentImitateChildLabel.setText("90%");
        jPanel19.add(parentImitateChildLabel);

        jLabel70.setText("兄弟親愛機率");
        jPanel19.add(jLabel70);

        brotherImitateSlider.setMajorTickSpacing(10);
        brotherImitateSlider.setMinorTickSpacing(1);
        brotherImitateSlider.setToolTipText("設定兄弟姊妹間成為親愛武將的機率。");
        brotherImitateSlider.setValue(70);
        brotherImitateSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                brotherImitateSliderStateChanged(evt);
            }
        });
        jPanel19.add(brotherImitateSlider);

        brotherImitateLabel.setText("70%");
        jPanel19.add(brotherImitateLabel);

        jLabel71.setText("兄弟互相親愛機率");
        jPanel19.add(jLabel71);

        brotherImitate2Slider.setMajorTickSpacing(10);
        brotherImitate2Slider.setMinorTickSpacing(1);
        brotherImitate2Slider.setToolTipText("當兄弟姊妹間出現親愛武將關係時，另一方也親愛一方的機率。");
        brotherImitate2Slider.setValue(90);
        brotherImitate2Slider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                brotherImitate2SliderStateChanged(evt);
            }
        });
        jPanel19.add(brotherImitate2Slider);

        brotherImitate2Label.setText("90%");
        jPanel19.add(brotherImitate2Label);

        jPanel20.setBorder(javax.swing.BorderFactory.createTitledBorder("親愛武將"));
        jPanel20.setPreferredSize(new java.awt.Dimension(300, 172));
        jPanel20.setLayout(new java.awt.GridLayout(4, 3, 8, 8));

        imitateGroup.add(randomizeNoImitateRadio);
        randomizeNoImitateRadio.setSelected(true);
        randomizeNoImitateRadio.setText("不要隨機化");
        randomizeNoImitateRadio.setToolTipText("不要調整親愛武將的設定。");
        jPanel20.add(randomizeNoImitateRadio);

        imitateGroup.add(clearImitateRadio);
        clearImitateRadio.setText("清空");
        clearImitateRadio.setToolTipText("清空所有親愛武將的設定。");
        jPanel20.add(clearImitateRadio);

        imitateGroup.add(randomizeImitateRadio);
        randomizeImitateRadio.setText("隨機化");
        randomizeImitateRadio.setToolTipText("隨機化所有親愛武將的設定。");
        jPanel20.add(randomizeImitateRadio);

        jLabel74.setText("親愛武將機率");
        jPanel20.add(jLabel74);

        imitateSlider.setMajorTickSpacing(10);
        imitateSlider.setMinorTickSpacing(1);
        imitateSlider.setToolTipText("一個武將親愛另一個武將的機率");
        imitateSlider.setValue(60);
        imitateSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                imitateSliderStateChanged(evt);
            }
        });
        jPanel20.add(imitateSlider);

        imitateLabel.setText("60%");
        jPanel20.add(imitateLabel);

        jLabel79.setText("互相親愛機率");
        jPanel20.add(jLabel79);

        imitate2Slider.setMajorTickSpacing(10);
        imitate2Slider.setMinorTickSpacing(1);
        imitate2Slider.setToolTipText("一個武將親愛另一人時，另一人也親愛該武將的機率");
        imitate2Slider.setValue(90);
        imitate2Slider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                imitate2SliderStateChanged(evt);
            }
        });
        jPanel20.add(imitate2Slider);

        imitate2Label.setText("90%");
        jPanel20.add(imitate2Label);

        jLabel81.setText("多名親愛下降參數");
        jPanel20.add(jLabel81);

        imitateDegradeText.setText("0.3");
        imitateDegradeText.setToolTipText("當武將有多名親愛武將時，再新增親愛武將的機會下降速度");
        jPanel20.add(imitateDegradeText);
        jPanel20.add(jLabel83);

        jPanel21.setBorder(javax.swing.BorderFactory.createTitledBorder("厭惡武將"));
        jPanel21.setPreferredSize(new java.awt.Dimension(300, 172));
        jPanel21.setLayout(new java.awt.GridLayout(4, 3, 8, 8));

        hateGroup.add(randomizeNoHateRadio);
        randomizeNoHateRadio.setSelected(true);
        randomizeNoHateRadio.setText("不要隨機化");
        randomizeNoHateRadio.setToolTipText("不要調整厭惡武將的設定。");
        jPanel21.add(randomizeNoHateRadio);

        hateGroup.add(clearHateRadio);
        clearHateRadio.setText("清空");
        clearHateRadio.setToolTipText("清空所有厭惡武將的設定。");
        jPanel21.add(clearHateRadio);

        hateGroup.add(randomizeHateRadio);
        randomizeHateRadio.setText("隨機化");
        randomizeHateRadio.setToolTipText("隨機化所有，厭惡武將的設定。");
        jPanel21.add(randomizeHateRadio);

        jLabel76.setText("厭惡武將機率");
        jPanel21.add(jLabel76);

        hateSlider.setMajorTickSpacing(10);
        hateSlider.setMinorTickSpacing(1);
        hateSlider.setToolTipText("一個武將厭惡另一個武將的機率");
        hateSlider.setValue(60);
        hateSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                hateSliderStateChanged(evt);
            }
        });
        jPanel21.add(hateSlider);

        hateLabel.setText("60%");
        jPanel21.add(hateLabel);

        jLabel80.setText("互相厭惡機率");
        jPanel21.add(jLabel80);

        hate2Slider.setMajorTickSpacing(10);
        hate2Slider.setMinorTickSpacing(1);
        hate2Slider.setToolTipText("一個武將親愛另一人時，另一人也厭惡該武將的機率");
        hate2Slider.setValue(90);
        hate2Slider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                hate2SliderStateChanged(evt);
            }
        });
        jPanel21.add(hate2Slider);

        hate2Label.setText("90%");
        jPanel21.add(hate2Label);

        jLabel82.setText("多名厭惡下降參數");
        jPanel21.add(jLabel82);

        hateDegradeText.setText("0.3");
        hateDegradeText.setToolTipText("當武將有多名親愛武將時，再新增厭惡武將的機會下降速度");
        jPanel21.add(hateDegradeText);
        jPanel21.add(jLabel84);

        javax.swing.GroupLayout jPanel18Layout = new javax.swing.GroupLayout(jPanel18);
        jPanel18.setLayout(jPanel18Layout);
        jPanel18Layout.setHorizontalGroup(
            jPanel18Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel18Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel19, javax.swing.GroupLayout.PREFERRED_SIZE, 350, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel18Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jPanel20, javax.swing.GroupLayout.DEFAULT_SIZE, 339, Short.MAX_VALUE)
                    .addComponent(jPanel21, javax.swing.GroupLayout.DEFAULT_SIZE, 339, Short.MAX_VALUE))
                .addContainerGap())
        );
        jPanel18Layout.setVerticalGroup(
            jPanel18Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel18Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel18Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel18Layout.createSequentialGroup()
                        .addComponent(jPanel20, javax.swing.GroupLayout.PREFERRED_SIZE, 130, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jPanel21, javax.swing.GroupLayout.PREFERRED_SIZE, 132, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addComponent(jPanel19, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(136, Short.MAX_VALUE))
        );

        jTabbedPane1.addTab("親愛及厭惡武將", jPanel18);

        clearAdvisorCheckbox.setText("清除所有軍師");
        clearAdvisorCheckbox.setToolTipText("<html>把所有勢力的軍師清空。<br>\n假若要改變武將的所屬，建議點上這選項，否則可能會出現軍師不是勢力的下屬的情況。");

        clearCountryNameCheckbox.setText("清除所有國號");
        clearCountryNameCheckbox.setToolTipText("把所有勢力的國號清空");

        jPanel22.setBorder(javax.swing.BorderFactory.createTitledBorder("勢力技術"));

        factionTechniqueButtonGroup.add(noChangeTechniqueRadio);
        noChangeTechniqueRadio.setSelected(true);
        noChangeTechniqueRadio.setText("不要隨機化");
        noChangeTechniqueRadio.setToolTipText("不要調整勢力技術");

        factionTechniqueButtonGroup.add(clearTechniqueRadio);
        clearTechniqueRadio.setText("清空");
        clearTechniqueRadio.setToolTipText("清空所有勢力技術");

        factionTechniqueButtonGroup.add(randomizeTechniqueRadio);
        randomizeTechniqueRadio.setText("隨機化");
        randomizeTechniqueRadio.setToolTipText("把所有勢力的技術隨機化");

        jLabel90.setText("取得技術機率");

        techniqueProbLoText.setText("0");
        techniqueProbLoText.setToolTipText("取得一個技術的機率。較高級的技術必須有較低級的技術支持。");

        jLabel91.setText("至");

        techniqueProbHiText.setText("20");
        techniqueProbHiText.setToolTipText("取得一個技術的機率。較高級的技術必須有較低級的技術支持。");

        sameProbForFactionCheckbox.setText("一個勢力使用一個隨機數");
        sameProbForFactionCheckbox.setToolTipText("<html>生成勢力技術時，使一個勢力的九種技術均使用同一個數字，<br>令一些勢力擁有更多技術時，相應地擁有更多不同種類的技術");

        javax.swing.GroupLayout jPanel22Layout = new javax.swing.GroupLayout(jPanel22);
        jPanel22.setLayout(jPanel22Layout);
        jPanel22Layout.setHorizontalGroup(
            jPanel22Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel22Layout.createSequentialGroup()
                .addGroup(jPanel22Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel22Layout.createSequentialGroup()
                        .addGroup(jPanel22Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addGroup(jPanel22Layout.createSequentialGroup()
                                .addComponent(noChangeTechniqueRadio)
                                .addGap(18, 18, 18)
                                .addComponent(clearTechniqueRadio))
                            .addGroup(jPanel22Layout.createSequentialGroup()
                                .addComponent(jLabel90)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(techniqueProbLoText)))
                        .addGap(5, 5, 5)
                        .addComponent(jLabel91)
                        .addGroup(jPanel22Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(jPanel22Layout.createSequentialGroup()
                                .addGap(1, 1, 1)
                                .addComponent(randomizeTechniqueRadio))
                            .addGroup(jPanel22Layout.createSequentialGroup()
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(techniqueProbHiText, javax.swing.GroupLayout.PREFERRED_SIZE, 86, javax.swing.GroupLayout.PREFERRED_SIZE))))
                    .addComponent(sameProbForFactionCheckbox))
                .addContainerGap())
        );
        jPanel22Layout.setVerticalGroup(
            jPanel22Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel22Layout.createSequentialGroup()
                .addGroup(jPanel22Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(noChangeTechniqueRadio)
                    .addComponent(clearTechniqueRadio)
                    .addComponent(randomizeTechniqueRadio))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel22Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel90)
                    .addComponent(techniqueProbLoText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel91)
                    .addComponent(techniqueProbHiText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(sameProbForFactionCheckbox))
        );

        jPanel26.setBorder(javax.swing.BorderFactory.createTitledBorder("外交"));

        randomizeDiplomacyCheckbox.setText("隨機化");
        randomizeDiplomacyCheckbox.setToolTipText("隨機化勢力的外交關係及同盟關係");

        jLabel142.setText("勢力關係");

        diplomacyLoText.setText("0");
        diplomacyLoText.setToolTipText("隨機化勢力間的關係數值下限");

        jLabel143.setText("至");

        diplomacyHiText.setText("100");
        diplomacyHiText.setToolTipText("隨機化勢力間的關係數值上限");

        jLabel144.setText("關係高於");

        allianceCapText.setText("70");
        allianceCapText.setToolTipText("當兩個勢力間的關係高於這數時，有一定機率達成同盟。");

        jLabel145.setText("時同盟機率：");

        allianceProbSlider.setMajorTickSpacing(10);
        allianceProbSlider.setMinorTickSpacing(1);
        allianceProbSlider.setToolTipText("當兩個勢力間的關係高於一定數時，達成同盟的機率。");
        allianceProbSlider.setValue(70);
        allianceProbSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                allianceProbSliderStateChanged(evt);
            }
        });

        allianceProbLabel.setText("70%");

        diplomacyGaussianCheckbox.setText("勢力關係集中在中間值");
        diplomacyGaussianCheckbox.setToolTipText("隨機化勢力關係時，有較大機率勢力關係在上下限的中間值。");

        javax.swing.GroupLayout jPanel26Layout = new javax.swing.GroupLayout(jPanel26);
        jPanel26.setLayout(jPanel26Layout);
        jPanel26Layout.setHorizontalGroup(
            jPanel26Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel26Layout.createSequentialGroup()
                .addGroup(jPanel26Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel26Layout.createSequentialGroup()
                        .addComponent(randomizeDiplomacyCheckbox)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(diplomacyGaussianCheckbox))
                    .addGroup(jPanel26Layout.createSequentialGroup()
                        .addContainerGap()
                        .addGroup(jPanel26Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                            .addGroup(javax.swing.GroupLayout.Alignment.LEADING, jPanel26Layout.createSequentialGroup()
                                .addComponent(jLabel144)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(allianceCapText))
                            .addGroup(javax.swing.GroupLayout.Alignment.LEADING, jPanel26Layout.createSequentialGroup()
                                .addComponent(jLabel142)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(diplomacyLoText, javax.swing.GroupLayout.PREFERRED_SIZE, 90, javax.swing.GroupLayout.PREFERRED_SIZE)))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanel26Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(jPanel26Layout.createSequentialGroup()
                                .addComponent(jLabel143)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(diplomacyHiText, javax.swing.GroupLayout.PREFERRED_SIZE, 92, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addComponent(jLabel145)))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel26Layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(allianceProbSlider, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(allianceProbLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 27, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap())
        );
        jPanel26Layout.setVerticalGroup(
            jPanel26Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel26Layout.createSequentialGroup()
                .addGroup(jPanel26Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(randomizeDiplomacyCheckbox)
                    .addComponent(diplomacyGaussianCheckbox))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel26Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel26Layout.createSequentialGroup()
                        .addGroup(jPanel26Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabel142)
                            .addComponent(diplomacyLoText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanel26Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabel144)
                            .addComponent(allianceCapText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                    .addGroup(jPanel26Layout.createSequentialGroup()
                        .addGroup(jPanel26Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(diplomacyHiText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jLabel143))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabel145)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel26Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(allianceProbSlider, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(allianceProbLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 23, javax.swing.GroupLayout.PREFERRED_SIZE)))
        );

        jPanel27.setBorder(javax.swing.BorderFactory.createTitledBorder("強化軍團"));

        jLabel146.setText("強化軍團數目");

        jLabel147.setText("至");

        strongFactionMinOfficerText.setText("10");
        strongFactionMinOfficerText.setToolTipText("生成強力勢力時，那些勢力的武將數目必須最少有這個數目");

        strongFactionHiText.setText("4");
        strongFactionHiText.setToolTipText("生成強力勢力的數目上限");

        jLabel148.setText("強化軍團最小武將數");

        strongFactionLoText.setText("2");
        strongFactionLoText.setToolTipText("生成強力勢力的數目下限");

        jLabel149.setText("強化軍團中強化武將機率");

        strongFactionOfficerProbLabel.setText("50%");
        strongFactionOfficerProbLabel.setToolTipText("在強力勢力中，把其武將以下列方式強化的機率。");

        strongFactionOfficerProbSlider.setMajorTickSpacing(10);
        strongFactionOfficerProbSlider.setMinorTickSpacing(1);
        strongFactionOfficerProbSlider.setToolTipText("在強力勢力中，把其武將以下列方式強化的機率。");
        strongFactionOfficerProbSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                strongFactionOfficerProbSliderStateChanged(evt);
            }
        });

        jLabel150.setText("強化武將能力 x ");

        strongFactionAbyMulText.setText("1");
        strongFactionAbyMulText.setToolTipText("強化武將時把其能力乘上這數字");

        jLabel151.setText("+");

        strongFactionAbyAbsText.setText("0");
        strongFactionAbyAbsText.setToolTipText("強化武將時把其能力加上這數字");

        jLabel152.setText("強化武將適性 x ");

        strongFactionAdpMulText.setText("1");
        strongFactionAdpMulText.setToolTipText("強化武將時把其適性值乘上這數字");

        jLabel153.setText("+");

        strongFactionAdpAbsText.setText("0");
        strongFactionAdpAbsText.setToolTipText("強化武將時把其適性值加上這數字");

        strongFactionSpecialCheckbox.setText("以全能型重抽強化武將特技");
        strongFactionSpecialCheckbox.setToolTipText("把強化武將的特技，以全能型武將來重抽特技，有較高機率取得強力特技");

        strongFactionRelationCheckbox.setText("設定強化武將的親密關係");
        strongFactionRelationCheckbox.setToolTipText("使強化武將與其他武將建立配偶或義兄弟關係，使其難以離開其本身的勢力");

        jLabel154.setText("強化軍團士兵數 x ");

        strongFactionTroopLoText.setText("1.5");
        strongFactionTroopLoText.setToolTipText("強化勢力下的所有城池的士兵數及最大士兵數乘上這數值下限");

        jLabel155.setText("至");

        strongFactionTroopHiText.setText("2");
        strongFactionTroopHiText.setToolTipText("強化勢力下的所有城池的士兵數及最大士兵數乘上這數值上限");

        jLabel156.setText("強化軍團資金 x ");

        strongFactionCashLoText.setText("1.5");
        strongFactionCashLoText.setToolTipText("強化勢力下的所有城池的資金乘上這數值下限");

        jLabel157.setText("至");

        strongFactionCashHiText.setText("2");
        strongFactionCashHiText.setToolTipText("強化勢力下的所有城池的資金乘上這數值上限");

        jLabel158.setText("強化軍團兵糧 x ");

        jLabel159.setText("至");

        strongFactionCropHiText.setText("2");
        strongFactionCropHiText.setToolTipText("強化勢力下的所有城池的兵糧乘上這數值上限");

        strongFactionCropLoText.setText("1.5");
        strongFactionCropLoText.setToolTipText("強化勢力下的所有城池的兵糧乘上這數值下限");

        jLabel160.setText("強化軍團兵裝 x ");

        strongFactionWeaponLoText.setText("1.5");
        strongFactionWeaponLoText.setToolTipText("強化勢力下的所有城池的兵裝、兵器及船隻，乘上這數值下限");

        strongFactionWeaponHiText.setText("2");
        strongFactionWeaponHiText.setToolTipText("強化勢力下的所有城池的兵裝、兵器及船隻，乘上這數值上限");

        jLabel161.setText("至");

        strongFactionCashInLoText.setText("1.5");
        strongFactionCashInLoText.setToolTipText("強化勢力下的所有城池的資金收入乘上這數值下限");

        jLabel162.setText("強化軍團資金收入 x ");

        jLabel163.setText("至");

        strongFactionCashInHiText.setText("2");
        strongFactionCashInHiText.setToolTipText("強化勢力下的所有城池的資金收入乘上這數值上限");

        jLabel164.setText("強化軍團兵糧收入 x ");

        strongFactionCropInLoText.setText("1.5");
        strongFactionCropInLoText.setToolTipText("強化勢力下的所有城池的兵糧收入乘上這數值下限");

        jLabel165.setText("至");

        strongFactionCropInHiText.setText("2");
        strongFactionCropInHiText.setToolTipText("強化勢力下的所有城池的兵糧收入乘上這數值上限");

        strongFactionDurabilityLoText.setText("100");
        strongFactionDurabilityLoText.setToolTipText("強化勢力下的所有城池的耐久下限");

        strongFactionDurabilityHiText.setText("150");
        strongFactionDurabilityHiText.setToolTipText("強化勢力下的所有城池的耐久上限");

        jLabel166.setText("至");

        jLabel167.setText("強化軍團耐久 ");

        jLabel168.setText("x 100");

        javax.swing.GroupLayout jPanel27Layout = new javax.swing.GroupLayout(jPanel27);
        jPanel27.setLayout(jPanel27Layout);
        jPanel27Layout.setHorizontalGroup(
            jPanel27Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel27Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel27Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel27Layout.createSequentialGroup()
                        .addComponent(jLabel146)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(strongFactionLoText, javax.swing.GroupLayout.PREFERRED_SIZE, 87, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabel147)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(strongFactionHiText, javax.swing.GroupLayout.PREFERRED_SIZE, 92, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel27Layout.createSequentialGroup()
                        .addComponent(jLabel148)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(strongFactionMinOfficerText, javax.swing.GroupLayout.PREFERRED_SIZE, 89, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel27Layout.createSequentialGroup()
                        .addComponent(jLabel150)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(strongFactionAbyMulText, javax.swing.GroupLayout.PREFERRED_SIZE, 60, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(4, 4, 4)
                        .addComponent(jLabel151)
                        .addGap(4, 4, 4)
                        .addComponent(strongFactionAbyAbsText, javax.swing.GroupLayout.PREFERRED_SIZE, 60, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel27Layout.createSequentialGroup()
                        .addComponent(strongFactionSpecialCheckbox)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(strongFactionRelationCheckbox))
                    .addGroup(jPanel27Layout.createSequentialGroup()
                        .addGroup(jPanel27Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addGroup(jPanel27Layout.createSequentialGroup()
                                .addComponent(jLabel156)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(strongFactionCashLoText, javax.swing.GroupLayout.PREFERRED_SIZE, 87, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jLabel157)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(strongFactionCashHiText, javax.swing.GroupLayout.PREFERRED_SIZE, 92, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addGroup(jPanel27Layout.createSequentialGroup()
                                .addComponent(jLabel154)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(strongFactionTroopLoText, javax.swing.GroupLayout.PREFERRED_SIZE, 87, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jLabel155)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(strongFactionTroopHiText, javax.swing.GroupLayout.PREFERRED_SIZE, 92, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addGroup(jPanel27Layout.createSequentialGroup()
                                .addComponent(jLabel158)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(strongFactionCropLoText, javax.swing.GroupLayout.PREFERRED_SIZE, 87, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jLabel159)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(strongFactionCropHiText, javax.swing.GroupLayout.PREFERRED_SIZE, 92, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addGroup(jPanel27Layout.createSequentialGroup()
                                .addComponent(jLabel160)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(strongFactionWeaponLoText, javax.swing.GroupLayout.PREFERRED_SIZE, 87, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jLabel161)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(strongFactionWeaponHiText, javax.swing.GroupLayout.PREFERRED_SIZE, 92, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addGroup(jPanel27Layout.createSequentialGroup()
                                .addComponent(jLabel162)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(strongFactionCashInLoText, javax.swing.GroupLayout.PREFERRED_SIZE, 87, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jLabel163)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(strongFactionCashInHiText, javax.swing.GroupLayout.PREFERRED_SIZE, 92, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addGroup(jPanel27Layout.createSequentialGroup()
                                .addComponent(jLabel164)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(strongFactionCropInLoText, javax.swing.GroupLayout.PREFERRED_SIZE, 87, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jLabel165)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(strongFactionCropInHiText, javax.swing.GroupLayout.PREFERRED_SIZE, 92, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addGroup(jPanel27Layout.createSequentialGroup()
                                .addComponent(jLabel167)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(strongFactionDurabilityLoText, javax.swing.GroupLayout.PREFERRED_SIZE, 87, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jLabel166)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(strongFactionDurabilityHiText, javax.swing.GroupLayout.PREFERRED_SIZE, 92, javax.swing.GroupLayout.PREFERRED_SIZE)))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabel168))
                    .addGroup(jPanel27Layout.createSequentialGroup()
                        .addComponent(jLabel152)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(strongFactionAdpMulText, javax.swing.GroupLayout.PREFERRED_SIZE, 60, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(4, 4, 4)
                        .addComponent(jLabel153)
                        .addGap(4, 4, 4)
                        .addComponent(strongFactionAdpAbsText, javax.swing.GroupLayout.PREFERRED_SIZE, 60, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel27Layout.createSequentialGroup()
                        .addComponent(jLabel149)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(strongFactionOfficerProbSlider, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(4, 4, 4)
                        .addComponent(strongFactionOfficerProbLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 27, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap(19, Short.MAX_VALUE))
        );
        jPanel27Layout.setVerticalGroup(
            jPanel27Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel27Layout.createSequentialGroup()
                .addGroup(jPanel27Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel146)
                    .addComponent(strongFactionLoText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel147)
                    .addComponent(strongFactionHiText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(10, 10, 10)
                .addGroup(jPanel27Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel148)
                    .addComponent(strongFactionMinOfficerText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel27Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(strongFactionOfficerProbLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 23, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(jPanel27Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                        .addComponent(strongFactionOfficerProbSlider, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jLabel149)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel27Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel27Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(strongFactionAbyMulText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jLabel150))
                    .addGroup(jPanel27Layout.createSequentialGroup()
                        .addGap(3, 3, 3)
                        .addComponent(jLabel151))
                    .addComponent(strongFactionAbyAbsText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel27Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel27Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(strongFactionAdpMulText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jLabel152))
                    .addGroup(jPanel27Layout.createSequentialGroup()
                        .addGap(3, 3, 3)
                        .addComponent(jLabel153))
                    .addComponent(strongFactionAdpAbsText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel27Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(strongFactionSpecialCheckbox)
                    .addComponent(strongFactionRelationCheckbox))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel27Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel154)
                    .addComponent(strongFactionTroopLoText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel155)
                    .addComponent(strongFactionTroopHiText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel27Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel156)
                    .addComponent(strongFactionCashLoText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel157)
                    .addComponent(strongFactionCashHiText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel27Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel158)
                    .addComponent(strongFactionCropLoText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel159)
                    .addComponent(strongFactionCropHiText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel27Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel160)
                    .addComponent(strongFactionWeaponLoText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel161)
                    .addComponent(strongFactionWeaponHiText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel27Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel162)
                    .addComponent(strongFactionCashInLoText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel163)
                    .addComponent(strongFactionCashInHiText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel27Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel164)
                    .addComponent(strongFactionCropInLoText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel165)
                    .addComponent(strongFactionCropInHiText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel27Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel167)
                    .addComponent(strongFactionDurabilityLoText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel166)
                    .addComponent(strongFactionDurabilityHiText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel168))
                .addContainerGap(11, Short.MAX_VALUE))
        );

        randomizeFactionColourCheckbox.setText("隨機化勢力色");

        javax.swing.GroupLayout jPanel25Layout = new javax.swing.GroupLayout(jPanel25);
        jPanel25.setLayout(jPanel25Layout);
        jPanel25Layout.setHorizontalGroup(
            jPanel25Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel25Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel25Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(randomizeFactionColourCheckbox)
                    .addGroup(jPanel25Layout.createSequentialGroup()
                        .addComponent(clearAdvisorCheckbox)
                        .addGap(18, 18, 18)
                        .addComponent(clearCountryNameCheckbox))
                    .addComponent(jPanel26, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanel22, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel27, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(14, 14, 14))
        );
        jPanel25Layout.setVerticalGroup(
            jPanel25Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel25Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel25Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel27, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(jPanel25Layout.createSequentialGroup()
                        .addGroup(jPanel25Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(clearAdvisorCheckbox)
                            .addComponent(clearCountryNameCheckbox))
                        .addGap(1, 1, 1)
                        .addComponent(randomizeFactionColourCheckbox)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jPanel22, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jPanel26, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap())
        );

        jTabbedPane1.addTab("勢力", jPanel25);

        swapCountryCheckbox.setText("國替");
        swapCountryCheckbox.setToolTipText("把所有勢力的領地重新分佈，可能會把多於一個城池的勢力分成多個部分。");

        clearGateCheckbox.setText("清空關港");
        clearGateCheckbox.setToolTipText("<html>把所有關港也設成沒所屬並清空所有資源。<br>\n如點上國替建議點上這項，否則會出現關港的所屬與附近的城池所屬不相同的情況。");

        jPanel23.setBorder(javax.swing.BorderFactory.createTitledBorder("據點資源設定"));
        jPanel23.setLayout(new java.awt.GridLayout(12, 5, 8, 8));

        jLabel95.setText("士兵數");
        jPanel23.add(jLabel95);

        troopLoText.setText("10");
        jPanel23.add(troopLoText);

        jLabel96.setText("至");
        jPanel23.add(jLabel96);

        troopHiText.setText("30");
        jPanel23.add(troopHiText);

        jLabel97.setText("x 1000");
        jPanel23.add(jLabel97);

        jLabel98.setText("資金");
        jPanel23.add(jLabel98);

        cashLoText.setText("4");
        jPanel23.add(cashLoText);

        jLabel99.setText("至");
        jPanel23.add(jLabel99);

        cashHiText.setText("8");
        jPanel23.add(cashHiText);

        jLabel100.setText("x 1000");
        jPanel23.add(jLabel100);

        jLabel101.setText("糧草");
        jPanel23.add(jLabel101);

        cropLoText.setText("4");
        jPanel23.add(cropLoText);

        jLabel102.setText("至");
        jPanel23.add(jLabel102);

        cropHiText.setText("8");
        jPanel23.add(cropHiText);

        jLabel103.setText("x 10000");
        jPanel23.add(jLabel103);

        jLabel104.setText("槍");
        jPanel23.add(jLabel104);

        spearLoText.setText("0");
        jPanel23.add(spearLoText);

        jLabel105.setText("至");
        jPanel23.add(jLabel105);

        spearHiText.setText("20");
        jPanel23.add(spearHiText);

        jLabel106.setText("x 1000");
        jPanel23.add(jLabel106);

        jLabel107.setText("戟");
        jPanel23.add(jLabel107);

        halberdLoText.setText("0");
        jPanel23.add(halberdLoText);

        jLabel108.setText("至");
        jPanel23.add(jLabel108);

        halberdHiText.setText("20");
        jPanel23.add(halberdHiText);

        jLabel109.setText("x 1000");
        jPanel23.add(jLabel109);

        jLabel110.setText("弩");
        jPanel23.add(jLabel110);

        bowLoText.setText("0");
        jPanel23.add(bowLoText);

        jLabel111.setText("至");
        jPanel23.add(jLabel111);

        bowHiText.setText("20");
        jPanel23.add(bowHiText);

        jLabel112.setText("x 1000");
        jPanel23.add(jLabel112);

        jLabel113.setText("軍馬");
        jPanel23.add(jLabel113);

        horseLoText.setText("0");
        jPanel23.add(horseLoText);

        jLabel114.setText("至");
        jPanel23.add(jLabel114);

        horseHiText.setText("20");
        jPanel23.add(horseHiText);

        jLabel115.setText("x 1000");
        jPanel23.add(jLabel115);

        jLabel116.setText("直接兵器");
        jPanel23.add(jLabel116);

        ramLoText.setText("0");
        jPanel23.add(ramLoText);

        jLabel117.setText("至");
        jPanel23.add(jLabel117);

        ramHiText.setText("3");
        jPanel23.add(ramHiText);
        jPanel23.add(jLabel128);

        jLabel118.setText("間接兵器");
        jPanel23.add(jLabel118);

        catapultLoText.setText("0");
        jPanel23.add(catapultLoText);

        jLabel119.setText("至");
        jPanel23.add(jLabel119);

        catapultHiText.setText("3");
        jPanel23.add(catapultHiText);
        jPanel23.add(jLabel129);

        jLabel120.setText("船");
        jPanel23.add(jLabel120);

        shipLoText.setText("0");
        jPanel23.add(shipLoText);

        jLabel121.setText("至");
        jPanel23.add(jLabel121);

        shipHiText.setText("6");
        jPanel23.add(shipHiText);
        jPanel23.add(jLabel130);

        jLabel131.setText("氣力");
        jPanel23.add(jLabel131);

        troopMorLoText.setText("80");
        jPanel23.add(troopMorLoText);

        jLabel132.setText("至");
        jPanel23.add(jLabel132);

        troopMorHiText.setText("100");
        jPanel23.add(troopMorHiText);
        jPanel23.add(jLabel133);

        jLabel134.setText("民心");
        jPanel23.add(jLabel134);

        moraleLoText.setText("80");
        jPanel23.add(moraleLoText);

        jLabel135.setText("至");
        jPanel23.add(jLabel135);

        moraleHiText.setText("100");
        jPanel23.add(moraleHiText);
        jPanel23.add(jLabel136);

        resetBaseResourceCheckbox.setText("重設據點資源");
        resetBaseResourceCheckbox.setToolTipText("<html>把所有據點的資源（包括錢糧、士兵、兵裝、士氣、氣力、治安）等全部重設。<br>\n如點上國替建議點上這項，否則會出現有所屬城池沒資源，沒所屬城池有資源的情況。");

        jPanel24.setBorder(javax.swing.BorderFactory.createTitledBorder("據點設定"));
        jPanel24.setLayout(new java.awt.GridBagLayout());

        jLabel92.setText("最大士兵數");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel24.add(jLabel92, gridBagConstraints);

        maxTroopLoText.setText("10");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel24.add(maxTroopLoText, gridBagConstraints);

        jLabel93.setText("至");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel24.add(jLabel93, gridBagConstraints);

        maxTroopHiText.setText("15");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel24.add(maxTroopHiText, gridBagConstraints);

        jLabel94.setText("x 10000");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel24.add(jLabel94, gridBagConstraints);

        jLabel122.setText("資金收入基數");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel24.add(jLabel122, gridBagConstraints);

        cashInLoText.setText("4");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel24.add(cashInLoText, gridBagConstraints);

        jLabel123.setText("至");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel24.add(jLabel123, gridBagConstraints);

        cashInHiText.setText("8");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel24.add(cashInHiText, gridBagConstraints);

        jLabel124.setText("x 100");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel24.add(jLabel124, gridBagConstraints);

        jLabel125.setText("糧草收入基數");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel24.add(jLabel125, gridBagConstraints);

        cropInLoText.setText("4");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel24.add(cropInLoText, gridBagConstraints);

        jLabel126.setText("至");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel24.add(jLabel126, gridBagConstraints);

        cropInHiText.setText("8");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel24.add(cropInHiText, gridBagConstraints);

        jLabel127.setText("x 1000");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel24.add(jLabel127, gridBagConstraints);

        jLabel137.setText("取得第一特色機率");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        jPanel24.add(jLabel137, gridBagConstraints);

        firstSpecialProbSlider.setMajorTickSpacing(10);
        firstSpecialProbSlider.setMinorTickSpacing(1);
        firstSpecialProbSlider.setToolTipText("城池取得第一個特色的機率。沒特色的城池為大都市。");
        firstSpecialProbSlider.setValue(83);
        firstSpecialProbSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                firstSpecialProbSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanel24.add(firstSpecialProbSlider, gridBagConstraints);

        firstSpecialProbLabel.setText("83%");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel24.add(firstSpecialProbLabel, gridBagConstraints);

        jLabel138.setText("取得更多特色機率");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        jPanel24.add(jLabel138, gridBagConstraints);

        moreSpecialProbSlider.setMajorTickSpacing(10);
        moreSpecialProbSlider.setMinorTickSpacing(1);
        moreSpecialProbSlider.setToolTipText("城池取得更多特色的機率。多個特色的城池表示那些城池在那些特色的資源上也有優惠。");
        moreSpecialProbSlider.setValue(0);
        moreSpecialProbSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                moreSpecialProbSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanel24.add(moreSpecialProbSlider, gridBagConstraints);

        moreSpecialProbLabel.setText("0%");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel24.add(moreSpecialProbLabel, gridBagConstraints);

        navalSpecialLimitCheckbox.setText("只容許常用水軍的城池可以有水軍特色");
        navalSpecialLimitCheckbox.setToolTipText("<html>只容許常用水軍的城池，即是有港口的城池但不包括襄平、晉陽、洛陽、長安<br>\n及會稽五城，可以有水軍特色");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanel24.add(navalSpecialLimitCheckbox, gridBagConstraints);

        horseSpecialLimitCheckbox.setText("只容許河北及西北城池可以有騎馬特色");
        horseSpecialLimitCheckbox.setToolTipText("<html>只容許河北及西北城池可以有騎馬特色。這些城池包括：襄平、北平、薊、<br>晉陽、南皮、平原、鄴、長安、安定、天水、武威。");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanel24.add(horseSpecialLimitCheckbox, gridBagConstraints);

        jLabel139.setText("大都市乘數");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel24.add(jLabel139, gridBagConstraints);

        bigCityCashText.setText("1");
        bigCityCashText.setToolTipText("對於所有大都市，把資金收入基數乘上的額外乘數");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel24.add(bigCityCashText, gridBagConstraints);

        jLabel140.setText("大都市乘數");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel24.add(jLabel140, gridBagConstraints);

        bigCityCropText.setText("1");
        bigCityCropText.setToolTipText("對於所有大都市，把糧草收入基數乘上的額外乘數");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel24.add(bigCityCropText, gridBagConstraints);

        jLabel141.setText("大都市乘數");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel24.add(jLabel141, gridBagConstraints);

        bigCityTroopText.setText("1.5");
        bigCityTroopText.setToolTipText("對於所有大都市，把最大士兵數乘上的額外乘數");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel24.add(bigCityTroopText, gridBagConstraints);

        resetBaseSettingCheckbox.setText("重設據點設定");
        resetBaseSettingCheckbox.setToolTipText("把所有據點的一些設定（包括最大士兵數、資金收入基數、兵糧收入基數）等全部重設。");

        javax.swing.GroupLayout jPanel6Layout = new javax.swing.GroupLayout(jPanel6);
        jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(
            jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel6Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel6Layout.createSequentialGroup()
                        .addComponent(jPanel23, javax.swing.GroupLayout.PREFERRED_SIZE, 361, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGroup(jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(jPanel6Layout.createSequentialGroup()
                                .addGap(2, 2, 2)
                                .addComponent(resetBaseSettingCheckbox))
                            .addGroup(jPanel6Layout.createSequentialGroup()
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jPanel24, javax.swing.GroupLayout.DEFAULT_SIZE, 328, Short.MAX_VALUE))))
                    .addGroup(jPanel6Layout.createSequentialGroup()
                        .addComponent(swapCountryCheckbox)
                        .addGap(18, 18, 18)
                        .addComponent(clearGateCheckbox)
                        .addGap(18, 18, 18)
                        .addComponent(resetBaseResourceCheckbox)))
                .addContainerGap())
        );
        jPanel6Layout.setVerticalGroup(
            jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel6Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(swapCountryCheckbox)
                        .addComponent(clearGateCheckbox)
                        .addComponent(resetBaseResourceCheckbox))
                    .addComponent(resetBaseSettingCheckbox))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel23, javax.swing.GroupLayout.DEFAULT_SIZE, 369, Short.MAX_VALUE)
                    .addComponent(jPanel24, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );

        jTabbedPane1.addTab("據點", jPanel6);

        exportSettingButton.setText("導出");
        exportSettingButton.setToolTipText("導出設定檔。");
        exportSettingButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                exportSettingButtonMouseClicked(evt);
            }
        });

        importSettingButton.setText("導入");
        importSettingButton.setToolTipText("導入設定檔。");
        importSettingButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                importSettingButtonMouseClicked(evt);
            }
        });

        combineSkillLangCombo.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "繁體版", "简体版" }));
        combineSkillLangCombo.setToolTipText("讀寫特技檔案（.skill）時，使用繁體中文還是簡體中文。");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jTabbedPane1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(openFileButton)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(filePathLabel, javax.swing.GroupLayout.DEFAULT_SIZE, 422, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(combineSkillLangCombo, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(importSettingButton)
                        .addGap(4, 4, 4)
                        .addComponent(exportSettingButton)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(openFileButton)
                    .addComponent(filePathLabel)
                    .addComponent(exportSettingButton)
                    .addComponent(importSettingButton)
                    .addComponent(combineSkillLangCombo, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jTabbedPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 440, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        setBounds((screenSize.width-756)/2, (screenSize.height-527)/2, 756, 527);
    }// </editor-fold>//GEN-END:initComponents

    private void setBloodForDescendent(Officer[] allOfficers, Officer parent, int officerCnt) {
        for (int i = 0; i < officerCnt; ++i) {
            if (allOfficers[i].getFather() == parent.getId() || allOfficers[i].getMother() == parent.getId()) {
                if (allOfficers[i].getFather() == parent.getId()) {
                    allOfficers[i].setBlood(parent.getBlood());
                    if (!noSurnameChangeCheckbox.isSelected()){ 
                        allOfficers[i].setSameSurname(parent);
                    }
                } else {
                    if (parent.getSpouse() != Officer.NO_SUCH_OFFICER) {
                        allOfficers[i].setBlood(allOfficers[parent.getSpouse()].getBlood());
                        if (!noSurnameChangeCheckbox.isSelected()){ 
                            allOfficers[i].setSameSurname(allOfficers[parent.getSpouse()]);
                        }
                    }
                }
                allOfficers[i].setTightBlood(parent.getTightBlood());
                allOfficers[i].setGeneration(parent.getGeneration() + 1);
                if (Math.random() < 0.9) {
                    allOfficers[i].randomPersonAttachmentWithinDiff(parent, 5, Integer.parseInt(attachmentHiText.getText()));
                }
                setBloodForDescendent(allOfficers, allOfficers[i], officerCnt);
            }
        }
    }
    private int maleFaceIndex = 0;
    private int femaleFaceIndex = 0;
    private int maleFaceAIndex = 0;
    private int maleFaceMIndex = 0;
    private int maleFaceUIndex = 0;
    private int femaleFaceAIndex = 0;
    private int femaleFaceMIndex = 0;

    private void setFace(Officer o, Database db) {
        if (o.getGender() == Officer.MALE) {
            List<Integer> list = db.getMaleface();
            o.setFace(list.get(maleFaceIndex % list.size()));
            maleFaceIndex++;
        } else {
            List<Integer> list = db.getFemaleface();
            o.setFace(list.get(femaleFaceIndex % list.size()));
            femaleFaceIndex++;
        }
    }

    private void setTypedFace(Officer o, Database db) {
        if (o.getGender() == Officer.MALE) {
            if (o.getLeadership() < 50 && o.getMight() < 50 && o.getIntelligence() < 50 && o.getPolitics() < 50 && o.getGlamour() < 50) {
                List<Integer> list = db.getMaleFaceU();
                o.setFace(list.get(maleFaceUIndex % list.size()));
                maleFaceUIndex++;
            } else if (o.getLeadership() + o.getMight() > o.getIntelligence() + o.getPolitics()) {
                List<Integer> list = db.getMaleFaceM();
                o.setFace(list.get(maleFaceMIndex % list.size()));
                maleFaceMIndex++;
            } else {
                List<Integer> list = db.getMaleFaceA();
                o.setFace(list.get(maleFaceAIndex % list.size()));
                maleFaceAIndex++;
            }
        } else {
            if (o.getLeadership() + o.getMight() > o.getIntelligence() + o.getPolitics()) {
                List<Integer> list = db.getFemaleFaceM();
                o.setFace(list.get(femaleFaceMIndex % list.size()));
                femaleFaceMIndex++;
            } else {
                List<Integer> list = db.getFemaleFaceA();
                o.setFace(list.get(femaleFaceAIndex % list.size()));
                femaleFaceAIndex++;
            }
        }
    }

    private void randomize(File f, String encoding) throws IOException {
        scenFile = new RandomAccessFile(f, "rwd");

        Database db = new Database(true, directNameRadio.isSelected(), encoding);

        //scen year found at both 0x5B and 0x3F38. Writer need to take care of this!
        scenFile.seek(0x5B);
        int scenYear = Utility.read2Bytes(scenFile);

        int officerCnt;
        if (officer670Radio.isSelected()) {
            officerCnt = 670;
        } else if (officer700Radio.isSelected()) {
            officerCnt = 700;
        } else if (officer800Radio.isSelected()) {
            officerCnt = 800;
        } else {
            officerCnt = Integer.parseInt(idHiText.getText());
        }
        int officerArraySize = officerCnt > 670 ? officerCnt : 670;

        Officer[] allOfficers = new Officer[officerArraySize];

        Officer.readBaseTeam(scenFile);
        if (swapCountryCheckbox.isSelected()) {
            Officer.randomBaseTeam();
        }

        boolean[] copy = new boolean[officerArraySize];
        
        if (generateCombineSkillCheckbox.isSelected()){
            Officer.generateSpecials(Integer.parseInt(combineSkillIdLoText.getText()), Integer.parseInt(combineSkillIdHiText.getText()), 
                    Integer.parseInt(combineSkillCntLoText.getText()), Integer.parseInt(combineSkillCntHiText.getText()), encoding);
        }

        Officer.setRandLocationProb(Integer.parseInt(goNoTeamWeightLoText.getText()), Integer.parseInt(goNoTeamWeightHiText.getText()),
                Integer.parseInt(goHaveTeamWeightLoText.getText()), Integer.parseInt(goHaveTeamWeightHiText.getText()));

        for (int i = 0; i < officerArraySize; i++) {
            Officer oldOfficer = Officer.readOfficer(db, scenFile, i);

            copy[i] = (randomizeDeadOnlyCheckbox.isSelected()
                    && (oldOfficer.getStatus() != Officer.STATUS_DEAD && oldOfficer.getStatus() != Officer.NO_STATUS));

            Officer o;
            if (randomTypeOfficerRadio.isSelected()) {
                o = new Officer(db, i);
            } else {
                o = new TypedOfficer(db, Utility.randomCategorize_i(
                        Integer.parseInt(generalTypeWeightText.getText()),
                        Integer.parseInt(mightyTypeWeightText.getText()),
                        Integer.parseInt(advisorTypeWeightText.getText()),
                        Integer.parseInt(politicianTypeWeightText.getText()),
                        Integer.parseInt(intelGeneralTypeWeightText.getText()),
                        Integer.parseInt(emperorTypeWeightText.getText()),
                        Integer.parseInt(allRounderTypeWeightText.getText()),
                        Integer.parseInt(normalTypeWeightText.getText()),
                        Integer.parseInt(cheapTypeWeightText.getText())), i);
            }

            o.sameLoyalty(oldOfficer);

            if (randomizeGenderCheckbox.isSelected() && !copy[i]) {
                o.setRandomGender(femaleOfficerProbSlider.getValue() / 100.0);
            } else {
                o.setSameGender(oldOfficer);
            }
            if (randomizeNameCheckbox.isSelected() && !copy[i]) {
                o.setRandomNames(doubleNameProbSlider.getValue() / 100.0, directNameRadio.isSelected());
            } else {
                o.setSameName(oldOfficer);
            }
            if (randomizeAbilityCheckbox.isSelected() && !copy[i]) {
                o.randomAbility(Double.parseDouble(abilityMulText.getText()), Double.parseDouble(abilityAbsText.getText()),
                        Integer.parseInt(abilityLoText.getText()), Integer.parseInt(abilityHiText.getText()));
            } else {
                o.sameAbility(oldOfficer);
            }
            if (randomFaceRadio.isSelected() && !copy[i]) {
                o.randomFaceImage();
            } else if (genderFaceRadio.isSelected() && !copy[i]) {
                setFace(o, db);
            } else if (typedFaceRadio.isSelected() && !copy[i]) {
                setTypedFace(o, db);
            } else {
                o.setSameFace(oldOfficer);
            }

            if (randomizeAdaptabilityCheckbox.isSelected() && !copy[i]) {
                o.randomAdaptability(Double.parseDouble(adaptabilityMulText.getText()), Double.parseDouble(adaptabilityAbsText.getText()),
                        adaptabilityLoCombo.getSelectedIndex(), adaptabilityHiCombo.getSelectedIndex());
            } else {
                o.sameAdaptability(oldOfficer);
            }
            if (randomizeGrowthTypeCheckbox.isSelected() && !copy[i]) {
                o.randomGrowthType(useSpecialGrowthTypeCheckbox.isSelected());
            } else {
                o.sameGrowthType(oldOfficer);
            }
            double noSpecialProb = 0;
            if (o instanceof TypedOfficer) {
                switch (((TypedOfficer) o).getType()) {
                    case 0:
                        noSpecialProb = noSpecialProb1Slider.getValue() / 100.0;
                        break;
                    case 1:
                        noSpecialProb = noSpecialProb1Slider1.getValue() / 100.0;
                        break;
                    case 2:
                        noSpecialProb = noSpecialProb1Slider2.getValue() / 100.0;
                        break;
                    case 3:
                        noSpecialProb = noSpecialProb1Slider3.getValue() / 100.0;
                        break;
                    case 4:
                        noSpecialProb = noSpecialProb1Slider4.getValue() / 100.0;
                        break;
                    case 5:
                        noSpecialProb = noSpecialProb1Slider5.getValue() / 100.0;
                        break;
                    case 6:
                        noSpecialProb = noSpecialProb1Slider6.getValue() / 100.0;
                        break;
                    case 7:
                        noSpecialProb = noSpecialProb1Slider7.getValue() / 100.0;
                        break;
                    case 8:
                        noSpecialProb = noSpecialProb1Slider8.getValue() / 100.0;
                        break;
                }
            }
            if (clearSpecialRadio.isSelected() && !copy[i]) {
                o.clearSpecial();
            } else if (randomizeNoSpecialRadio.isSelected() || copy[i]) {
                o.sameSpecial(oldOfficer);
            } else if (randomizeNormalSpecialRadio.isSelected()) {
                o.randomSpecials(99, noSpecialProb);
            } else if (randomizeSireSpecialRadio.isSelected()) {
                o.randomSpecials(149, noSpecialProb);
            } else {
                o.randomSpecials(Integer.parseInt(randomizeAllSpecialText.getText()), noSpecialProb);
            }

            if (i >= officerCnt) {
                o.clearStatus(oldOfficer);
            } else if (noChangeTeamRadio.isSelected() || copy[i]) {
                o.sameStatus(oldOfficer);
            } else {
                o.randomLocation(changeUnemployedTeamRadio.isSelected(), oldOfficer, scenYear, employProbSlider.getValue() / 100.0);
            }

            if (randomizeYearCheckbox.isSelected() && !copy[i]) {
                if (ignoreScenYearCheckbox.isSelected()) {
                    o.completeRandomYears(
                            Integer.parseInt(debutYearLoText.getText()),
                            Integer.parseInt(debutYearHiText.getText()),
                            Integer.parseInt(bornYearLoText.getText()),
                            Integer.parseInt(bornYearHiText.getText()),
                            Integer.parseInt(deadYearLoText.getText()),
                            Integer.parseInt(deadYearHiText.getText()));
                } else {
                    o.randomYears(oldOfficer, scenYear,
                            Integer.parseInt(debutYearLoText.getText()),
                            Integer.parseInt(debutYearHiText.getText()),
                            Integer.parseInt(bornYearLoText.getText()),
                            Integer.parseInt(bornYearHiText.getText()),
                            Integer.parseInt(deadYearLoText.getText()),
                            Integer.parseInt(deadYearHiText.getText()));
                }
            } else {
                o.sameYear(oldOfficer);
            }

            if (randomizeMeritoriousCheckbox.isSelected() && !copy[i]) {
                o.randomMeritorious(Integer.parseInt(meritoriousLoText.getText()), Integer.parseInt(meritoriousHiText.getText()));
            } else {
                o.sameMeritorious(oldOfficer);
            }

            if (randomizeAttachmentCheckbox.isSelected() && !copy[i]) {
                o.randomPersonAttachment(Integer.parseInt(attachmentLoText.getText()), Integer.parseInt(attachmentHiText.getText()));
            } else {
                o.sameAttachment(oldOfficer);
            }
            if (randomizeNaturalDeathCheckbox.isSelected() && !copy[i]) {
                o.randomNaturalDeath(naturalDeathProbSlider.getValue() / 100.0);
            } else {
                o.sameNaturalDeath(oldOfficer);
            }

            if (randomizeNoBrotherRadio.isSelected() || copy[i]) {
                o.sameBrother(oldOfficer);
            } else {
                o.setNoBrother();
            }
            if (randomizeNoBloodRadio.isSelected() || copy[i]) {
                o.sameBlood(oldOfficer);
            } else {
                o.setNoBlood();
            }

            if (randomizeNoImitateRadio.isSelected() || copy[i]) {
                o.sameImitatingOfficers(oldOfficer);
            } else {
                o.setNoImitatingOfficers();
            }
            if (randomizeNoHateRadio.isSelected() || copy[i]) {
                o.sameHateOfficers(oldOfficer);
            } else {
                o.setNoHateOfficers();
            }
            //o.setRandomImitatingOfficers(0.3);
            //o.setRandomHateOfficers(0.5);

            if (clearOfficerCheckbox.isSelected() || copy[i]) {
                o.setNoOffice();
            } else {
                o.sameOffice(oldOfficer);
            }
            if (randomizeHiddenValuesCheckbox.isSelected() && !copy[i]) {
                o.randomHiddenValues(useSpecialSpeechCheckbox.isSelected());
            } else {
                o.sameHiddenValues(oldOfficer);
            }
            if (modelGenderCheckbox.isSelected() && !copy[i]) {
                o.random3DModels(modelGenderCheckbox.isSelected(), modelTypeCheckbox.isSelected(), useSpecial3dModelCheckbox.isSelected());
            } else {
                o.same3DModels(oldOfficer);
            }

            //o.writeOfficer(scenFile, i * 0x98);
            allOfficers[i] = o;
        }

        //full-family relations, including brothers
        if (randomizeBloodRadio.isSelected()) {
            for (int i = 0; i < officerCnt; ++i) {
                //forget about officers not to be changed
                if (copy[i]) {
                    continue;
                }

                //find a suitable spouse
                for (int j = 0; j < officerCnt; ++j) {
                    //definitely not him/herself!!
                    if (i == j) {
                        continue;
                    }
                    if (copy[j]) {
                        continue;
                    }
                    //different gender (of course!) and cannot differ too much in age, and both must not have a spouse already (of course!)
                    if (allOfficers[i].getGender() != allOfficers[j].getGender() && Math.abs(allOfficers[i].getBornYear() - allOfficers[j].getBornYear()) < 40
                            && allOfficers[i].getSpouse() == Officer.NO_SUCH_OFFICER && allOfficers[j].getSpouse() == Officer.NO_SUCH_OFFICER) {
                        //cannot be in same blood (of course!)
                        if (allOfficers[i].getTightBlood() != allOfficers[j].getTightBlood() && !allOfficers[i].isSameSurname(allOfficers[j])) {
                            //must be in same team or not yet employed (prevent officers going to other faction right at the beginning)
                            if (allOfficers[i].getTeam() == allOfficers[j].getTeam() || (allOfficers[j].getStatus() == Officer.STATUS_NOT_DEBUTTED)) {
                                if (Math.random() < (allOfficers[j].isEmployed() ? Double.parseDouble(spouseSameFactionText.getText()) / 1000.0 : Double.parseDouble(spouseNoFactionText.getText()) / 1000.0)) {
                                    allOfficers[i].setSpouse(j);
                                    allOfficers[j].setSpouse(i);
                                    allOfficers[j].setTightBlood(allOfficers[i].getTightBlood());
                                    if (Math.random() < spouseAttachmentProbSlider.getValue() / 100.0) {
                                        allOfficers[j].randomPersonAttachmentWithinDiff(allOfficers[i], Integer.parseInt(spouseAttachmentText.getText()), Integer.parseInt(attachmentHiText.getText()));
                                    }
                                }
                            } else {
                                if (Math.random() < Double.parseDouble(spouseDiffFactionText.getText()) / 1000.0) {
                                    allOfficers[i].setSpouse(j);
                                    allOfficers[j].setSpouse(i);
                                    allOfficers[j].setTightBlood(allOfficers[i].getTightBlood());
                                    if (Math.random() < spouseAttachmentProbSlider.getValue() / 100.0) {
                                        allOfficers[j].randomPersonAttachmentWithinDiff(allOfficers[i], Integer.parseInt(spouseAttachmentText.getText()), Integer.parseInt(attachmentHiText.getText()));
                                    }
                                }
                            }
                        }
                    }
                }
            }

            for (int i = 0; i < officerCnt; ++i) {
                if (copy[i]) {
                    continue;
                }

                //find suitable children (though a spouse may not be found)
                double numChild = 0;
                for (int j = 0; j < officerCnt; ++j) {
                    //definitely not him/herself!!
                    if (i == j) {
                        continue;
                    }
                    if (copy[j]) {
                        continue;
                    }
                    //compare age
                    if (allOfficers[i].getBornYear() + 15 <= allOfficers[j].getBornYear()
                            && allOfficers[j].getBornYear() <= allOfficers[i].getBornYear() + 60) {
                        if (allOfficers[i].getSpouse() != Officer.NO_SUCH_OFFICER) {
                            if (!(allOfficers[allOfficers[i].getSpouse()].getBornYear() + 15 <= allOfficers[j].getBornYear()
                                    && allOfficers[j].getBornYear() <= allOfficers[allOfficers[i].getSpouse()].getBornYear() + 60)) {
                                continue;
                            }
                        }
                        //be in same team or not yet employed
                        boolean getParent = false;
                        if (allOfficers[i].getTeam() == allOfficers[j].getTeam() || (allOfficers[j].getStatus() == Officer.STATUS_NOT_DEBUTTED)) {
                            if (Math.random() < (allOfficers[j].isEmployed() ? Double.parseDouble(childSameFactionText.getText()) / 1000.0 : Double.parseDouble(childNoFactionText.getText()) / 1000.0)
                                    / (numChild * Double.parseDouble(childMultipleDegradeText.getText()) + 1)) {
                                getParent = true;
                            }
                        } else {
                            //otherwise - it may be possible but at even lower prob
                            if (Math.random() < Double.parseDouble(childDiffFactionText.getText()) / 1000.0 / (numChild * Double.parseDouble(childMultipleDegradeText.getText()) + 1)) {
                                getParent = true;
                            }
                        }
                        //skip if the other already has father/mother
                        if (allOfficers[j].getFather() != Officer.NO_SUCH_OFFICER || allOfficers[j].getMother() != Officer.NO_SUCH_OFFICER) {
                            getParent = false;
                        }
                        if (getParent) {
                            if (allOfficers[i].getGender() == Officer.MALE) {
                                if (!noSurnameChangeCheckbox.isSelected()){
                                    allOfficers[j].setSameSurname(allOfficers[i]);
                                }
                                allOfficers[j].setBlood(allOfficers[i].getBlood());
                                allOfficers[j].setTightBlood(allOfficers[i].getTightBlood());
                            } else {
                                if (allOfficers[i].getSpouse() != Officer.NO_SUCH_OFFICER) {
                                    if (!noSurnameChangeCheckbox.isSelected()){
                                        allOfficers[j].setSameSurname(allOfficers[allOfficers[i].getSpouse()]);
                                    }
                                    allOfficers[j].setBlood(allOfficers[allOfficers[i].getSpouse()].getBlood());
                                    allOfficers[j].setTightBlood(allOfficers[allOfficers[i].getSpouse()].getTightBlood());
                                }
                            }
                            allOfficers[j].setGeneration(allOfficers[i].getGeneration() + 1);
                            if (Math.random() < childAttachmentProbSlider.getValue() / 100.0) {
                                allOfficers[j].randomPersonAttachmentWithinDiff(allOfficers[i], Integer.parseInt(childAttachmentText.getText()), Integer.parseInt(attachmentHiText.getText()));
                            }
                            //The person being set may already have more children - set their surname, blood and generation also!
                            setBloodForDescendent(allOfficers, allOfficers[j], officerCnt);
                            if (allOfficers[i].getGender() == Officer.MALE) {
                                allOfficers[j].setFather(i);
                                allOfficers[j].setMother(allOfficers[i].getSpouse());
                            } else {
                                allOfficers[j].setMother(i);
                                allOfficers[j].setFather(allOfficers[i].getSpouse());
                            }
                            numChild++;
                        }
                    }
                }
            }
        }

        if (randomizeBrotherRadio.isSelected()) {
            for (int i = 0; i < officerCnt; ++i) {
                if (copy[i]) {
                    continue;
                }
                //find suitable brother
                //int brotherCnt = 1;
                for (int j = 0; j < officerCnt; ++j) {
                    //definitely not him/herself!!
                    if (i == j) {
                        continue;
                    }
                    if (copy[j]) {
                        continue;
                    }
                    //same gender (of course!) and cannot differ too much in age, and other side do not has a brother already, and brotherCnt < 3
                    if (allOfficers[i].getGender() == allOfficers[j].getGender() && Math.abs(allOfficers[i].getBornYear() - allOfficers[j].getBornYear()) < 40
                            && allOfficers[i].getBrother() == Officer.NO_SUCH_OFFICER && allOfficers[j].getBrother() == Officer.NO_SUCH_OFFICER /*&& brotherCnt < 3*/) {
                        //cannot be in same blood (of course!)
                        if (allOfficers[i].getTightBlood() != allOfficers[j].getTightBlood() && !allOfficers[i].isSameSurname(allOfficers[j])) {
                            //must be in same team or not yet employed (prevent officers going to other faction right at the beginning)
                            if (allOfficers[i].getTeam() == allOfficers[j].getTeam() || (allOfficers[j].getStatus() == Officer.STATUS_NOT_DEBUTTED)) {
                                if (Math.random() < (allOfficers[j].isEmployed() ? Double.parseDouble(brotherSameFactionText.getText()) / 1000.0 : Double.parseDouble(brotherNoFactionText.getText()) / 1000.0)) {
                                    allOfficers[i].setBrother(i);
                                    allOfficers[j].setBrother(i);
                                    allOfficers[j].setTightBlood(allOfficers[i].getTightBlood());
                                    if (Math.random() < brotherAttachmentProbSlider.getValue() / 100.0) {
                                        allOfficers[j].randomPersonAttachmentWithinDiff(allOfficers[i], Integer.parseInt(brotherAttachmentText.getText()), Integer.parseInt(attachmentHiText.getText()));
                                    }
                                    //brotherCnt++;
                                } else {
                                    if (Math.random() < Double.parseDouble(brotherDiffFactionText.getText()) / 1000.0) {
                                        allOfficers[i].setBrother(i);
                                        allOfficers[j].setBrother(i);
                                        allOfficers[j].setTightBlood(allOfficers[i].getTightBlood());
                                        if (Math.random() < brotherAttachmentProbSlider.getValue() / 100.0) {
                                            allOfficers[j].randomPersonAttachmentWithinDiff(allOfficers[i], Integer.parseInt(brotherAttachmentText.getText()), Integer.parseInt(attachmentHiText.getText()));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        //a dirty fix to prevent immoral things from happening!
        if (randomizeBloodRadio.isSelected()) {
            for (int i = 0; i < allOfficers.length; ++i) {
                if (copy[i]) {
                    continue;
                }
                if (allOfficers[i].getSpouse() != Officer.NO_SUCH_OFFICER) {
                    if (allOfficers[allOfficers[i].getSpouse()].getBlood() == allOfficers[i].getBlood()) {
                        allOfficers[allOfficers[i].getSpouse()].setSpouse(Officer.NO_SUCH_OFFICER);
                        allOfficers[i].setSpouse(Officer.NO_SUCH_OFFICER);
                        for (int j = 0; j < allOfficers.length; ++j) {
                            if (copy[j]) {
                                continue;
                            }
                            if (allOfficers[j].getFather() == i || allOfficers[j].getMother() == i) {
                                allOfficers[i].setFather(Officer.NO_SUCH_OFFICER);
                                allOfficers[i].setMother(Officer.NO_SUCH_OFFICER);
                            }
                        }
                    }
                }
            }
        }
        if (randomizeBrotherRadio.isSelected()) {
            for (int i = 0; i < allOfficers.length; ++i) {
                if (copy[i]) {
                    continue;
                }
                if (allOfficers[i].getBrother() != Officer.NO_SUCH_OFFICER) {
                    if (allOfficers[allOfficers[i].getBrother()].getBlood() == allOfficers[i].getBlood() && allOfficers[i].getBrother() != i) {
                        allOfficers[allOfficers[i].getBrother()].setBrother(Officer.NO_SUCH_OFFICER);
                        allOfficers[i].setBrother(Officer.NO_SUCH_OFFICER);
                    }
                }
            }
        }

        //same blood imitate relations
        if (randomizeBloodImitateRadio.isSelected()) {
            for (int i = 0; i < officerCnt; ++i) {
                for (int j = 0; j < officerCnt; ++j) {
                    if (allOfficers[i].getFather() == allOfficers[j].getId() || allOfficers[i].getMother() == allOfficers[j].getId()) {
                        if (Math.random() < childImitateParentSlider.getValue() / 100.0) {
                            allOfficers[i].addImitatingOfficers(allOfficers[j]);
                        }
                        if (Math.random() < parentImitateChildSlider.getValue() / 100.0) {
                            allOfficers[j].addImitatingOfficers(allOfficers[i]);
                        }
                    }
                }
            }
            for (int i = 0; i < officerCnt; ++i) {
                for (int j = i; j < officerCnt; ++j) {
                    if ((allOfficers[i].getFather() == allOfficers[j].getFather() && allOfficers[i].getFather() != Officer.NO_SUCH_OFFICER)
                            || (allOfficers[i].getMother() == allOfficers[j].getMother() && allOfficers[i].getMother() != Officer.NO_SUCH_OFFICER)) {
                        if (Math.random() < brotherImitateSlider.getValue() / 100.0) {
                            allOfficers[i].addImitatingOfficers(allOfficers[j]);
                            if (Math.random() < brotherImitate2Slider.getValue() / 100.0) {
                                allOfficers[j].addImitatingOfficers(allOfficers[i]);
                            }
                        }
                    }
                }
            }
        }

        //imitate/hate relations
        if (randomizeImitateRadio.isSelected()) {
            for (int i = 0; i < officerCnt; ++i) {
                if (copy[i]) {
                    continue;
                }
                while (true) {
                    if (Math.random() > imitateSlider.getValue() / 100.0
                            / (allOfficers[i].getNoImitatingOfficers() * Double.parseDouble(imitateDegradeText.getText()) + 1) || allOfficers[i].getNoImitatingOfficers() >= 5) {
                        break;
                    }
                    int toSet;
                    toSet = Utility.randBetween(0, officerCnt - 1);
                    allOfficers[i].addImitatingOfficers(allOfficers[toSet]);
                    if (Math.random() < imitate2Slider.getValue() / 100.0) {
                        allOfficers[toSet].addImitatingOfficers(allOfficers[i]);
                    }
                }
            }
        }
        if (randomizeHateRadio.isSelected()) {
            for (int i = 0; i < officerCnt; ++i) {
                if (copy[i]) {
                    continue;
                }
                while (true) {
                    if (Math.random() > hateSlider.getValue() / 100.0
                            / (allOfficers[i].getNoHateOfficers() * Double.parseDouble(hateDegradeText.getText()) + 1) || allOfficers[i].getNoHateOfficers() >= 5) {
                        break;
                    }
                    int toSet;
                    toSet = Utility.randBetween(0, officerCnt - 1);
                    allOfficers[i].addHateOfficers(allOfficers[toSet]);
                    if (Math.random() < hate2Slider.getValue() / 100.0) {
                        allOfficers[toSet].addHateOfficers(allOfficers[i]);
                    }
                }
            }
        }

        if (randomizeLoyaltyCheckbox.isSelected()) {
            for (int i = 0; i < officerCnt; ++i) {
                if (copy[i]) {
                    continue;
                }
                for (int j = 0; j < officerCnt; ++j) {
                    if (copy[j]) {
                        continue;
                    }
                    allOfficers[i].setLoyaltyByRelation(allOfficers[j],
                            Integer.parseInt(kingLoyaltyLoText.getText()), Integer.parseInt(kingLoyaltyHiText.getText()),
                            Integer.parseInt(closeLoyaltyLoText.getText()), Integer.parseInt(closeLoyaltyHiText.getText()),
                            Integer.parseInt(imitateLoyaltyLoText.getText()), Integer.parseInt(imitateLoyaltyHiText.getText()),
                            Integer.parseInt(hateLoyaltyLoText.getText()), Integer.parseInt(hateLoyaltyHiText.getText()),
                            Integer.parseInt(bloodLoyaltyLoText.getText()), Integer.parseInt(bloodLoyaltyHiText.getText()),
                            Integer.parseInt(normalLoyaltyHiText.getText()), Integer.parseInt(normalLoyaltyRangeText.getText()),
                            Integer.parseInt(attachmentHiText.getText()) >= 150 ? 255 : 150);
                }
            }
        }

        if (clearCountryNameCheckbox.isSelected()) {
            Officer.clearCountryName(scenFile);
        }

        if (clearAdvisorCheckbox.isSelected()) {
            Officer.clearAdvisor(scenFile);
        }

        if (clearTechniqueRadio.isSelected()) {
            Officer.clearTechnique(scenFile);
        } else if (randomizeTechniqueRadio.isSelected()) {
            Officer.randomTechnique(scenFile,
                    Integer.parseInt(techniqueProbLoText.getText()), Integer.parseInt(techniqueProbHiText.getText()),
                    sameProbForFactionCheckbox.isSelected());
        }

        if (randomizeDiplomacyCheckbox.isSelected()) {
            Officer.randomDiplomacy(diplomacyGaussianCheckbox.isSelected(), scenFile,
                    Integer.parseInt(diplomacyLoText.getText()), Integer.parseInt(diplomacyHiText.getText()),
                    Integer.parseInt(allianceCapText.getText()), allianceProbSlider.getValue());
        }

        //powerful factions

        //search for all teams, a mapping from team id to number of officers
        Map<Integer, Integer> teams = new HashMap<Integer, Integer>();
        for (Officer o : allOfficers) {
            if (teams.containsKey(o.getTeam())) {
                teams.put(o.getTeam(), teams.get(o.getTeam()) + 1);
            } else {
                teams.put(o.getTeam(), 1);
            }
        }

        //remove entries which number of officers are too small
        Iterator<Map.Entry<Integer, Integer>> it = teams.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, Integer> e = it.next();
            if (e.getValue() < Integer.parseInt(strongFactionMinOfficerText.getText()) || e.getKey() == 65535) {
                it.remove();
            }
        }

        //get a subset of factions
        int strongFactionNo = Utility.randBetween(Integer.parseInt(strongFactionLoText.getText()), Integer.parseInt(strongFactionHiText.getText()));
        if (teams.size() < strongFactionNo) {
            strongFactionNo = teams.size();
        }
        Set<Integer> powerTeam = Utility.subset(teams.keySet(), strongFactionNo);

        for (Officer o : allOfficers) {
            if (powerTeam.contains(o.getTeam())) {
                if (Utility.probTest(strongFactionOfficerProbSlider.getValue())) {
                    o.tweakAbility(Double.parseDouble(strongFactionAbyMulText.getText()), Integer.parseInt(strongFactionAbyAbsText.getText()));
                    o.tweakAdaptability(Double.parseDouble(strongFactionAdpMulText.getText()), Integer.parseInt(strongFactionAdpAbsText.getText()));
                    if (strongFactionSpecialCheckbox.isSelected()) {
                        if (clearSpecialRadio.isSelected()) {
                            o.clearSpecial();
                        } else if (randomizeNoSpecialRadio.isSelected()) {
                            //do nothing
                        } else if (randomizeNormalSpecialRadio.isSelected()) {
                            ((TypedOfficer) o).randomSpecials(99, 0, TypedOfficer.ALL_ROUNDER);
                        } else if (randomizeSireSpecialRadio.isSelected()) {
                            ((TypedOfficer) o).randomSpecials(149, 0, TypedOfficer.ALL_ROUNDER);
                        } else {
                            ((TypedOfficer) o).randomSpecials(Integer.parseInt(randomizeAllSpecialText.getText()), 0, TypedOfficer.ALL_ROUNDER);
                        }
                    }
                    if (strongFactionRelationCheckbox.isSelected()) { //ensure no leave from faction by relation
                        //TODO need better approach...
                        if (o.getSpouse() == Officer.NO_SUCH_OFFICER && o.getBrother() == Officer.NO_SUCH_OFFICER) {
                            for (Officer j : allOfficers) {
                                if (j.getTeam() == o.getTeam() && !j.isSameSurname(o) && j.getBlood() != o.getBlood()) {
                                    if (j.getGender() == o.getGender()) {
                                        if (j.getBrother() == Officer.NO_SUCH_OFFICER) {
                                            j.setBrother(o.getId());
                                            o.setBrother(o.getId());
                                            break;
                                        }
                                    } else {
                                        if (j.getSpouse() == Officer.NO_SUCH_OFFICER) {
                                            j.setSpouse(o.getId());
                                            o.setSpouse(j.getId());
                                            break;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        //write officers
        for (int i = 0; i < allOfficers.length; ++i) {
            allOfficers[i].writeOfficer(scenFile);
        }

        if (swapCountryCheckbox.isSelected() || resetBaseResourceCheckbox.isSelected() || resetBaseSettingCheckbox.isSelected() || clearGateCheckbox.isSelected()) {
            Officer.writeBaseTeam(scenFile, resetBaseResourceCheckbox.isSelected(), resetBaseSettingCheckbox.isSelected(), clearGateCheckbox.isSelected(),
                    Integer.parseInt(maxTroopLoText.getText()), Integer.parseInt(maxTroopHiText.getText()),
                    Integer.parseInt(troopLoText.getText()), Integer.parseInt(troopHiText.getText()),
                    Integer.parseInt(cashLoText.getText()), Integer.parseInt(cashHiText.getText()),
                    Integer.parseInt(cropLoText.getText()), Integer.parseInt(cropHiText.getText()),
                    Integer.parseInt(spearLoText.getText()), Integer.parseInt(spearHiText.getText()),
                    Integer.parseInt(halberdLoText.getText()), Integer.parseInt(halberdHiText.getText()),
                    Integer.parseInt(bowLoText.getText()), Integer.parseInt(bowHiText.getText()),
                    Integer.parseInt(horseLoText.getText()), Integer.parseInt(horseHiText.getText()),
                    Integer.parseInt(ramLoText.getText()), Integer.parseInt(ramHiText.getText()),
                    Integer.parseInt(catapultLoText.getText()), Integer.parseInt(catapultHiText.getText()),
                    Integer.parseInt(shipLoText.getText()), Integer.parseInt(shipHiText.getText()),
                    Integer.parseInt(cashInLoText.getText()), Integer.parseInt(cashInHiText.getText()),
                    Integer.parseInt(cropInLoText.getText()), Integer.parseInt(cropInHiText.getText()),
                    Integer.parseInt(troopMorLoText.getText()), Integer.parseInt(troopMorHiText.getText()),
                    Integer.parseInt(moraleLoText.getText()), Integer.parseInt(moraleHiText.getText()),
                    firstSpecialProbSlider.getValue(), moreSpecialProbSlider.getValue(),
                    horseSpecialLimitCheckbox.isSelected(), navalSpecialLimitCheckbox.isSelected(),
                    Double.parseDouble(bigCityTroopText.getText()), Double.parseDouble(bigCityCashText.getText()), Double.parseDouble(bigCityCropText.getText()),
                    powerTeam,
                    Utility.randBetween(Double.parseDouble(strongFactionTroopLoText.getText()), Double.parseDouble(strongFactionTroopHiText.getText())),
                    Utility.randBetween(Double.parseDouble(strongFactionCashLoText.getText()), Double.parseDouble(strongFactionCashHiText.getText())),
                    Utility.randBetween(Double.parseDouble(strongFactionCropLoText.getText()), Double.parseDouble(strongFactionCropHiText.getText())),
                    Utility.randBetween(Double.parseDouble(strongFactionWeaponLoText.getText()), Double.parseDouble(strongFactionWeaponHiText.getText())),
                    Utility.randBetween(Double.parseDouble(strongFactionCashInLoText.getText()), Double.parseDouble(strongFactionCashInHiText.getText())),
                    Utility.randBetween(Double.parseDouble(strongFactionCropInLoText.getText()), Double.parseDouble(strongFactionCropInHiText.getText())),
                    Integer.parseInt(strongFactionDurabilityLoText.getText()), Integer.parseInt(strongFactionDurabilityHiText.getText()));
        }

        //last but not least, clear scenario description
        scenFile.seek(0x70);
        scenFile.write(0); //null-terminated string - only need to write one zero.

        for (int i = 0, offset = 0x2AD; i < 42; ++i, offset += 0x171) {
            scenFile.seek(offset);
            //clear faction difficulty
            scenFile.write(2);
            //clear faction description
            scenFile.write(0);  //null-terminated string - only need to write one zero.
        }

        //faction color
        if (randomizeFactionColourCheckbox.isSelected()) {
            int[] factColor = Utility.randomOrder(50);
            for (int i = 0, offset = 0x25489; i < 42; ++i, offset += 0x48) {
                scenFile.seek(offset);
                scenFile.write(factColor[i]);
            }
        }

        scenFile.close();
    }

    private void openFileButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_openFileButtonMouseClicked
        int answer = scenFileChooser.showOpenDialog(this);
        if (answer == JFileChooser.APPROVE_OPTION) {
            File f = scenFileChooser.getSelectedFile();
            try {
                Utility.copyFile(f.getCanonicalPath(), f.getCanonicalPath() + ".bak");
                randomize(f, combineSkillLangCombo.getSelectedIndex() == 0 ? "Big5" : "GBK");
                JOptionPane.showMessageDialog(this, "檔案修改成功！", APP_NAME, JOptionPane.INFORMATION_MESSAGE);
            } catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(this, "輸入錯誤：" + ex.getMessage(), APP_NAME, JOptionPane.ERROR_MESSAGE);
                ex.printStackTrace();
                return;
            } catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "修改檔案途中出現問題：" + ex.getMessage(), APP_NAME, JOptionPane.ERROR_MESSAGE);
                ex.printStackTrace();
                return;
            }
        }
    }//GEN-LAST:event_openFileButtonMouseClicked

    private void exportSettingButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_exportSettingButtonMouseClicked
        int answer = settingFileChooser.showOpenDialog(this);
        if (answer == JFileChooser.APPROVE_OPTION) {
            File file = settingFileChooser.getSelectedFile();
            try {
                String pathname = file.getCanonicalPath();
                if (!pathname.endsWith(SETTING_FILE_EXTENSION)) {
                    pathname += "." + SETTING_FILE_EXTENSION;
                }
                BufferedWriter w = new BufferedWriter(new FileWriter(pathname));
                Field[] fields = Frontend.class.getDeclaredFields();
                for (Field f : fields) {
                    if (Modifier.isFinal(f.getModifiers())) {
                        continue; //do not write final fields - it won't be read
                    }
                    Object swingObj = f.get(this);
                    if (swingObj instanceof javax.swing.JTextField) {
                        w.write(f.getName() + " " + ((javax.swing.JTextField) swingObj).getText());
                        w.newLine();
                    } else if (swingObj instanceof javax.swing.JSlider) {
                        w.write(f.getName() + " " + String.valueOf(((javax.swing.JSlider) swingObj).getValue()));
                        w.newLine();
                    } else if (swingObj instanceof javax.swing.JToggleButton) { //includes checkbox/radio
                        w.write(f.getName() + " " + (((javax.swing.JToggleButton) swingObj).isSelected() ? "1" : "0"));
                        w.newLine();
                    } else if (swingObj instanceof javax.swing.JComboBox) {
                        w.write(f.getName() + " " + String.valueOf(((javax.swing.JComboBox) swingObj).getSelectedIndex()));
                        w.newLine();
                    }
                }
                w.close();
            } catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "儲存檔案途中出現問題：" + ex.getMessage(), APP_NAME, JOptionPane.ERROR_MESSAGE);
                ex.printStackTrace();
            }
        }
    }//GEN-LAST:event_exportSettingButtonMouseClicked

    private void importSettingButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_importSettingButtonMouseClicked
        int answer = settingFileChooser.showOpenDialog(this);
        if (answer == JFileChooser.APPROVE_OPTION) {
            File file = settingFileChooser.getSelectedFile();
            try {
                BufferedReader r = new BufferedReader(new FileReader(file));
                Map<String, String> fieldValue = new HashMap<String, String>();
                String line;
                while ((line = r.readLine()) != null) {
                    String[] temp = line.split(" ");
                    fieldValue.put(temp[0], temp[1]);
                }
                Field[] fields = Frontend.class.getDeclaredFields();
                for (Field f : fields) {
                    if (Modifier.isFinal(f.getModifiers())) {
                        continue; //do not attempt to write to final fields
                    }
                    String value = fieldValue.get(f.getName());
                    if (value != null) {
                        Object swingObj = f.get(this);
                        if (swingObj instanceof javax.swing.JTextField) {
                            ((javax.swing.JTextField) swingObj).setText(value);
                        } else if (swingObj instanceof javax.swing.JSlider) {
                            ((javax.swing.JSlider) swingObj).setValue(Integer.parseInt(value));
                        } else if (swingObj instanceof javax.swing.JToggleButton) { //includes checkbox/radio
                            ((javax.swing.JToggleButton) swingObj).setSelected(value.equals("1") ? true : false);
                        } else if (swingObj instanceof javax.swing.JComboBox) {
                            ((javax.swing.JComboBox) swingObj).setSelectedIndex(Integer.parseInt(value));
                        }
                    }
                }
                r.close();
            } catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "讀取檔案途中出現問題：" + ex.getMessage(), APP_NAME, JOptionPane.ERROR_MESSAGE);
                ex.printStackTrace();
            }
        }
        updatePercentLabels();
    }//GEN-LAST:event_importSettingButtonMouseClicked

    private void hate2SliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_hate2SliderStateChanged
        hate2Label.setText(hate2Slider.getValue() + "%");
}//GEN-LAST:event_hate2SliderStateChanged

    private void hateSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_hateSliderStateChanged
        hateLabel.setText(hateSlider.getValue() + "%");
}//GEN-LAST:event_hateSliderStateChanged

    private void imitate2SliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_imitate2SliderStateChanged
        imitate2Label.setText(imitate2Slider.getValue() + "%");
}//GEN-LAST:event_imitate2SliderStateChanged

    private void imitateSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_imitateSliderStateChanged
        imitateLabel.setText(imitateSlider.getValue() + "%");
}//GEN-LAST:event_imitateSliderStateChanged

    private void brotherImitate2SliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_brotherImitate2SliderStateChanged
        brotherImitate2Label.setText(brotherImitate2Slider.getValue() + "%");
}//GEN-LAST:event_brotherImitate2SliderStateChanged

    private void brotherImitateSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_brotherImitateSliderStateChanged
        brotherImitateLabel.setText(brotherImitateSlider.getValue() + "%");
}//GEN-LAST:event_brotherImitateSliderStateChanged

    private void parentImitateChildSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_parentImitateChildSliderStateChanged
        parentImitateChildLabel.setText(parentImitateChildSlider.getValue() + "%");
}//GEN-LAST:event_parentImitateChildSliderStateChanged

    private void childImitateParentSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_childImitateParentSliderStateChanged
        childImitateParentLabel.setText(childImitateParentSlider.getValue() + "%");
}//GEN-LAST:event_childImitateParentSliderStateChanged

    private void brotherAttachmentProbSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_brotherAttachmentProbSliderStateChanged
        brotherAttachmentProbLabel.setText(brotherAttachmentProbSlider.getValue() + "%");
}//GEN-LAST:event_brotherAttachmentProbSliderStateChanged

    private void childAttachmentProbSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_childAttachmentProbSliderStateChanged
        childAttachmentProbLabel.setText(childAttachmentProbSlider.getValue() + "%");
}//GEN-LAST:event_childAttachmentProbSliderStateChanged

    private void spouseAttachmentProbSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_spouseAttachmentProbSliderStateChanged
        spouseAttachmentProbLabel.setText(spouseAttachmentProbSlider.getValue() + "%");
}//GEN-LAST:event_spouseAttachmentProbSliderStateChanged

    private void employProbSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_employProbSliderStateChanged
        employProbLabel.setText(employProbSlider.getValue() + "%");
}//GEN-LAST:event_employProbSliderStateChanged

    private void noSpecialProb1Slider8StateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_noSpecialProb1Slider8StateChanged
        noSpecialProb1Label8.setText(noSpecialProb1Slider8.getValue() + "%");
}//GEN-LAST:event_noSpecialProb1Slider8StateChanged

    private void noSpecialProb1Slider7StateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_noSpecialProb1Slider7StateChanged
        noSpecialProb1Label7.setText(noSpecialProb1Slider7.getValue() + "%");
}//GEN-LAST:event_noSpecialProb1Slider7StateChanged

    private void noSpecialProb1Slider6StateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_noSpecialProb1Slider6StateChanged
        noSpecialProb1Label6.setText(noSpecialProb1Slider6.getValue() + "%");
}//GEN-LAST:event_noSpecialProb1Slider6StateChanged

    private void noSpecialProb1Slider5StateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_noSpecialProb1Slider5StateChanged
        noSpecialProb1Label5.setText(noSpecialProb1Slider5.getValue() + "%");
}//GEN-LAST:event_noSpecialProb1Slider5StateChanged

    private void noSpecialProb1Slider4StateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_noSpecialProb1Slider4StateChanged
        noSpecialProb1Label4.setText(noSpecialProb1Slider4.getValue() + "%");
}//GEN-LAST:event_noSpecialProb1Slider4StateChanged

    private void noSpecialProb1Slider3StateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_noSpecialProb1Slider3StateChanged
        noSpecialProb1Label3.setText(noSpecialProb1Slider3.getValue() + "%");
}//GEN-LAST:event_noSpecialProb1Slider3StateChanged

    private void noSpecialProb1Slider2StateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_noSpecialProb1Slider2StateChanged
        noSpecialProb1Label2.setText(noSpecialProb1Slider2.getValue() + "%");
}//GEN-LAST:event_noSpecialProb1Slider2StateChanged

    private void noSpecialProb1Slider1StateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_noSpecialProb1Slider1StateChanged
        noSpecialProb1Label1.setText(noSpecialProb1Slider1.getValue() + "%");
}//GEN-LAST:event_noSpecialProb1Slider1StateChanged

    private void noSpecialProb1SliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_noSpecialProb1SliderStateChanged
        noSpecialProb1Label.setText(noSpecialProb1Slider.getValue() + "%");
}//GEN-LAST:event_noSpecialProb1SliderStateChanged

    private void naturalDeathProbSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_naturalDeathProbSliderStateChanged
        natrualDeathProbLabel.setText(naturalDeathProbSlider.getValue() + "%");
}//GEN-LAST:event_naturalDeathProbSliderStateChanged

    private void doubleNameProbSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_doubleNameProbSliderStateChanged
        doubleNameProbLabel.setText(doubleNameProbSlider.getValue() + "%");
}//GEN-LAST:event_doubleNameProbSliderStateChanged

    private void femaleOfficerProbSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_femaleOfficerProbSliderStateChanged
        femaleOfficerProbLabel.setText(femaleOfficerProbSlider.getValue() + "%");
}//GEN-LAST:event_femaleOfficerProbSliderStateChanged

    private void firstSpecialProbSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_firstSpecialProbSliderStateChanged
        firstSpecialProbLabel.setText(firstSpecialProbSlider.getValue() + "%");
    }//GEN-LAST:event_firstSpecialProbSliderStateChanged

    private void moreSpecialProbSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_moreSpecialProbSliderStateChanged
        moreSpecialProbLabel.setText(moreSpecialProbSlider.getValue() + "%");
    }//GEN-LAST:event_moreSpecialProbSliderStateChanged

    private void allianceProbSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_allianceProbSliderStateChanged
        allianceProbLabel.setText(allianceProbSlider.getValue() + "%");
    }//GEN-LAST:event_allianceProbSliderStateChanged

    private void strongFactionOfficerProbSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_strongFactionOfficerProbSliderStateChanged
        strongFactionOfficerProbLabel.setText(strongFactionOfficerProbSlider.getValue() + "%");
    }//GEN-LAST:event_strongFactionOfficerProbSliderStateChanged

    /**
     * Parse an integer, and gives 0 silently if failed
     * @param s
     * @return
     */
    private int noExceptionParseInt(String s){
        try {
            return Integer.parseInt(s);
        } catch (NumberFormatException e){
            return 0;
        }
    }

    private void updatePercentLabels(){
        int sum = noExceptionParseInt(generalTypeWeightText.getText()) + noExceptionParseInt(mightyTypeWeightText.getText()) +noExceptionParseInt(advisorTypeWeightText.getText()) +
                noExceptionParseInt(politicianTypeWeightText.getText()) + noExceptionParseInt(intelGeneralTypeWeightText.getText()) + noExceptionParseInt(emperorTypeWeightText.getText()) +
                noExceptionParseInt(allRounderTypeWeightText.getText()) + noExceptionParseInt(normalTypeWeightText.getText()) + noExceptionParseInt(cheapTypeWeightText.getText());
        typePercentageLabel.setText(Math.round(noExceptionParseInt(generalTypeWeightText.getText()) / (double) sum * 100 * 10) / 10.0 + "%");
        typePercentageLabel1.setText(Math.round(noExceptionParseInt(mightyTypeWeightText.getText()) / (double) sum * 100 * 10) / 10.0 + "%");
        typePercentageLabel2.setText(Math.round(noExceptionParseInt(advisorTypeWeightText.getText()) / (double) sum * 100 * 10) / 10.0 + "%");
        typePercentageLabel3.setText(Math.round(noExceptionParseInt(politicianTypeWeightText.getText()) / (double) sum * 100 * 10) / 10.0 + "%");
        typePercentageLabel4.setText(Math.round(noExceptionParseInt(intelGeneralTypeWeightText.getText()) / (double) sum * 100 * 10) / 10.0 + "%");
        typePercentageLabel5.setText(Math.round(noExceptionParseInt(emperorTypeWeightText.getText()) / (double) sum * 100 * 10) / 10.0 + "%");
        typePercentageLabel6.setText(Math.round(noExceptionParseInt(allRounderTypeWeightText.getText()) / (double) sum * 100 * 10) / 10.0 + "%");
        typePercentageLabel7.setText(Math.round(noExceptionParseInt(normalTypeWeightText.getText()) / (double) sum * 100 * 10) / 10.0 + "%");
        typePercentageLabel8.setText(Math.round(noExceptionParseInt(cheapTypeWeightText.getText()) / (double) sum * 100 * 10) / 10.0 + "%");
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        } catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        } catch (InstantiationException ex) {
            ex.printStackTrace();
        } catch (IllegalAccessException ex) {
            ex.printStackTrace();
        } catch (UnsupportedLookAndFeelException ex) {
            ex.printStackTrace();
        }
        java.awt.EventQueue.invokeLater(new Runnable() {

            public void run() {
                new Frontend().setVisible(true);
            }
        });
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField abilityAbsText;
    private javax.swing.JTextField abilityHiText;
    private javax.swing.JTextField abilityLoText;
    private javax.swing.JTextField abilityMulText;
    private javax.swing.JTextField adaptabilityAbsText;
    private javax.swing.JComboBox adaptabilityHiCombo;
    private javax.swing.JComboBox adaptabilityLoCombo;
    private javax.swing.JTextField adaptabilityMulText;
    private javax.swing.JTextField advisorTypeWeightText;
    private javax.swing.JTextField allRounderTypeWeightText;
    private javax.swing.JTextField allianceCapText;
    private javax.swing.JLabel allianceProbLabel;
    private javax.swing.JSlider allianceProbSlider;
    private javax.swing.JTextField attachmentHiText;
    private javax.swing.JTextField attachmentLoText;
    private javax.swing.JTextField bigCityCashText;
    private javax.swing.JTextField bigCityCropText;
    private javax.swing.JTextField bigCityTroopText;
    private javax.swing.ButtonGroup bloodGroup;
    private javax.swing.ButtonGroup bloodImitateGroup;
    private javax.swing.JTextField bloodLoyaltyHiText;
    private javax.swing.JTextField bloodLoyaltyLoText;
    private javax.swing.JTextField bornYearHiText;
    private javax.swing.JTextField bornYearLoText;
    private javax.swing.JTextField bowHiText;
    private javax.swing.JTextField bowLoText;
    private javax.swing.JLabel brotherAttachmentProbLabel;
    private javax.swing.JSlider brotherAttachmentProbSlider;
    private javax.swing.JTextField brotherAttachmentText;
    private javax.swing.JTextField brotherDiffFactionText;
    private javax.swing.ButtonGroup brotherGroup;
    private javax.swing.JLabel brotherImitate2Label;
    private javax.swing.JSlider brotherImitate2Slider;
    private javax.swing.JLabel brotherImitateLabel;
    private javax.swing.JSlider brotherImitateSlider;
    private javax.swing.JTextField brotherNoFactionText;
    private javax.swing.JTextField brotherSameFactionText;
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JTextField cashHiText;
    private javax.swing.JTextField cashInHiText;
    private javax.swing.JTextField cashInLoText;
    private javax.swing.JTextField cashLoText;
    private javax.swing.JTextField catapultHiText;
    private javax.swing.JTextField catapultLoText;
    private javax.swing.JRadioButton changeAllTeamRadio;
    private javax.swing.JRadioButton changeUnemployedTeamRadio;
    private javax.swing.JTextField cheapTypeWeightText;
    private javax.swing.JLabel childAttachmentProbLabel;
    private javax.swing.JSlider childAttachmentProbSlider;
    private javax.swing.JTextField childAttachmentText;
    private javax.swing.JTextField childDiffFactionText;
    private javax.swing.JLabel childImitateParentLabel;
    private javax.swing.JSlider childImitateParentSlider;
    private javax.swing.JTextField childMultipleDegradeText;
    private javax.swing.JTextField childNoFactionText;
    private javax.swing.JTextField childSameFactionText;
    private javax.swing.JCheckBox clearAdvisorCheckbox;
    private javax.swing.JRadioButton clearBloodRadio;
    private javax.swing.JRadioButton clearBrotherRadio;
    private javax.swing.JCheckBox clearCountryNameCheckbox;
    private javax.swing.JCheckBox clearGateCheckbox;
    private javax.swing.JRadioButton clearHateRadio;
    private javax.swing.JRadioButton clearImitateRadio;
    private javax.swing.JCheckBox clearOfficerCheckbox;
    private javax.swing.JRadioButton clearSpecialRadio;
    private javax.swing.JRadioButton clearTechniqueRadio;
    private javax.swing.JTextField closeLoyaltyHiText;
    private javax.swing.JTextField closeLoyaltyLoText;
    private javax.swing.JRadioButton combineNameRadio;
    private javax.swing.JTextField combineSkillCntHiText;
    private javax.swing.JTextField combineSkillCntLoText;
    private javax.swing.JTextField combineSkillIdHiText;
    private javax.swing.JTextField combineSkillIdLoText;
    private javax.swing.JComboBox combineSkillLangCombo;
    private javax.swing.JTextField cropHiText;
    private javax.swing.JTextField cropInHiText;
    private javax.swing.JTextField cropInLoText;
    private javax.swing.JTextField cropLoText;
    private javax.swing.JTextField deadYearHiText;
    private javax.swing.JTextField deadYearLoText;
    private javax.swing.JTextField debutYearHiText;
    private javax.swing.JTextField debutYearLoText;
    private javax.swing.JCheckBox diplomacyGaussianCheckbox;
    private javax.swing.JTextField diplomacyHiText;
    private javax.swing.JTextField diplomacyLoText;
    private javax.swing.JRadioButton directNameRadio;
    private javax.swing.JLabel doubleNameProbLabel;
    private javax.swing.JSlider doubleNameProbSlider;
    private javax.swing.JTextField emperorTypeWeightText;
    private javax.swing.JLabel employProbLabel;
    private javax.swing.JSlider employProbSlider;
    private javax.swing.JButton exportSettingButton;
    private javax.swing.ButtonGroup faceRadioGroup;
    private javax.swing.ButtonGroup factionTechniqueButtonGroup;
    private javax.swing.JLabel femaleOfficerProbLabel;
    private javax.swing.JSlider femaleOfficerProbSlider;
    private javax.swing.JLabel filePathLabel;
    private javax.swing.JLabel firstSpecialProbLabel;
    private javax.swing.JSlider firstSpecialProbSlider;
    private javax.swing.JRadioButton genderFaceRadio;
    private javax.swing.JTextField generalTypeWeightText;
    private javax.swing.JCheckBox generateCombineSkillCheckbox;
    private javax.swing.JTextField goHaveTeamWeightHiText;
    private javax.swing.JTextField goHaveTeamWeightLoText;
    private javax.swing.JTextField goNoTeamWeightHiText;
    private javax.swing.JTextField goNoTeamWeightLoText;
    private javax.swing.JTextField halberdHiText;
    private javax.swing.JTextField halberdLoText;
    private javax.swing.JLabel hate2Label;
    private javax.swing.JSlider hate2Slider;
    private javax.swing.JTextField hateDegradeText;
    private javax.swing.ButtonGroup hateGroup;
    private javax.swing.JLabel hateLabel;
    private javax.swing.JTextField hateLoyaltyHiText;
    private javax.swing.JTextField hateLoyaltyLoText;
    private javax.swing.JSlider hateSlider;
    private javax.swing.JTextField horseHiText;
    private javax.swing.JTextField horseLoText;
    private javax.swing.JCheckBox horseSpecialLimitCheckbox;
    private javax.swing.JTextField idHiText;
    private javax.swing.JCheckBox ignoreScenYearCheckbox;
    private javax.swing.JLabel imitate2Label;
    private javax.swing.JSlider imitate2Slider;
    private javax.swing.JTextField imitateDegradeText;
    private javax.swing.ButtonGroup imitateGroup;
    private javax.swing.JLabel imitateLabel;
    private javax.swing.JTextField imitateLoyaltyHiText;
    private javax.swing.JTextField imitateLoyaltyLoText;
    private javax.swing.JSlider imitateSlider;
    private javax.swing.JButton importSettingButton;
    private javax.swing.JTextField intelGeneralTypeWeightText;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel100;
    private javax.swing.JLabel jLabel101;
    private javax.swing.JLabel jLabel102;
    private javax.swing.JLabel jLabel103;
    private javax.swing.JLabel jLabel104;
    private javax.swing.JLabel jLabel105;
    private javax.swing.JLabel jLabel106;
    private javax.swing.JLabel jLabel107;
    private javax.swing.JLabel jLabel108;
    private javax.swing.JLabel jLabel109;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel110;
    private javax.swing.JLabel jLabel111;
    private javax.swing.JLabel jLabel112;
    private javax.swing.JLabel jLabel113;
    private javax.swing.JLabel jLabel114;
    private javax.swing.JLabel jLabel115;
    private javax.swing.JLabel jLabel116;
    private javax.swing.JLabel jLabel117;
    private javax.swing.JLabel jLabel118;
    private javax.swing.JLabel jLabel119;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JLabel jLabel120;
    private javax.swing.JLabel jLabel121;
    private javax.swing.JLabel jLabel122;
    private javax.swing.JLabel jLabel123;
    private javax.swing.JLabel jLabel124;
    private javax.swing.JLabel jLabel125;
    private javax.swing.JLabel jLabel126;
    private javax.swing.JLabel jLabel127;
    private javax.swing.JLabel jLabel128;
    private javax.swing.JLabel jLabel129;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel130;
    private javax.swing.JLabel jLabel131;
    private javax.swing.JLabel jLabel132;
    private javax.swing.JLabel jLabel133;
    private javax.swing.JLabel jLabel134;
    private javax.swing.JLabel jLabel135;
    private javax.swing.JLabel jLabel136;
    private javax.swing.JLabel jLabel137;
    private javax.swing.JLabel jLabel138;
    private javax.swing.JLabel jLabel139;
    private javax.swing.JLabel jLabel14;
    private javax.swing.JLabel jLabel140;
    private javax.swing.JLabel jLabel141;
    private javax.swing.JLabel jLabel142;
    private javax.swing.JLabel jLabel143;
    private javax.swing.JLabel jLabel144;
    private javax.swing.JLabel jLabel145;
    private javax.swing.JLabel jLabel146;
    private javax.swing.JLabel jLabel147;
    private javax.swing.JLabel jLabel148;
    private javax.swing.JLabel jLabel149;
    private javax.swing.JLabel jLabel15;
    private javax.swing.JLabel jLabel150;
    private javax.swing.JLabel jLabel151;
    private javax.swing.JLabel jLabel152;
    private javax.swing.JLabel jLabel153;
    private javax.swing.JLabel jLabel154;
    private javax.swing.JLabel jLabel155;
    private javax.swing.JLabel jLabel156;
    private javax.swing.JLabel jLabel157;
    private javax.swing.JLabel jLabel158;
    private javax.swing.JLabel jLabel159;
    private javax.swing.JLabel jLabel16;
    private javax.swing.JLabel jLabel160;
    private javax.swing.JLabel jLabel161;
    private javax.swing.JLabel jLabel162;
    private javax.swing.JLabel jLabel163;
    private javax.swing.JLabel jLabel164;
    private javax.swing.JLabel jLabel165;
    private javax.swing.JLabel jLabel166;
    private javax.swing.JLabel jLabel167;
    private javax.swing.JLabel jLabel168;
    private javax.swing.JLabel jLabel169;
    private javax.swing.JLabel jLabel17;
    private javax.swing.JLabel jLabel170;
    private javax.swing.JLabel jLabel171;
    private javax.swing.JLabel jLabel172;
    private javax.swing.JLabel jLabel173;
    private javax.swing.JLabel jLabel18;
    private javax.swing.JLabel jLabel19;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel20;
    private javax.swing.JLabel jLabel21;
    private javax.swing.JLabel jLabel22;
    private javax.swing.JLabel jLabel23;
    private javax.swing.JLabel jLabel24;
    private javax.swing.JLabel jLabel25;
    private javax.swing.JLabel jLabel26;
    private javax.swing.JLabel jLabel27;
    private javax.swing.JLabel jLabel28;
    private javax.swing.JLabel jLabel29;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel30;
    private javax.swing.JLabel jLabel31;
    private javax.swing.JLabel jLabel32;
    private javax.swing.JLabel jLabel33;
    private javax.swing.JLabel jLabel34;
    private javax.swing.JLabel jLabel35;
    private javax.swing.JLabel jLabel36;
    private javax.swing.JLabel jLabel37;
    private javax.swing.JLabel jLabel38;
    private javax.swing.JLabel jLabel39;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel40;
    private javax.swing.JLabel jLabel41;
    private javax.swing.JLabel jLabel42;
    private javax.swing.JLabel jLabel43;
    private javax.swing.JLabel jLabel44;
    private javax.swing.JLabel jLabel45;
    private javax.swing.JLabel jLabel46;
    private javax.swing.JLabel jLabel47;
    private javax.swing.JLabel jLabel48;
    private javax.swing.JLabel jLabel49;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel50;
    private javax.swing.JLabel jLabel51;
    private javax.swing.JLabel jLabel52;
    private javax.swing.JLabel jLabel53;
    private javax.swing.JLabel jLabel54;
    private javax.swing.JLabel jLabel55;
    private javax.swing.JLabel jLabel56;
    private javax.swing.JLabel jLabel57;
    private javax.swing.JLabel jLabel58;
    private javax.swing.JLabel jLabel59;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel60;
    private javax.swing.JLabel jLabel61;
    private javax.swing.JLabel jLabel62;
    private javax.swing.JLabel jLabel63;
    private javax.swing.JLabel jLabel64;
    private javax.swing.JLabel jLabel65;
    private javax.swing.JLabel jLabel66;
    private javax.swing.JLabel jLabel67;
    private javax.swing.JLabel jLabel68;
    private javax.swing.JLabel jLabel69;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel70;
    private javax.swing.JLabel jLabel71;
    private javax.swing.JLabel jLabel72;
    private javax.swing.JLabel jLabel73;
    private javax.swing.JLabel jLabel74;
    private javax.swing.JLabel jLabel75;
    private javax.swing.JLabel jLabel76;
    private javax.swing.JLabel jLabel77;
    private javax.swing.JLabel jLabel78;
    private javax.swing.JLabel jLabel79;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel80;
    private javax.swing.JLabel jLabel81;
    private javax.swing.JLabel jLabel82;
    private javax.swing.JLabel jLabel83;
    private javax.swing.JLabel jLabel84;
    private javax.swing.JLabel jLabel85;
    private javax.swing.JLabel jLabel86;
    private javax.swing.JLabel jLabel87;
    private javax.swing.JLabel jLabel88;
    private javax.swing.JLabel jLabel89;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JLabel jLabel90;
    private javax.swing.JLabel jLabel91;
    private javax.swing.JLabel jLabel92;
    private javax.swing.JLabel jLabel93;
    private javax.swing.JLabel jLabel94;
    private javax.swing.JLabel jLabel95;
    private javax.swing.JLabel jLabel96;
    private javax.swing.JLabel jLabel97;
    private javax.swing.JLabel jLabel98;
    private javax.swing.JLabel jLabel99;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel10;
    private javax.swing.JPanel jPanel11;
    private javax.swing.JPanel jPanel12;
    private javax.swing.JPanel jPanel13;
    private javax.swing.JPanel jPanel14;
    private javax.swing.JPanel jPanel15;
    private javax.swing.JPanel jPanel16;
    private javax.swing.JPanel jPanel17;
    private javax.swing.JPanel jPanel18;
    private javax.swing.JPanel jPanel19;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel20;
    private javax.swing.JPanel jPanel21;
    private javax.swing.JPanel jPanel22;
    private javax.swing.JPanel jPanel23;
    private javax.swing.JPanel jPanel24;
    private javax.swing.JPanel jPanel25;
    private javax.swing.JPanel jPanel26;
    private javax.swing.JPanel jPanel27;
    private javax.swing.JPanel jPanel28;
    private javax.swing.JPanel jPanel29;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JPanel jPanel6;
    private javax.swing.JPanel jPanel7;
    private javax.swing.JPanel jPanel8;
    private javax.swing.JPanel jPanel9;
    private javax.swing.JTabbedPane jTabbedPane1;
    private javax.swing.JTextField kingLoyaltyHiText;
    private javax.swing.JTextField kingLoyaltyLoText;
    private javax.swing.JTextField maxTroopHiText;
    private javax.swing.JTextField maxTroopLoText;
    private javax.swing.JTextField meritoriousHiText;
    private javax.swing.JTextField meritoriousLoText;
    private javax.swing.JTextField mightyTypeWeightText;
    private javax.swing.JCheckBox modelGenderCheckbox;
    private javax.swing.JCheckBox modelTypeCheckbox;
    private javax.swing.JTextField moraleHiText;
    private javax.swing.JTextField moraleLoText;
    private javax.swing.JLabel moreSpecialProbLabel;
    private javax.swing.JSlider moreSpecialProbSlider;
    private javax.swing.JLabel natrualDeathProbLabel;
    private javax.swing.JSlider naturalDeathProbSlider;
    private javax.swing.JCheckBox navalSpecialLimitCheckbox;
    private javax.swing.JRadioButton noChangeTeamRadio;
    private javax.swing.JRadioButton noChangeTechniqueRadio;
    private javax.swing.JRadioButton noRandomFaceRadio;
    private javax.swing.JLabel noSpecialProb1Label;
    private javax.swing.JLabel noSpecialProb1Label1;
    private javax.swing.JLabel noSpecialProb1Label2;
    private javax.swing.JLabel noSpecialProb1Label3;
    private javax.swing.JLabel noSpecialProb1Label4;
    private javax.swing.JLabel noSpecialProb1Label5;
    private javax.swing.JLabel noSpecialProb1Label6;
    private javax.swing.JLabel noSpecialProb1Label7;
    private javax.swing.JLabel noSpecialProb1Label8;
    private javax.swing.JSlider noSpecialProb1Slider;
    private javax.swing.JSlider noSpecialProb1Slider1;
    private javax.swing.JSlider noSpecialProb1Slider2;
    private javax.swing.JSlider noSpecialProb1Slider3;
    private javax.swing.JSlider noSpecialProb1Slider4;
    private javax.swing.JSlider noSpecialProb1Slider5;
    private javax.swing.JSlider noSpecialProb1Slider6;
    private javax.swing.JSlider noSpecialProb1Slider7;
    private javax.swing.JSlider noSpecialProb1Slider8;
    private javax.swing.JCheckBox noSurnameChangeCheckbox;
    private javax.swing.JTextField normalLoyaltyHiText;
    private javax.swing.JTextField normalLoyaltyRangeText;
    private javax.swing.JTextField normalTypeWeightText;
    private javax.swing.JRadioButton officer670Radio;
    private javax.swing.JRadioButton officer700Radio;
    private javax.swing.JRadioButton officer800Radio;
    private javax.swing.JRadioButton officerAnyRadio;
    private javax.swing.ButtonGroup officerGenerationTypeGroup;
    private javax.swing.JPanel officerTypePanel;
    private javax.swing.JButton openFileButton;
    private javax.swing.JLabel parentImitateChildLabel;
    private javax.swing.JSlider parentImitateChildSlider;
    private javax.swing.JTextField politicianTypeWeightText;
    private javax.swing.JTextField ramHiText;
    private javax.swing.JTextField ramLoText;
    private javax.swing.JRadioButton randomFaceRadio;
    private javax.swing.JRadioButton randomTypeOfficerRadio;
    private javax.swing.JCheckBox randomize3dModelCheckbox;
    private javax.swing.JCheckBox randomizeAbilityCheckbox;
    private javax.swing.JCheckBox randomizeAdaptabilityCheckbox;
    private javax.swing.JRadioButton randomizeAllSpecialRadio;
    private javax.swing.JTextField randomizeAllSpecialText;
    private javax.swing.JCheckBox randomizeAttachmentCheckbox;
    private javax.swing.JRadioButton randomizeBloodImitateRadio;
    private javax.swing.JRadioButton randomizeBloodRadio;
    private javax.swing.JRadioButton randomizeBrotherRadio;
    private javax.swing.ButtonGroup randomizeCountGroup;
    private javax.swing.JCheckBox randomizeDeadOnlyCheckbox;
    private javax.swing.JCheckBox randomizeDiplomacyCheckbox;
    private javax.swing.JCheckBox randomizeFactionColourCheckbox;
    private javax.swing.JCheckBox randomizeGenderCheckbox;
    private javax.swing.JCheckBox randomizeGrowthTypeCheckbox;
    private javax.swing.JRadioButton randomizeHateRadio;
    private javax.swing.JCheckBox randomizeHiddenValuesCheckbox;
    private javax.swing.JRadioButton randomizeImitateRadio;
    private javax.swing.JCheckBox randomizeLoyaltyCheckbox;
    private javax.swing.JCheckBox randomizeMeritoriousCheckbox;
    private javax.swing.JCheckBox randomizeNameCheckbox;
    private javax.swing.JCheckBox randomizeNaturalDeathCheckbox;
    private javax.swing.JRadioButton randomizeNoBloodImitateRadio;
    private javax.swing.JRadioButton randomizeNoBloodRadio;
    private javax.swing.JRadioButton randomizeNoBrotherRadio;
    private javax.swing.JRadioButton randomizeNoHateRadio;
    private javax.swing.JRadioButton randomizeNoImitateRadio;
    private javax.swing.JRadioButton randomizeNoSpecialRadio;
    private javax.swing.JRadioButton randomizeNormalSpecialRadio;
    private javax.swing.JRadioButton randomizeSireSpecialRadio;
    private javax.swing.ButtonGroup randomizeSpecialGroup;
    private javax.swing.JRadioButton randomizeTechniqueRadio;
    private javax.swing.JCheckBox randomizeYearCheckbox;
    private javax.swing.JCheckBox resetBaseResourceCheckbox;
    private javax.swing.JCheckBox resetBaseSettingCheckbox;
    private javax.swing.JCheckBox sameProbForFactionCheckbox;
    private javax.swing.ButtonGroup selectedRandomizeOfficerButtonGroup;
    private javax.swing.JTextField shipHiText;
    private javax.swing.JTextField shipLoText;
    private javax.swing.JTextField spearHiText;
    private javax.swing.JTextField spearLoText;
    private javax.swing.JLabel spouseAttachmentProbLabel;
    private javax.swing.JSlider spouseAttachmentProbSlider;
    private javax.swing.JTextField spouseAttachmentText;
    private javax.swing.JTextField spouseDiffFactionText;
    private javax.swing.JTextField spouseNoFactionText;
    private javax.swing.JTextField spouseSameFactionText;
    private javax.swing.JTextField strongFactionAbyAbsText;
    private javax.swing.JTextField strongFactionAbyMulText;
    private javax.swing.JTextField strongFactionAdpAbsText;
    private javax.swing.JTextField strongFactionAdpMulText;
    private javax.swing.JTextField strongFactionCashHiText;
    private javax.swing.JTextField strongFactionCashInHiText;
    private javax.swing.JTextField strongFactionCashInLoText;
    private javax.swing.JTextField strongFactionCashLoText;
    private javax.swing.JTextField strongFactionCropHiText;
    private javax.swing.JTextField strongFactionCropInHiText;
    private javax.swing.JTextField strongFactionCropInLoText;
    private javax.swing.JTextField strongFactionCropLoText;
    private javax.swing.JTextField strongFactionDurabilityHiText;
    private javax.swing.JTextField strongFactionDurabilityLoText;
    private javax.swing.JTextField strongFactionHiText;
    private javax.swing.JTextField strongFactionLoText;
    private javax.swing.JTextField strongFactionMinOfficerText;
    private javax.swing.JLabel strongFactionOfficerProbLabel;
    private javax.swing.JSlider strongFactionOfficerProbSlider;
    private javax.swing.JCheckBox strongFactionRelationCheckbox;
    private javax.swing.JCheckBox strongFactionSpecialCheckbox;
    private javax.swing.JTextField strongFactionTroopHiText;
    private javax.swing.JTextField strongFactionTroopLoText;
    private javax.swing.JTextField strongFactionWeaponHiText;
    private javax.swing.JTextField strongFactionWeaponLoText;
    private javax.swing.JCheckBox swapCountryCheckbox;
    private javax.swing.ButtonGroup teamGroup;
    private javax.swing.JTextField techniqueProbHiText;
    private javax.swing.JTextField techniqueProbLoText;
    private javax.swing.JTextField troopHiText;
    private javax.swing.JTextField troopLoText;
    private javax.swing.JTextField troopMorHiText;
    private javax.swing.JTextField troopMorLoText;
    private javax.swing.JLabel typePercentageLabel;
    private javax.swing.JLabel typePercentageLabel1;
    private javax.swing.JLabel typePercentageLabel2;
    private javax.swing.JLabel typePercentageLabel3;
    private javax.swing.JLabel typePercentageLabel4;
    private javax.swing.JLabel typePercentageLabel5;
    private javax.swing.JLabel typePercentageLabel6;
    private javax.swing.JLabel typePercentageLabel7;
    private javax.swing.JLabel typePercentageLabel8;
    private javax.swing.JRadioButton typedFaceRadio;
    private javax.swing.JRadioButton typedOfficerRadio;
    private javax.swing.JCheckBox useSpecial3dModelCheckbox;
    private javax.swing.JCheckBox useSpecialGrowthTypeCheckbox;
    private javax.swing.JCheckBox useSpecialSpeechCheckbox;
    // End of variables declaration//GEN-END:variables
}
